package org.esupportail.portal.channels.CAnnuaire;

import org.jasig.portal.ChannelStaticData;
import org.jasig.portal.IServant;
import org.jasig.portal.PortalException;
import org.jasig.portal.services.LogService;

public class CAnnuaireServantFactory {

	/**
	 * Retourne une instance de CAnnuaireServant.
	 */
	public static IServant getAnnuaireServant(ChannelStaticData sd)
		throws PortalException {
		try {
			CAnnuaireServant servant = new CAnnuaireServant();
			servant.setStaticData(sd);

			return (IServant) servant;
		} catch (Exception e) {
			LogService.log(
				LogService.ERROR,
				"CAnnuaireServantFactory::getAnnuaireServant() : impossible d'initialiaser le servant : "
					+ e);
			throw (
				new PortalException(
					"CAnnuaireServantFactory - impossible d'initialiaser le servant : "
						+ e));
		}
	}
}
