/*
 * Copyright  2004 ESUP-portail consortium  
 * 
 * Authors : Cdric CHAMPMARTIN
 * 
 * This program is free software; you can redistribute it and/or modify it under the terms of the GNU General Public License as published by the Free Software Foundation augmented according to the possibility of using it with programs developped under the Apache licence published by the Apache Software Foundation.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * 
 * See the license terms site for more details : http://www.esup-portail.org/license.html
*/
package org.esupportail.portal.channels.CAnnuaire;

import org.jasig.portal.IServant;
import org.jasig.portal.ChannelStaticData;

public class CAnnuaireServant extends CAnnuaire implements IServant {

	/** 
	 * Constructeur
	 */
	public CAnnuaireServant() {
		super();
	}

	/**
	 * retourne tru ou false selon si le canal cette classe a fini de travailler
	 * pour se terminer, le canal doit recevoir : servantFinished
	 * qui est en fait le nom d'un bouton sur la feuille xsl 
	 * @return True si le servant est fini, False sinon
	 */
	public boolean isFinished() {
		if (runtimeData.getParameter("servantFinished") != null)
			return true;
		return false;
	}

	/**
	 * Ajoute un paramtre au staticData du servant
	 */
	public void setStaticData(ChannelStaticData sd) {
		sd.setParameter("CAnnuaireServantMode", "true");
		super.setStaticData(sd);
	}


	/**
	 * Retourne les Personnes trouves en rsultat de la recherche
	 * @return Object[] ( caster en Personne), Null sinon
	 */
		public Object[] getResults() {
		if (UI.getResult() != null)
			return UI.getResult().toArray();
		return null;
	}
}
