/*
 * Copyright  2004 ESUP-portail consortium  
 * 
 * Authors : Cdric CHAMPMARTIN
 * 
 * This program is free software; you can redistribute it and/or modify it under the terms of the GNU General Public License as published by the Free Software Foundation augmented according to the possibility of using it with programs developped under the Apache licence published by the Apache Software Foundation.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * 
 * See the license terms site for more details : http://www.esup-portail.org/license.html
*/
package org.esupportail.portal.channels.CAnnuaire;

import org.jasig.portal.ChannelStaticData;
import org.jasig.portal.IServant;
import org.jasig.portal.PortalException;
import org.jasig.portal.services.LogService;

public class CAnnuaireServantFactory {

	/**
	 * Retourne une instance de CAnnuaireServant.
	 */
	public static IServant getAnnuaireServant(ChannelStaticData sd)
		throws PortalException {
		try {
			CAnnuaireServant servant = new CAnnuaireServant();
			servant.setStaticData(sd);

			return (IServant) servant;
		} catch (Exception e) {
			LogService.log(
				LogService.ERROR,
				"CAnnuaireServantFactory::getAnnuaireServant() : impossible d'initialiaser le servant : "
					+ e);
			throw (
				new PortalException(
					"CAnnuaireServantFactory - impossible d'initialiaser le servant : "
						+ e));
		}
	}
}
