/*
 * Copyright  2004 ESUP-portail consortium  
 * 
 * Authors : Sbastien GAUDIN
 * 
 * This program is free software; you can redistribute it and/or modify it under the terms of the GNU General Public License as published by the Free Software Foundation augmented according to the possibility of using it with programs developped under the Apache licence published by the Apache Software Foundation.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * 
 * See the license terms site for more details : http://www.esup-portail.org/license.html
*/
package org.esupportail.portal.channels.CAnnuaire;

import java.util.Hashtable;

import javax.naming.NamingEnumeration;
import javax.naming.directory.DirContext;
import javax.naming.directory.InitialDirContext;
import javax.naming.directory.SearchControls;

import javax.naming.*;

import org.jasig.portal.services.LogService;

public class LDAPHandler {

	private String[] attributes = null;
	private int maxEntries = 0;
	private String base = null;
	private String filter = null;
	private int scope = 0;
	private String url = null;
	private String bindDn = null;
	private String bindPass = null;

	public LDAPHandler() {
	}

	public void setAttributes(String[] listAttr) {
		attributes = listAttr;
	}

	public void setMaxEntries(int max) {
		maxEntries = max;
	}

	public void setBase(String b) {
		base = b;
	}

	public void setFilter(String f) {
		filter = f;
	}

	public void setScope(int s) {
		scope = s;
	}

	public void setUrl(String u) {
		url = u;
	}
	
	public void setBindDn(String u) {
		bindDn = u;
	}
	
	public void setBindPass(String u) {
		bindPass = u;
	}


	public NamingEnumeration search() {
		NamingEnumeration results = null;

		Hashtable env = new Hashtable();
		env.put(
			Context.INITIAL_CONTEXT_FACTORY,
			"com.sun.jndi.ldap.LdapCtxFactory");
		env.put(Context.PROVIDER_URL, url);
		
		
		if(bindDn != null){
			env.put(Context.SECURITY_AUTHENTICATION, "simple");
			env.put(Context.SECURITY_PRINCIPAL,      bindDn);
			env.put(Context.SECURITY_CREDENTIALS,    bindPass);
		}


		/*Creation du contexte*/
		DirContext ctx;
		try {
			ctx = new InitialDirContext(env);
		} catch (NamingException e) {
			LogService.log(
				LogService.ERROR,
				"LDAPHandler:search() : " + e.toString());
			return (null);
		}
		
		/*Prpare l'objet qui va rcuprer la rponse*/
		SearchControls sc = new SearchControls();
		sc.setReturningAttributes(attributes);
		sc.setCountLimit(maxEntries);
		sc.setSearchScope(scope);
		/*Lance la recherche*/
		NamingEnumeration answer = null;

		try {
			answer = ctx.search(base, filter, sc);
		} catch (NamingException e) {
			LogService.log(
				LogService.ERROR,
				"LDAPHandler:search() : " + e.toString());			
		}
		finally{
			try {
				ctx.close();
			} catch (NamingException e) {
				LogService.log(
					LogService.ERROR,
					"LDAPHandler:search() : " + e.toString());
				return (null);
			}
		}

		return (answer);
	}

	public void close() {

	}

}
