/*
 * Copyright  2004 ESUP-portail consortium  
 * 
 * Authors : Sbastien GAUDIN
 * 
 * This program is free software; you can redistribute it and/or modify it under the terms of the GNU General Public License as published by the Free Software Foundation augmented according to the possibility of using it with programs developped under the Apache licence published by the Apache Software Foundation.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * 
 * See the license terms site for more details : http://www.esup-portail.org/license.html
*/
package org.esupportail.portal.channels.CAnnuaire;
public class Server {

	/**
	* Represente le nom du seveur
	*/
	private String name;

	/**
	* Represente le label du serveur
	*/
	private String title;

	/**
	* Represente l'adresse d'une application extrieure
	*/
	private String link;

	/**
	 * Represente l'adresse du serveur LDAP
	 */
	private String url;

	/**
	 * Represente le Dn de la connection
	 */
	private String bindDn;

	/**
	 * Represente le mot de passe de la connection de la connection
	 */
	private String bindPass;

	/**
	 * Represente le mot de passe de la connection de la connection
	 */
	private String intro;

	/**
	 * Represente la requete  executer
	 */
	private Query query;

	/**
	 * Represente les champs  rcuprer et  afficher
	 */
	private Display display;


	/**
	 * Retourne le nom du serveur
	 *
	 *
	 * @return Le nom (la cl) du serveur
	 */
	public String getName() {
		return name;
	} // end getBindDn

	/**
	 * Dfinit le nom du serveur
	 *
	 *
	 * @param  _name
	 */
	public void setName(String _name) {
		name = _name;
	} // end setBndDn

	/**
	 *
	 * @return le libell du serveur
	 */
	public String getTitle() {
		return title;
	} // end getBindDn

	/**
	 * Dfinit le titre du serveur
	 *
	 *
	 * @param _title
	 */
	public void setTitle(String _title) {
		title = _title;
	} // end setBndDn

	/**
	 * @return le lien vers une application externe
	 */
	public String getLink() {
		return link;
	} // end getBindDn

	/**
	 * Dfinit le lien vers une application externe
	 *
	 * @param _link
	 */
	public void setLink(String _link) {
		link = _link;
	} // end setBndDn

	/**
	 *
	 * @return l'url du serveur
	 */
	public String getUrl() {
		return url;
	} // end getUrl

	/**
	 * Dfinit l'url du serveur
	 *
	 *
	 * @param _url
	 */
	public void setUrl(String _url) {
		url = _url;
	} //end setUrl



	/**
	 * Dfinit le mot de passe pour la connection au serveur
	 *
	 *
	 * @param _bindPass
	 
	public void setBindPass(String _bindPass) {
		bindPass = _bindPass;
	} //end setBindPass*/



	/**
	 * Dfinit le dn pour la connection au serveur
	 *
	 *
	 * @param _bindDn
	 */
	public void setBinddn(String _bindDn) {
		bindDn = _bindDn;
	} //end setBindPass
	/**
	 * Dfinit le mot de passe pour la connection au serveur
	 *
	 *
	 * @param _bindPass
	 */
	public void setBindpass(String _bindPass) {
		bindPass = _bindPass;
	} //end setBindPass
	/**
	 *
	 * @return le dn pour la connection au serveur
	 */
	public String getBinddn() {
		return bindDn ;
	} //end setBindPass
	/**
	 *
	 * @return le mot de passe pour la connection au serveur
	 */
	public String getBindpass() {
		return bindPass;
	} //end setBindPass


	/**
	 * 
	 * @return l'objet Display, qui contient tous les lments  afficher dans le rsultat de la recherche
	 */
	public Display getDisplay() {
		return display;
	} // end getDisplay

	/**
	 * Sauvegarde l'objet Display, qui contient tous les lments  afficher 
	 * dans le rsultat de la recherche
	 *
	 * @param _display
	 */
	public void setDisplay(Display _display) {
		display = _display;
	} // end setDisplay

	/**
	 * Retourne l'objet Query, qui contient tous les lments  afficher dans le formulaire de recherche
	 *
	 *
	 * @return un Query 
	 */
	public Query getQuery() {
		return query;
	} // end getQuery

	/**
	 * Sauvegarde l'objet Query, qui contient tous les lments  afficher 
	 * dans le formulaire de recherche
	 *
	 *
	 * @param _query
	 */
	public void setQuery(Query _query) {
		query = _query;
	} // end set

	/**
	 * Retourne la phrase d'introduction sur le formulaire
	 * 
	 * @return la phrase 
	 */
	public String getIntro() {
		return intro;
	}

	/**
	 * Dfinit la phrase d'introduction sur le formulaire
	 * 
	 * @param string
	 */
	public void setIntro(String string) {
		intro = string;
	}

} // end Server
