/*
 * Copyright  2004 ESUP-portail consortium  
 * 
 * Authors : Sbastien GAUDIN
 * 
 * This program is free software; you can redistribute it and/or modify it under the terms of the GNU General Public License as published by the Free Software Foundation augmented according to the possibility of using it with programs developped under the Apache licence published by the Apache Software Foundation.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * 
 * See the license terms site for more details : http://www.esup-portail.org/license.html
*/

package org.esupportail.portal.channels.CAnnuaire;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.directory.SearchResult;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.esupportail.portal.channels.CAnnuaire.LDAP.Exceptions.*;

public class ElmOfQuery {

    private static final Log log = LogFactory.getLog(CAnnuaire.class);
    /**
	 * Represente le type de donne (direct, listTable, ... )
	 */
	private String type;

	/**
	 * Represente le filtre li  cet attribut
	 */
	private String filter;

	/**
	 * Represente le label  afficher dans le formulaire
	 */
	private String label;

	/**
	 * Represente la table lie  cet attribut dans le cas ou la valeur provient d'un table
	 */
	private String table;

	/**
	 * Represente le nombre minimum de caractre  saisir
	 */
	private int minChar = 0;

	/**
	 * Represente la valeur dans le cas d'une zone de texte
	 */
	private String searchValue = "*%s*";

	/**
	 * Represente le nombre maximum de rsultat que LDAP va renvoyer
	 */
	private int maxEntries = 0;

	/**
	 * Represente si les "*" saisies par l'utilisateur seront supprimes
	 */
	private String delStar = "false";

	/**
	 * Represente le nom html du champ (pas dans la config, ce nom est donn automatiquement)
	 */
	private String nameHtml;

	/**
	 * Retourne le label  afficher dans le formulaire
	 *
	 *
	 * @return le label
	 */
	public String getLabel() {
		return label;
	} // end getLabel

	/**
	 * Dfinit le label  afficher dans le formulaire
	 *
	 *
	 * @param le label
	 */
	public void setLabel(String _label) {
		label = _label;
	} // end setLabel

	/**
	 * Dans le cas ou la valeur provient d'un table
	 * retourne la table lie  cet attribut 
	 *
	 *
	 * @return le nom de la table
	 */
	public String getTable() {
		return table;
	} // end getTable

	/**
	 * Dans le cas ou la valeur provient d'un table
	 * dfinit la table lie  cet attribut 
	 *
	 * @param le nom de la table
	 */
	public void setTable(String _table) {
		table = _table;
	} // end setTable

	/**
	 *retourne le type d'lment
	 *
	 * @return le nom de la table
	 */
	public String getType() {
		return type;
	} // end getType

	/**
	 * Dfinit le type d'lment
	 *
	 * @param type
	 */
	public void setType(String _type) {
		type = _type;
	} // end setType

	/**
	 * Retourne le filtre engendr par cet lment pour la requete LDAP
	 *
	 *
	 * @return le filtre
	 */
	public String getFilter() {
		return filter;
	} // end getFilter

	/**
	 * Dfinit le filtre engendr par cet lment pour la requete LDAP
	 * 
	 * @param le filter
	 */
	public void setFilter(String _filter) {
		filter = _filter;
	} // end setFilter

	/**
	 * Remplace les caractres %s et %c du filtre par la valeur passe en aramtre 
	 * 
	 * @param _value
	 * @return le filtre engendr
	 */
	public String updateFilter(String _value,Table T,String urlServeur) {
		String filtreLocal = "";
		if ((_value != null) && (_value.length() > 0)) {
			if (type.equals("text")) {
				filtreLocal = filter.replaceAll("%s", _value);
			} else if (type.equals("direct")) {
				filtreLocal = filter;
			} else if (type.equals("listTable")) {
				filtreLocal = filter.replaceAll("%c", _value);
			} else if (type.equals("textTable")) {				
					
				/*Met les attributs LDAP  rcuprer dans un tableau de chaines*/
				String[] attrIDs = new String[1];
				attrIDs[0] = T.getAttrCode();
				LDAPHandler LDAP = new LDAPHandler();
				LDAP.setUrl(urlServeur);
				LDAP.setAttributes(attrIDs);
				LDAP.setMaxEntries(getMaxEntries());
				LDAP.setBase(T.getBase());
				String filtreTmp =
					"(&"
						+ T.getFilter()
						+ "("
						+ T.getAttrValue()
						+ "="
						+ searchValue.replaceAll("%s", _value)
						+ "))";
				LDAP.setFilter(filtreTmp);

				LDAP.setScope(T.getScopeNum());
				NamingEnumeration answer = null; 
				try {
					answer = LDAP.search();
				} catch (LDAPException e1) {
					log.error("UpdateAction:visualisation() : LDAPException : "+e1);
				}
				filtreLocal += "(|";
				if (answer != null) {
					try {
						while (answer.hasMore()) {
							SearchResult sr;
							try {
								sr = (SearchResult) answer.next();
								filtreLocal += "("
									+ getFilter().replaceAll(
										"%c",
										(String) sr
											.getAttributes()
											.get(
											attrIDs[0]).get(
											0))
									+ ")";

							} catch (NamingException f) {
							    log.error("Table::loadItems() : Parcours les rponses NullPointerException : "
										+ f.toString());
								break;
							}
						}
					} catch (NullPointerException f) {
					    log.error("Table::loadItems() : aucune rponse : "
								+ f.toString());
					} catch (NamingException f) {
					    log.error("Table::loadItems() : "
								+ f.toString());
					}
					finally{
						LDAP.close();
					}
				}
			filtreLocal += ")";
			}
		} else {
			filtreLocal = "";
		}
		return (filtreLocal);
	} // end setFilter

	/**
	 * Retourne le nom de html de l'lment du formulaire
	 * 
	 * @return le nom html
	 */
	public String getNameHtml() {
		return nameHtml;
	}

	/**
	 * Dfinit le nom de html de l'lment du formulaire
	 * ce nom n'est pas dans la config mais il est donn automatiquement
	 * 
	 * @param le nom de html
	 */
	public void setNameHtml(String _nameHtml) {
		nameHtml = _nameHtml;
	}

	/**
	 * Dans le cas d'une zone de type text
	 * Retourne le nombre minimum de caractres  saisir
	 * 
	 * @return  le nombre minimum de caractres
	 */
	public int getMinChar() {
		return minChar;
	}

	/**
	 * Dans le cas d'une zone de type text
	 * Dfinit le nombre minimum de caractres  saisir
	 * 
	 * @param le nombre minimum de caractres
	 */
	public void setMinChar(int _minChar) {
		minChar = _minChar;
	}

	/**
	 * Dans le cas d'une zone de type textTable
	 * retourne le masque de saisie (ex : *%s*)
	 * 
	 * @return le masque
	 */
	public String getSearchValue() {
		return searchValue;
	}

	/**
	 * Dans le cas d'une zone de type textTable
	 * Dfinit le masque de saisie (ex : *%s*)
	 * 
	 * @param le masque
	*/ 
	public void setSearchValue(String _searchValue) {
		searchValue = _searchValue;
	}

	/**
	 * Dans le cas d'une zone de type textTable ou listTable
	 * retourne le nombre maximum de rsultats  rcuprer
	 * 
	 * @return le nombre maximum de rsultats
	 */
	public int getMaxEntries() {
		return maxEntries;
	}

	/**
	 * Dans le cas d'une zone de type textTable ou listTable
	 * dfnit le nombre maximum de rsultat  rcuprer
	 * 
	 * @param le nombre maximum de rsultats
	 */
	public void setMaxEntries(int i) {
		maxEntries = i;
	}

	/**
	 * Retourne si oui ou non, les '*' saisies par l'utilisateur sera supprime
	 * 
	 * @return true / false 
	 */
	public boolean getDelStarBool() {
		if (delStar.equals("true"))
			return true;
		else
			return false;
	}

	/**
	 * Dfinit si oui ou non, les '*' saisies par l'utilisateur sera supprime
	 * 
	 * @param "true" / "false" 
	 */
	public void setDelStar(String string) {
		delStar = string;
	}

} // end ElmOfQuery
