/*
 * Copyright  2004 ESUP-portail consortium  
 * 
 * Authors : Sbastien GAUDIN
 * 
 * This program is free software; you can redistribute it and/or modify it under the terms of the GNU General Public License as published by the Free Software Foundation augmented according to the possibility of using it with programs developped under the Apache licence published by the Apache Software Foundation.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * 
 * See the license terms site for more details : http://www.esup-portail.org/license.html
*/
package org.esupportail.portal.channels.CAnnuaire;

import java.util.*;

public class Personne {


	/**
	 * Represente les attributs LDAP d'une personne
	 */
	private Hashtable attributes = new Hashtable();
	
	/**
	 * Represente la valeur de l'attributs LDAP servant de tri
	 */
	private String attTri;
	
	/**
	 * Represente la valeur de l'attributs LDAP servant d'identifant3
	 */
	private String identifiant;

	/**
	 * Routrne les attributs d'une personne rsultat
	 * 
	 * @return tous les attributs indxs sur le nom LDAP
	 */
	public Hashtable getAttributes() {
		return attributes;
	}


	/**
	 * Routrne la/les valeurs de l'attribut dont le code est pass en paramtre
	 * 
	 * @return la valeur de l'attribut
	 */
	public Vector getAttribute(String idLdap) {
		if (attributes.get(idLdap) != null)
			return ((Line) attributes.get(idLdap)).getValues();
		else
			return null;
	}

	/**
	 * Ajoute un attribut  la personne 
	 * 
	 * @param un attribut
	 */
	public void addAttributes(Line attr) {
		if ((attr != null) && (attr.getLabel() != ""))
			attributes.put(attr.getAttribute(), attr);
	}


	/**
	 * Ajoute la valeur de tri de la personne
	 * 
	 * @param la valeur de tri
	 */
	public void addTri(String value) {
		attTri = value;
	}


	/**
	 * Retourne une chaine xml pour prsenter tous les attributs d'une personne
	 * L'ordre de ces attributs est le Vecter pass en paramtre
	 * 
	 * @param ordre des attributs
	 * @return chaine XML
	 */
	public String toXml(Vector ordre) {
		String xml = "";
		if (attributes != null) {
			xml += "<resultat>\n";
			xml += "<attributTri  value=\"" + attTri + "\" />\n";
			xml += "<attributId value=\"" + identifiant + "\" />\n";
			Iterator i = ordre.iterator();
			while (i.hasNext()) {
				String attrCle = (String) i.next();
				Line attr = (Line) attributes.get(attrCle);
				xml += "<attributRes ";
				xml += "display=\"" + attr.getLabel() + "\" ";
				if (attr.getList())
					xml += "list=\"1\" ";
				else
					xml += "list=\"0\" ";
				if (attr.getTabToCard())
					xml += "linkToCard=\"1\" ";
				else
					xml += "linkToCard=\"0\" ";
				xml += " >\n";

				if (attr.getValues() != null) {
					Enumeration val = attr.getValues().elements();
					if (val != null) {
						while (val.hasMoreElements()) {
							String v = (String) val.nextElement();
							if (v.indexOf('$')>=0){
								/*
									Si la chaine contient des $, cela simule un attribut multivalu
									ce qui permet d'avoir un retour  la ligne
								*/
								xml += "<valeur>";
								StringBuffer result = new StringBuffer();  
							     char [] c = v.toCharArray();  
							  
							     for(int caract=0;caract<c.length;caract++) {  
							          char tmp = c[caract];  
							          switch(tmp) {  
							               case '$':xml += "</valeur>\n<valeur>";break;  
							               default:xml += tmp; 
							          }  
							     } 

							     xml += "</valeur>\n";
							}
							else{
							xml += "<valeur>"
								+ userInterface.valueToXml(v)
								+ "</valeur>\n";
							}
						}
					}
				}

				xml += "</attributRes>\n";
			}
			xml += "</resultat>\n";
		}

		return xml;
	}

	/**
	 * Retourne la valeur de l'identifiant de cette personne
	 * 
	 * @return la valeur de l'identifiant
	 */
	public String getIdentifiant() {
		return identifiant;
	}

	/**
	 * Dfinit la valeur de l'identifiant de cette personne
	 * 
	 * @param la valeur de l'identifiant
	 */
	public void setIdentifiant(String string) {
		identifiant = string;
	}

}
