/*
 * Copyright  2004 ESUP-portail consortium  
 * 
 * Authors : Sbastien GAUDIN
 * 
 * This program is free software; you can redistribute it and/or modify it under the terms of the GNU General Public License as published by the Free Software Foundation augmented according to the possibility of using it with programs developped under the Apache licence published by the Apache Software Foundation.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * 
 * See the license terms site for more details : http://www.esup-portail.org/license.html
*/
package org.esupportail.portal.channels.CAnnuaire;

import java.io.IOException;
import java.net.URL;
import java.util.*;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.directory.SearchControls;
import javax.naming.directory.SearchResult;
import org.apache.commons.digester.Digester;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.esupportail.portal.channels.CAnnuaire.LDAP.*;
import org.esupportail.portal.channels.CAnnuaire.LDAP.Exceptions.LDAPException;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class Table {

    private static final Log log = LogFactory.getLog(CAnnuaire.class);
	/**
	 * Represente le nom de la table
	 */
	private String name;
	
	/**
	 * Represente le type de la table (LDAP, XML, statique)
	 */
	private String type;
	
	/**
	 * Si la table est du type LDAP : 
	 * indique le mode de recherche dans LDAP
	 */
	private String scope;
	
	/**
	 * Si la table est du type LDAP : 
	 * indique la base de recherche dans LDAP
	 */
	private String base;
	
	/**
	 * Si la table est du type LDAP : 
	 * indique le nom de l'attribut "code"
	 */
	private String attrCode;
	
	/**
	 * Si la table est du type LDAP : 
	 * indique le nom de l'attribut "value"
	 */
	private String attrValue;

	/**
	 * Si la table est du type LDAP : 
	 * indique le filtre appliqu pour slectionner les lmnts
	 */
	private String filter;
	
	/**
	 * Si la table est du type LDAP : 
	 * indique l'attribut servant  ordonner les rsultats
	 */
	private String fieldOrder;

	/**
	 * Si la table est du type LDAP : 
	 * indique l'adresse du serveur LDAP
	 */
	private String url;

	/**
	 * Si la table est du type LDAP : 
	 * indique le Dn de la connection
	 */
	private String bindDn;

	/**
	 * Si la table est du type LDAP : 
	 * indique le mot de passe de la connection de la connection
	 */
	private String bindPass;
	
	/**
	 * Si la table est du type XML : 
	 * indique le chemin vers le fichier qui contient la table
	 */
	private String file;

	/**
	 * Represente la liste des items, indxe par le code
	 */
	private Hashtable listeItems;

	public Table() {
		listeItems = new Hashtable();
	}
	
	/**
	 * Permet d'ajouter un lment  la table
	 * si on connait son code, sa valeur et son ordre
	 * si on ne connait son code, il est valu automatiquement
	 * 
	 * @param String code
	 * @param String value
	 * @param String ordreValue
	 */
	public void addItem(String code, String value, String ordreValue) {
		itemTable iT = new itemTable();
		if (code == null)
			code = "code" + listeItems.size();
		
		iT.setCode(code);
		iT.setValue(value);
		iT.setOrderValue(ordreValue);
		listeItems.put(code, iT);
	}

	/**
	 * Retourne les lments de la table
	 * 
	 * @return une Hashtable indxe sur le code des lments
	 */
	public Hashtable getItems() {
		return listeItems;
	}

	/**
	 * Retourne l'lment de la table dont le code est pass en paramtre
	 * 
	 * @param code
	 * @return un itemTable
	 */
	public itemTable getItem(String code) {
		return (itemTable) listeItems.get(code);
	}

	/**
	 * Le nom du fichier utilis (dans le cas d'une table XML)
	 * 
	 * @return le nom du fichier
	 */
	public String getFile() {
		return file;
	}


	/**
	 * Retourne le nom de la table
	 * 
	 * @return Le nom de la table
	 */
	public String getName() {
		return name;
	}

	/**
	 * dans le cas d'une table LDAP
	 * Retrourne le mode de recherche dans LDAP 
	 *  
	 * @return le scope
	 */
	public String getScope() {
		return scope;
	}

	/**
	 * dans le cas d'une table LDAP
	 * Retrourne le mode de recherche dans LDAP sous forme numrique
	 * 
	 * @return SearchControls.SUBTREE_SCOPE ou SearchControls.ONELEVEL_SCOPE
	 */
	public int getScopeNum() {
		int a;
		if (scope.equalsIgnoreCase("sub")) {
			a = SearchControls.SUBTREE_SCOPE;
		} else {
			a = SearchControls.ONELEVEL_SCOPE;
		}
		return a;
	}

	/**
	 * Retourne le type le la table
	 * 
	 * @return Xml, Ldap, statique
	 */
	public String getType() {
		return type;
	}

	/**
	 * dans le cas d'une table XML
	 * Dfinit le fichier  utiliser pour charger les lments
	 * 
	 * @param string
	 */
	public void setFile(String string) {
		file = string;
	}

	/**
	 * Dfinit le nom de la table
	 * 
	 * @param string
	 */
	public void setName(String string) {
		name = string;
	}

	/**
	 * dans le cas d'une table LDAP	
	 * dfinit le mode de recherche dans LDAP 
	 * 	
	 * @param string
	 */
	public void setScope(String string) {
		scope = string;
	}

	/**
	 * Dfnit le type de la table (Xml, Ldap, statique)
	 * 
	 * @param string
	 */
	public void setType(String string) {
		type = string;
	}




	/**
	 * Lance la fonction de chargement des lments
	 * suivant le type de la table
	 *  
	 */
	public void loadItems() {
		if (type.equals("xml")) {
			loadItemXml();
		} else if (type.equals("ldap")) {
			loadItemLdap();
		} else if (type.equals("static")) {
			/*item ajout lors de la lecture du fichier de config*/
		}
	}

	/**
	 * Dans le cas d'une table LDAP	
	 * retourne le filtre LDAP des lments de la table
	 * 
	 * @return le filtre LDAP
	 */
	public String getFilter() {
		return filter;
	}

	/**
	 * Dans le cas d'une table LDAP	
	 * dfinit le filtre LDAP des lments de la table
	 * 
	 * @param _filter
	 */
	public void setfilter(String _filter) {
		filter = _filter;
	}

	/**
	 * fonction de chargement des lments pour une table de type xml
	 * 
	 */
	private void loadItemXml() {
		Digester digester = new Digester();
		digester.setValidating(true);
		digester.push(this);

		/*MONTAGE DES TABLES*/
		digester.addCallMethod("list/item", "addItem", 3);
		digester.addCallParam("list/item", 0, "code");
		digester.addCallParam("list/item", 1, "value");
		digester.addCallParam("list/item", 2, "fieldOrder");

		Class requestingClass = this.getClass();
		//Emplacement du fichier de config  parser  partir du rpertoire classes
		URL resourceURL = requestingClass.getResource(file);

		try {
			digester.parse(new InputSource(resourceURL.toExternalForm()));

		} catch (IOException e) {
		    log.error("Table::loadItemXml() : ERREUR : Impossible d'ouvrir le fichier de config : "
		            + file
					+ "\n"
					+ e.toString());
		} catch (SAXException e) {
		    log.error("Table::loadItemXml() : ERREUR : SAXException :\n"
					+ e.toString());		   
		} catch (Exception e) {
		    log.error("Table::loadItemXml() : ERREUR : \n" + e.toString());
		}
	}


	/**
	 * fonction de chargement des lments pour une table de type ldap
	 * 
	 */
	private void loadItemLdap() {

		/*Met les attributs LDAP  rcuprer dans un tableau de chaines*/
		int NbChamp = 2;
		if (fieldOrder != null)
			NbChamp++;
		String[] attrIDs = new String[NbChamp];
		attrIDs[0] = attrCode;
		attrIDs[1] = attrValue;
		if (fieldOrder != null)
			attrIDs[2] = fieldOrder;
		
		/*Instanciation de l'objet de recherche LDAP*/
		LDAPHandler LDAP = new LDAPHandler();
		LDAP.setUrl(url);
		LDAP.setBindDn(bindDn);
		LDAP.setBindPass(bindPass);
		LDAP.setAttributes(attrIDs);
		LDAP.setMaxEntries(0);
		LDAP.setBase(base);
		LDAP.setFilter(filter);
		LDAP.setScope(this.getScopeNum());
		NamingEnumeration answer = null; 
		try {
			answer = LDAP.search();
		} catch (LDAPException e1) {
			log.error("UpdateAction:visualisation() : LDAPException : "+e1);
		}
		/*Parcours les rponses*/
		if (answer != null) {
			try {
				while (answer.hasMore()) {

					SearchResult sr;
					try {
						sr = (SearchResult) answer.next();

					} catch (NamingException e) {
					    log.error("Table::loadItemLdap() : Parcours les rponses NullPointerException : "
								+ e.toString());	
						LDAP.close();
						break;
					}

					// F. Jammes
					// Si le code de la table est un DN
					// on considre que attrCode n'est pas renseign
					String itemCode;
					if (attrCode != null) {
						itemCode = (String) sr.getAttributes().get(attrIDs[0]).get(0);
					}
					else {
						itemCode = sr.getName()+","+base;
					}
					
					
					if (fieldOrder != null) {
						addItem(
							itemCode,
							(String) sr.getAttributes().get(attrIDs[1]).get(0),
							(String) sr.getAttributes().get(attrIDs[2]).get(0));
					}
					else {
						addItem(
							itemCode,
							(String) sr.getAttributes().get(attrIDs[1]).get(0),
							null);
					}
				}
			} catch (NullPointerException e) {
			    log.error("Table::loadItemLdap() : aucune rponse pour la table "+this.name+" : " + e.getMessage());
			    LDAP.close();
			} catch (NamingException e) {
			    log.error("Table::loadItemLdap() : search : " + e.getMessage());
			    LDAP.close();
			}
		}
	}
	
	/**
	 * Dans le cas d'une table LDAP	
	 * retourne la base de recherche dans LDAP
	 * 
	 * @return la base de recherche dans LDAP
	 */
	public String getBase() {
		return base;
	}

	/**
	 * Dans le cas d'une table LDAP	
	 * dfinit la base de recherche dans LDAP
	 * 
	 * @param string
	 */
	public void setBase(String string) {
		base = string;
	}

	/**
	 * Dans le cas d'une table LDAP	
	 * retourne le nom de l'attribut "code"
	 * 
	 * @return le nom de l'attribut LDAP 
	 */
	public String getAttrCode() {
		return attrCode;
	}

	/**
	 * Dans le cas d'une table LDAP	
	 * retourne le nom de l'attribut "value"
	 * 
	 * @return le nom de l'attribut LDAP 
	 */
	public String getAttrValue() {
		return attrValue;
	}

	/**
	 * Dans le cas d'une table LDAP	
	 * 
	 * @param string
	 */
	public void setAttrCode(String string) {
		attrCode = string;
	}

	/**
	 * Dans le cas d'une table LDAP	
	 * 
	 * @param string
	 */
	public void setAttrValue(String string) {
		attrValue = string;
	}

	/**
	 * Dans le cas d'une table LDAP
	 * retourne le Dn de la connection
	 * 
	 * @return le Dn de la connection
	 */
	public String getBindDn() {
		return bindDn;
	}

	/**
	 * Dans le cas d'une table LDAP	
	 * retourne l'url du serveur LDAP
	 * 
	 * @return l'url
	 */
	public String getUrl() {
		return url;
	}

	
	/*DEB SUPPRESSION*/
	/**
	 * Dans le cas d'une table LDAP	
	 * dfinit le Dn de connection
	 * 
	 * @param string
	 * /
	public void setBindDn(String string) {
		bindDn = string;
	}

	/**
	 * Dans le cas d'une table LDAP	
	 * dfinit le mot de passe de connection
	 * 
	 * @param string
	 * /
	public void setBindPass(String string) {
		bindPass = string;
	}
	
	
	/*FIN SUPPRESSION*/

	/**
	 * Dans le cas d'une table LDAP	
	 * dfinit l'url du serveur LDAP
	 * 
	 * @param string
	 */
	public void setUrl(String string) {
		url = string;
	}

	/**
	 * Dans le cas d'une table LDAP	
	 * retourne le nom de l'attribut LDAP qui sert de tri
	 * 
	 * @return le nom de l'attribut
	 */
	public String getFieldOrder() {
		return fieldOrder;
	}

	/**
	 * Dans le cas d'une table LDAP	
	 * dfinit le nom de l'attribut LDAP qui sert de tri
	 * 
	 * @param string
	 */
	public void setFieldOrder(String string) {
		fieldOrder = string;
	}

	
	/**
	 * Dans le cas d'une table LDAP	
	 * dfinit le Dn de connection
	 * 
	 * @param string
	 */
	public void setBinddn(String _bindDn) {
		bindDn = _bindDn;
	} //end setBindPass
	/**
	 * Dans le cas d'une table LDAP	
	 * dfinit le mot de passe de connection
	 * 
	 * @param string
	 */
	public void setBindpass(String _bindPass) {
		bindPass = _bindPass;
	} //end setBindPass
	
	public String getBinddn() {
		return bindDn ;
	} //end setBindPass

	public String getBindpass() {
		return bindPass;
	} //end setBindPass

}
