/*
 * Copyright  2004 ESUP-portail consortium  
 * 
 * Authors : Sbastien GAUDIN
 * 
 * This program is free software; you can redistribute it and/or modify it under the terms of the GNU General Public License as published by the Free Software Foundation augmented according to the possibility of using it with programs developped under the Apache licence published by the Apache Software Foundation.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * 
 * See the license terms site for more details : http://www.esup-portail.org/license.html
*/
package org.esupportail.portal.channels.CAnnuaire;
import java.util.*;
import javax.naming.directory.*;


public class Query {

	/**
	 * Represente la liste des lments prsents sur le formulaire
	 * indxs par le nom html du champ
	 */
	private Hashtable elements = new Hashtable();

	/**
	 * Represente l'ordre des lments prsents sur le formulaire
	 */
	private Vector ordreElements = new Vector();
	
	/**
	 * Represente la base LDAP de recherche
	 */
	private String base;

	/**
	 * Represente le nombre maximum que le serveur peut retourner
	 */
	private int maxEntries;

	/**
	 * Represente le type de recehrche effectu 
	 * (SearchControls.SUBTREE_SCOPE ONELEVEL_SCOPE) 
	 */
	private int scope;

	/**
	 * Represente l'identifiant (champ LDAP) d'un rsultat
	 * sert pour passer de l'affichage du tableau  l'affichage
	 * en mode fiche
	 */
	private String identifiant;


	/**
	 * Represente le libell de l'identifiant (champ LDAP) d'un rsultat
	 * sert ajouter ce critre une fois arriv sur le mode fiche
	 * depuis le mode tableau
	 */
	private String identifiantLabel;

	
	/**
	 * @return l'identifiant (champ LDAP) d'un rsultat
	 */
	public String getIdentifiant() {
		return identifiant;
	}

	/**
	 * Dfinit l'identifiant (champ LDAP) d'un rsultat
	 * 
	 * @param string
	 */
	public void setIdentifiant(String string) {
		identifiant = string;
	}

	/**
	 *
	 * @return la base LDAP de recherche
	*/ 
	public String getBase() {
		return base;
	} // end getBase

	/**
	 * Dfinit la base LDAP de recherche
	 *
	 *
	 * @param la base
	*/ 
	public void setBase(String _base) {
		base = _base;
	} // end setBase

	/**
	 * Ajoute un lment au formulaire de recherche
	 *
	 * @param un lment
	 */
	public void addElement(ElmOfQuery _elem) { 
		_elem.setNameHtml("element" + elements.size());
		elements.put(_elem.getNameHtml(),_elem);
		ordreElements.add(_elem.getNameHtml());
	} // end addElement

	/**
	 * Retourne tous les lments du formulaire
	 * 
	 * @return les lments indexs sur le nom html
	 */
	public Vector getElements() {
		return (ordreElements);
	}

	/**
	 * Retourne un lment du formulaire dont le nom html est pass en paramtre
	 * 
	 * @param nameHtml
	 * @return l'lment demand
	*/
	public ElmOfQuery getElement(String nameHtml) {
		return ((ElmOfQuery)elements.get(nameHtml));
	} 


	/**
	 * Dans le cas d'une liste droulante
	 * Retourne le nombre maximum d'lments que LDAP doit retourner
	 *  
	 * @return le nombre maximum d'lments
	*/ 
	public int getMaxEntries() {
		return maxEntries;
	}

	/**
	 * Dans le cas d'un lien avec une table
	 * Dfninit le nombre maximum d'lments que LDAP doit retourner
	 * 
	 * @param maxEntries
	*/ 
	public void setMaxEntries(int _maxEntries) {
		maxEntries = _maxEntries;
	}

	/**
	 * Dans le cas d'un lien avec une table
	 * Retrourne le mode de recherche dans LDAP 
	 * 
	 * @return SearchControls.SUBTREE_SCOPE ou SearchControls.ONELEVEL_SCOPE
	 */
	public int getScope() {
		return scope;
	}

	/**
	 * Dans le cas d'un lien avec une table
	 * dfinit le mode de recherche dans LDAP 
	 * 
	 * @param scope
	 */
	public void setScope(String _scope) {
		if (_scope.equalsIgnoreCase("sub")) {
			scope = SearchControls.SUBTREE_SCOPE;
		} else {
			scope = SearchControls.ONELEVEL_SCOPE;
		}
	}

	/**
	 * Retourne le libell de l'identifiant (champ LDAP) d'un rsultat 
	 * 
	 * @return le libell
	 */
	public String getIdentifiantLabel() {
		return identifiantLabel;
	}

	/**
	 * Dfinit le libell de l'identifiant (champ LDAP) d'un rsultat
	 * sert ajouter ce critre une fois arriv sur le mode fiche
	 * depuis le mode tableau
	 * 
	 * @param le libell
	 */
	public void setIdentifiantLabel(String string) {
		identifiantLabel = string;
	}

} // end Query