<?xml version="1.0" encoding="ISO-8859-1" ?>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">

<xsl:import href = "./CAnnuaireAlertes.xsl" />

 	<xsl:import href = "./CAnnuaireEntete.xsl" />

	<xsl:import href = "./CAnnuaireCritere.xsl" />

   <xsl:param name="nomId">donne par le code</xsl:param>

   <xsl:param name="baseActionURL">donne par le code</xsl:param>

   <xsl:param name="modeServant">none</xsl:param>


   <xsl:template match="RACINE">
   
   <xsl:apply-templates select = "ALERT" />  
   
   <xsl:apply-templates select = "tagEnglobant" />  
 
   </xsl:template>
   
   <xsl:template match="tagEnglobant">
   	  <form action="{$baseActionURL}" method="post">	
   	
   	  	
   	<table align="center">
   	
   	<tr><td>
   	<xsl:call-template name = "entete" />
   	</td></tr>
   

   	<tr><td align="center">
   	<xsl:call-template name = "critere" />
   	</td></tr>
   	   	
   	
   	<tr>
   	<td align="center">
   	
   	<table border="1" cellpadding="2" cellspacing="3"> 
   	
   	<tr class="uportal-background-light">   
		<xsl:if test="$modeServant!='none'">
			<th class="uportal-channel-table-caption">&#160;</th>
		</xsl:if>	
		<xsl:apply-templates select = "attributEntete" />
   	</tr> 
   	  	
   	
   	<xsl:apply-templates select = "resultat" >   	
   	<xsl:sort select="attributTri/@value"/>
   	</xsl:apply-templates>
   	
   	</table>
   	
   	</td>
   	</tr>
   	
   </table>

      <xsl:if test="$modeServant!='none'">
         <center>
         		<br/>
         		<input type="hidden" value="root" name="uP_root" />
               <input type="submit" name="servantFinished" value="Slectionner" class="uportal-button" />
         </center>
      </xsl:if>
      </form>
   	
   </xsl:template>
   
   

   
   
<!--AFFICHAGE DES ENTETES EN FONCTION DES ATTRIBUTS RECHERCHES-->
   <xsl:template match="attributEntete">   
   <xsl:if test = "@list=1">
   	<th class="uportal-channel-table-caption" ><xsl:value-of select="@display" /></th>
   </xsl:if>
   </xsl:template>
   
<!--AFFICHAGE DES LIGNES RESULTAT-->
   <xsl:template match="resultat">
		<tr>
	      	 <xsl:if test="$modeServant!='none'">
	            <td class="uportal-channel-text">
	            <xsl:choose>
	         		<xsl:when test="$modeServant='multiple'">
	                <input type="checkbox" name="pers_id[]" value="{attributId/@value}" />
	                </xsl:when>
	                <xsl:when test="$modeServant='single'">
	                <input type="radio" name="pers_id" value="{attributId/@value}" />
	                </xsl:when>
	            </xsl:choose>    
	            </td>
	         </xsl:if>
    		<xsl:apply-templates select = "attributRes" />
		</tr>
   </xsl:template>
   
   
<!--AFFICHAGE DES LIGNES RESULTAT-->
   <xsl:template match="attributRes"> 
	   <xsl:if test = "@list=1">
	   	  <xsl:choose>
		   	  <xsl:when test = "@linkToCard=1">
			   <td class="uportal-channel-text">
			   	<a class="uportal-channel-text" href="{$baseActionURL}?etat=Detail&amp;id={../attributId/@value}"><xsl:value-of select="valeur" /></a><br />			   
			   </td>
		   	  </xsl:when>
		   	  
		   	  <xsl:when test = "count(valeur)=0">
			   <td class="uportal-channel-text">
			   &#160;<!--espace-->
			   </td>
		   	  </xsl:when>
			  
			  <xsl:otherwise>
			   <td class="uportal-channel-text">
			   <xsl:for-each select = "valeur">
			      <xsl:value-of select="current()" /><br />
			   </xsl:for-each>
			   </td>
			  </xsl:otherwise> 
		  </xsl:choose>
	   </xsl:if>
   </xsl:template>
   
   
</xsl:stylesheet>

