/*

ESUP-portail is a french academic project developed under the GPL (General Public License)
augmented according to the following :

A binary or source file developped by ESUP-portail can be used or compiled with products under Apache license.

The official english text of the GPL can be found here : http://www.gnu.org/licenses/gpl.html .

A non official french translation can be found here : http://www.linux-France.org/article/these/gpl.html .

The different kinds of licenses governing the products developed by the Apache
foundation can be found here : http://www.apache.org/licenses .

It follows that you can as well as use download contents as well modify and redistribute
them provided you respect the GPL terms.

Downloading and using such contents do not provide any guaranty.

Be sure that you have well understood the terms of the license before using the contents it covers.

The ESUP-portail distribution includes the following distributions :

* UPortal :
software developed by JA-SIG (Java Architecture - Special Interest Group)
You can find the license page here : http://mis105.udel.edu/ja-sig/uportal/license.html

* CAS :
SSO solution developed by Yale University
You can find the project page here : http://www.yale.edu/tp/auth

* Cocoon :
XML framework distributed by the Apache foundation under Apache license;
Please find the full text here : http://cocoon.apache.org/2.1/license.html

* Mod_dav:
A DAV module for Apache web server
You can find the project page here : http://www.webdav.org/mod_dav

* IMP :
webmail from Horde application framework
You can find the project page here : http://www.horde.org
*/
package org.esupportail.portal.channels.CAnnuaire;

import java.util.Vector;

import javax.naming.NamingEnumeration;

public class Line {

	/**
	 * Represente le libell  afficher
	 */
	private String label;

	/**
	 * Represente le type de donne  afficher (rsultat d'une liste, champ direct, ...)
	 */
	private String type;

	/**
	 * Represente le nom de l'attribut ldap a afficher
	 */
	private String attribute;

	/**
	 * Represente si cet attribut est prsent dans la liste rsultat sous forme de tableau
	 */
	private boolean list;

	/**
	 * Represente le nom de la table monte en config si la valeur doit prevenir d'une table
	 */
	private String linktable;

	/**
	 * Represente si le l'attribut sert de lien du tableau  la fiche
	 */
	private boolean tabToCard;

	/**
	 * Represente les valeur de cet attribut
	 */
	private Vector values;

	/**
	 * Spcifie si l'attribut est un mail
	 */
	private boolean isMail=false;

	/**
	 * @return si il doit y avoir un lien du tableau  la fiche
	 */
	public boolean getTabToCard() {
		return tabToCard;
	}

	/**
	 * @param value
	 */
	public void setTabToCard(boolean value) {
		tabToCard = value;
	}

	/**
	 *
	 * @return le label  afficher
	 */
	public String getLabel() {
		return label;
	} // end getLabel

	/**
	 *
	 * @param value
	 */
	public void setLabel(String value) {
		label = value;
	} // end setLabel

	/**
	 * @return l'attribut ldap correspondant  l'objet
	 */
	public String getAttribute() {
		return attribute;
	} // end getAttribute

	/**
	 * @param string
	 */
	public void setAttribute(String string) {
		attribute = string;
	} // end setAttribute

	/**
	 * Retourne le type de donne  afficher (rsultat d'une liste, champ direct, ...)
	 *
	 * @return le type
	 */
	public String getType() {
		return type;
	} // end getType

	/**
	 * Dfinit le type de donne  afficher (rsultat d'une liste, champ direct, ...)
	 *
	 * @param le type
	 */
	public void setType(String value) {
		type = value;
	} // end setType

	/**
	 * Dfinit si l'attribut est visible dans la liste rsultat sous forme de tableau
	 *
	 * @return true / false
	 */
	public boolean getList() {
		return list;
	} // end getList

	/**
	 *Dfinit la liste de valeurs pour cette ligne
	 *
	 * @param value
	 */
	public void setList(boolean value) {
		list = value;
	} // end setList

	/**
	 * Retourne le nom de la table lie	 *
	 *
	 *
	 * @return le nom de la table 
	 */
	public String getLinktable() {
		return linktable;
	} // end getLinktable

	/**
	 * Dfinit le nom de la table lie	 *
	 *
	 * @param le nom de la table
	 */
	public void setLinktable(String __linktable) {

		linktable = __linktable;
	} // end setLinktable

	/** 
	 * @return toutes les valeurs de cet attribut
	 */
	public Vector getValues() {
		return values;
	}

	/**
	 * @param value
	 */
	public void setValues(NamingEnumeration value) {
		if (value != null) {
			if (values == null)
				values = new Vector();
			while (value.hasMoreElements()) {
				values.add(value.nextElement());
			}
		}
	}

	/**
	 *Dfinit le champs contient un mail
	 *
	 * @param value
	 */
	public void setIsMail(String value) {
		isMail = value.equals("true");
	} 
	public void setIsMail(boolean value) {
		isMail = value;
	} 
	
	/** 
	 * @return si le champs contient un mail
	 */
	public boolean isMail() {
		return isMail;
	}


} // end Line
