/*

ESUP-portail is a french academic project developed under the GPL (General Public License)
augmented according to the following :

A binary or source file developped by ESUP-portail can be used or compiled with products under Apache license.

The official english text of the GPL can be found here : http://www.gnu.org/licenses/gpl.html .

A non official french translation can be found here : http://www.linux-France.org/article/these/gpl.html .

The different kinds of licenses governing the products developed by the Apache
foundation can be found here : http://www.apache.org/licenses .

It follows that you can as well as use download contents as well modify and redistribute
them provided you respect the GPL terms.

Downloading and using such contents do not provide any guaranty.

Be sure that you have well understood the terms of the license before using the contents it covers.

The ESUP-portail distribution includes the following distributions :

* UPortal :
software developed by JA-SIG (Java Architecture - Special Interest Group)
You can find the license page here : http://mis105.udel.edu/ja-sig/uportal/license.html

* CAS :
SSO solution developed by Yale University
You can find the project page here : http://www.yale.edu/tp/auth

* Cocoon :
XML framework distributed by the Apache foundation under Apache license;
Please find the full text here : http://cocoon.apache.org/2.1/license.html

* Mod_dav:
A DAV module for Apache web server
You can find the project page here : http://www.webdav.org/mod_dav

* IMP :
webmail from Horde application framework
You can find the project page here : http://www.horde.org
*/
package org.esupportail.portal.channels.CAnnuaire;

import java.util.*;

public class Personne {

	/**
	 * Represente les attributs LDAP d'une personne
	 */
	private Hashtable attributes = new Hashtable();
	
	/**
	 * Represente la valeur de l'attributs LDAP servant de tri
	 */
	private String attTri;
	
	/**
	 * Represente la valeur de l'attributs LDAP servant d'identifant
	 */
	private String identifiant;
	
	/**
	 * lien vers une application d'annuaire en ligne (%uid est l'endroit o sera mis l'identifiant de la personne)
	 */
	private String link;

	/**
	 * Routrne les attributs d'une personne rsultat
	 * 
	 * @return tous les attributs indxs sur le nom LDAP
	 */
	public Hashtable getAttributes() {
		return attributes;
	}


	/**
	 * Routrne la/les valeurs de l'attribut dont le code est pass en paramtre
	 * 
	 * @return la valeur de l'attribut
	 */
	public Vector getAttribute(String idLdap) {
		if (attributes.get(idLdap) != null)
			return ((Line) attributes.get(idLdap)).getValues();
		else
			return null;
	}

	/**
	 * Ajoute un attribut  la personne 
	 * 
	 * @param un attribut
	 */
	public void addAttributes(Line attr) {
		if ((attr != null) && (attr.getLabel() != ""))
			attributes.put(attr.getAttribute(), attr);
	}


	/**
	 * Ajoute la valeur de tri de la personne
	 * 
	 * @param la valeur de tri
	 */
	public void addTri(String value) {
		attTri = value;
	}


	/**
	 * Retourne une chaine xml pour prsenter tous les attributs d'une personne
	 * L'ordre de ces attributs est le Vecter pass en paramtre
	 * 
	 * @param ordre des attributs
	 * @return chaine XML
	 */
	public String toXml(Vector ordre) {
		StringBuffer xml = new StringBuffer();
		if (attributes != null) {
			xml.append("<resultat>\n");
			xml.append("<attributTri  value=\"" + attTri + "\" />\n");
			if ( (link!=null) && (!link.equals("")) ){
				xml.append("<attributLink  value=\"" + link.replaceAll("%uid",identifiant) + "\" />\n");
			}
			xml.append("<attributId value=\"" + identifiant + "\" />\n");
			Iterator i = ordre.iterator();
			while (i.hasNext()) { 
				String attrCle = (String) i.next();
				Line attr = (Line) attributes.get(attrCle);
				xml.append("<attributRes ");
				xml.append("display=\"" + attr.getLabel() + "\" ");
				if (attr.isMail()){
					xml.append("isMail=\"" + attrCle + "\" ");
				}
				if (attr.getList())
					xml.append("list=\"1\" ");
				else
					xml.append("list=\"0\" ");
				if (attr.getTabToCard())
					xml.append("linkToCard=\"1\" ");
				else
					xml.append("linkToCard=\"0\" ");
				xml.append(" >\n");

				if (attr.getValues() != null) {
					Enumeration val = attr.getValues().elements();
					if (val != null) {
						while (val.hasMoreElements()) {
							String v = (String) val.nextElement();
							if (v.indexOf('$')>=0){
								/*
									Si la chaine contient des $, cela simule un attribut multivalu
									ce qui permet d'avoir un retour  la ligne
								*/
								xml.append("<valeur>");
								StringBuffer result = new StringBuffer();  
							     char [] c = v.toCharArray();  
							  
							     for(int caract=0;caract<c.length;caract++) {  
							          char tmp = c[caract];  
							          switch(tmp) {  
							               case '$':xml.append("</valeur>\n<valeur>");break;  
							               default:xml.append(tmp); 
							          }  
							     } 

							     xml.append("</valeur>\n");
							}
							else{
							xml.append("<valeur>"
								+ userInterface.valueToXml(v)
								+ "</valeur>\n");
							}
						}
					}
				}

				xml.append("</attributRes>\n");
			}
			xml.append("</resultat>\n");
		}

		return xml.toString();
	}

	/**
	 * Retourne la valeur de l'identifiant de cette personne
	 * 
	 * @return la valeur de l'identifiant
	 */
	public String getIdentifiant() {
		return identifiant;
	}

	/**
	 * Dfinit la valeur de l'identifiant de cette personne
	 * 
	 * @param la valeur de l'identifiant
	 */
	public void setIdentifiant(String string) {
		identifiant = string;
	}
	
	/**
	 * Dfinit la valeur du lien vers une application extrieure
	 * (%uid pour l'emplacement de l'identifiant de la personne)
	 * @param le lien
	 */
	public void setLink(String string) {
		link = string;
	}	
	
}
