/*

ESUP-portail is a french academic project developed under the GPL (General Public License)
augmented according to the following :

A binary or source file developped by ESUP-portail can be used or compiled with products under Apache license.

The official english text of the GPL can be found here : http://www.gnu.org/licenses/gpl.html .

A non official french translation can be found here : http://www.linux-France.org/article/these/gpl.html .

The different kinds of licenses governing the products developed by the Apache
foundation can be found here : http://www.apache.org/licenses .

It follows that you can as well as use download contents as well modify and redistribute
them provided you respect the GPL terms.

Downloading and using such contents do not provide any guaranty.

Be sure that you have well understood the terms of the license before using the contents it covers.

The ESUP-portail distribution includes the following distributions :

* UPortal :
software developed by JA-SIG (Java Architecture - Special Interest Group)
You can find the license page here : http://mis105.udel.edu/ja-sig/uportal/license.html

* CAS :
SSO solution developed by Yale University
You can find the project page here : http://www.yale.edu/tp/auth

* Cocoon :
XML framework distributed by the Apache foundation under Apache license;
Please find the full text here : http://cocoon.apache.org/2.1/license.html

* Mod_dav:
A DAV module for Apache web server
You can find the project page here : http://www.webdav.org/mod_dav

* IMP :
webmail from Horde application framework
You can find the project page here : http://www.horde.org
*/
package org.esupportail.portal.channels.CAnnuaire;


import java.io.IOException;
import java.net.URL;
import java.util.Hashtable;
import java.util.Vector;

import org.apache.commons.digester.Digester;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;


public class config {

    private static final Log log = LogFactory.getLog(CAnnuaire.class);
	/*tableau des serveurs LDAP trouvs en config*/
	private Hashtable tabServer;
	private Vector ordreServer;
	private Hashtable tabTable;

	private static config singleton = null;

	/**
	 * @param ConfigFileName
	 */
	private config(String ConfigFileName) {
		tabServer = new Hashtable();
		tabTable = new Hashtable();
		ordreServer = new Vector();

		Digester digester = new Digester();
		digester.setValidating(true);
		digester.push(this);

		/*MONTAGE DES TABLES*/
		digester.addObjectCreate("directories/tables/table", Table.class);
		digester.addSetProperties("directories/tables/table");
		digester.addCallMethod("directories/tables/table/item", "addItem", 3);
		digester.addCallParam("directories/tables/table/item", 0, "code");
		digester.addCallParam("directories/tables/table/item", 1, "value");
		digester.addCallParam("directories/tables/table/item", 2, "fieldOrder");
		digester.addSetNext("directories/tables/table", "addTable");

		/*MONTAGE DES SERVEUR*/
		// pour chaque directories/directory on cree un objet directory sur lequel on va travailler tant que
		// la mthode addSetNext n'est pas appelle sur directories/directory
		digester.addObjectCreate("directories/directory", Server.class);
		//ajout des proprits du directory
		digester.addSetProperties("directories/directory");
		digester.addSetProperties("directories/directory/server");

		// pour chaque directories/directory/request on cree un objet Query
		digester.addObjectCreate("directories/directory/request", Query.class);
		//ajout des proprits du request
		digester.addSetProperties("directories/directory/request");
		digester.addCallMethod("directories/directory/request", "setScope", 1);
		digester.addCallParam("directories/directory/request", 0, "scope");

		// pour chaque directories/directory/request/elemOfRequest on cree un objet ElmOfQuery
		digester.addObjectCreate(
			"directories/directory/request/elemOfRequest",
			ElmOfQuery.class);
		//ajout des proprits de l'elmofquery
		digester.addSetProperties(
			"directories/directory/request/elemOfRequest");

		// une fois l'objet request cree on appel Query.addElement qui ajoute un lement de requete
		digester.addSetNext(
			"directories/directory/request/elemOfRequest",
			"addElement");

		// une fois l'objet request cree on appel Server.setQuery qui met  jour son objet Query
		digester.addSetNext("directories/directory/request", "setQuery");

		// pour chaque directories/directory/card on cree un objet Display
		digester.addObjectCreate("directories/directory/card", Display.class);
		//ajout des proprits du display
		digester.addSetProperties("directories/directory/card");

		// pour chaque directories/directory/request on cree un objet Line
		digester.addObjectCreate("directories/directory/card/line", Line.class);
		//ajout des proprits de la line
		digester.addSetProperties("directories/directory/card/line");

		digester.addCallMethod(
			"directories/directory/card/line",
			"setLinktable",
			1);
		digester.addCallParam("directories/directory/card/line", 0, "table");

		// une fois l'objet request cree on appel Display.addLine qui ajoute une ligne d'afcichage au display
		digester.addSetNext("directories/directory/card/line", "addLine");

		// une fois l'objet request cree on appel Server.setDisplay qui met  jour objet Display
		digester.addSetNext("directories/directory/card", "setDisplay");

		// une fois l'objet directory cree on appel this.addDirectory qui stocke l'annuaire dans un tableau
		digester.addSetNext("directories/directory", "addServer");
		URL url = config.class.getResource(ConfigFileName);

		if (url != null) {

			InputSource inSource = new InputSource(url.toExternalForm());

			try {
				//parcours du fichier de config
				digester.parse(inSource);
			} catch (IOException e) {
			    log.error("CAnnuaireConfig::config() : ERREUR : Impossible d'ouvrir le fichier de config :"
						+ ConfigFileName
						+ "\n"
						+ e.toString());
			} catch (SAXException e) {
			    log.error("CAnnuaireConfig::config() : ERREUR : SAXException :\n"
						+ e.toString());
			} catch (Exception e) {
			    log.error("CAnnuaireConfig::config() : ERREUR : de lecture du fichier de config\n"
						+ e.toString());
			}
		} else { 
		    log.error("CAnnuaireConfig::config() : ERREUR : "
					+ ConfigFileName
					+ " n'existe pas.\n");
		}

	}

	public void addServer(Server s) {
		tabServer.put(s.getName(), s);
		ordreServer.add(s.getName()); 
	}

	public void addTable(Table t) {
		t.loadItems();
		tabTable.put(t.getName(), t);
	}

	public String getDefaultServeurKey() {
		return (String)ordreServer.get(0);
	}

	public Vector getAllServers() {
		return (ordreServer);
	}

	public Server getServer(String key) {
		if (key != null)
			return ((Server) tabServer.get(key));
		else
			return (null);
	}

	public Hashtable getAllTables() {
		return (tabTable);
	}

	public Table getTable(String key) {
		if (key==null)return null;
		else return ((Table) tabTable.get(key));
	}

	public static config getInstance(String configFilePath) {
		if (singleton == null) {

			singleton = new config(configFilePath);

		}
		return singleton;

	}
}
