/*

ESUP-portail is a french academic project developed under the GPL (General Public License)
augmented according to the following :

A binary or source file developped by ESUP-portail can be used or compiled with products under Apache license.

The official english text of the GPL can be found here : http://www.gnu.org/licenses/gpl.html .

A non official french translation can be found here : http://www.linux-France.org/article/these/gpl.html .

The different kinds of licenses governing the products developed by the Apache
foundation can be found here : http://www.apache.org/licenses .

It follows that you can as well as use download contents as well modify and redistribute
them provided you respect the GPL terms.

Downloading and using such contents do not provide any guaranty.

Be sure that you have well understood the terms of the license before using the contents it covers.

The ESUP-portail distribution includes the following distributions :

* UPortal :
software developed by JA-SIG (Java Architecture - Special Interest Group)
You can find the license page here : http://mis105.udel.edu/ja-sig/uportal/license.html

* CAS :
SSO solution developed by Yale University
You can find the project page here : http://www.yale.edu/tp/auth

* Cocoon :
XML framework distributed by the Apache foundation under Apache license;
Please find the full text here : http://cocoon.apache.org/2.1/license.html

* Mod_dav:
A DAV module for Apache web server
You can find the project page here : http://www.webdav.org/mod_dav

* IMP :
webmail from Horde application framework
You can find the project page here : http://www.horde.org
*/
package org.esupportail.portal.channels.CAnnuaire;
import java.util.*;
import javax.naming.*;
import javax.naming.directory.*;
import javax.naming.NamingEnumeration;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.esupportail.portal.channels.CAnnuaire.LDAP.*;
import org.esupportail.portal.channels.CAnnuaire.LDAP.Exceptions.*;


public class userInterface {

    private static final Log log = LogFactory.getLog(CAnnuaire.class);

	/**
	 * Represente l'objet de config (singleton)
	 */
	private config myConfig;
	
	/**
	 * Represente le serveur visible (si plusieurs, spars par une virgule)
	 */
	private String serverView;
	
	/**
	 * Represente le serveur actif
	 */
	private String serverWork;
	
	/**
	 * Represente la liste des rsultats
	 */
	private Hashtable result;
	
	/**
	 * Represente la liste des rsultats
	 */
	private Vector eltDeFiltre = new Vector();
	
	private Hashtable criteres = new Hashtable();
	
	/**
	 * Represente le filtre de la requete
	 */
	//private String filtre;

	//
	public userInterface() {
	}

	//
	public userInterface(config C) {
		this.setConfig(C);
	}

	public void setConfig(config C) {
		myConfig = C;
	}

	/*******************************************************************************************/
	/****FORMULAIRE****/
	/*******************************************************************************************/

	/**
	 * 
	 * Transforme les caractres non affichable dans un fichier XML
	 * 
	 * @param entree : texte  formater en XML correcte
	 * @return une chaine xml formate
	 */
	static String valueToXml(String entree) {
		String sortie = "";

		if (entree != null) {
			sortie = entree.replaceAll("&", "&amp;");
			sortie = sortie.replaceAll("\"", "'");
			sortie = sortie.replaceAll(">", "&gt;");
			sortie = sortie.replaceAll("<", "&lt;");
		}

		return sortie;
	}
	boolean mailToAllowed = false;
	public void setMailToAllowed(boolean value){
		mailToAllowed = value;
	}
	/**
	 * 
	 * Permet de crer le formulaire de recherche en se basant sur un annuaire
	 * 
	 * @param serveurKey : serveur sur lequel se basera la requete
	 * @return la chaine XML formant le formulaire
	 */
	public String getForm(boolean critRAZ) {
			
		/*INITIALISATION DES VALEURS*/
		String formXml = "";
		eltDeFiltre.clear();
		
		if ( critRAZ )criteres.clear();
		
		formXml = "<FORM>\n";
		if (serverWork == null)
			return (formXml + "</FORM>");

		Server monServeur = myConfig.getServer(serverWork);

		formXml += "<INTRO>" + monServeur.getIntro() + "</INTRO>";

		/*ECRITURE DU/DES SERVEUR(S) POTENTIEL(S)*/
		if ((serverView.equals("*")) || (serverView.equals(""))) {
			//rcupration des serveurs lus en config
			Vector listeServer = myConfig.getAllServers();
			Iterator i = listeServer.iterator();
			while (i.hasNext()) {
				Server s = myConfig.getServer((String) i.next());
				formXml += addServerToForm(s);
			}
		} else {
				
			if (serverView.indexOf(",") == -1) {
				//s'il n'y a qu'un serveur
				//_serverView.matches(","); ne fonctionne pas	
				formXml += addServerToForm(myConfig.getServer(serverView));
			} else {
				//s'il y a plusieurs serveurs
				try {
					String[] tabView = serverView.split(",");
					for (int i = 0; i < tabView.length; i++) {
						formXml+= addServerToForm(myConfig.getServer(tabView[i]));
					}
				} catch (NullPointerException e) {
						log.error(
						"userInterface::getForm():erreur dans la recherche des annuaires");
				}

			}
		}

		/*ECRITURE DES CHAMPS ACCESSIBLES POUR LA REQUETE*/
		if (monServeur != null) {
			Vector listeElt = monServeur.getQuery().getElements();
			if (listeElt != null) {
				Iterator j = listeElt.iterator();
				while (j.hasNext()) {
					String key = (String) j.next();
					ElmOfQuery e = monServeur.getQuery().getElement(key);
					formXml += addFieldToForm(e);
				}
			}
		} else {
				log.error(
				"userInterface::getForm():" + serverWork + " non trouve");
			return "<ALERT>WARN_SERVER_NOT_FOUND</ALERT>\n";

		}

		formXml += "</FORM>\n";

		return (formXml);
	}

	/**
	 * @param s : le serveur (Server) que l'on doit ajouter  la liste des serveurs disponibles
	 * @return le code xml pour prendre en compte ce nouveau serveur
	 */
	private String addServerToForm(Server s) {
		String xml = "";
		if (s != null) {
			xml = "<SERVER ";
			xml += "name=\"" + s.getName() + "\" ";
			xml += "label=\"" + userInterface.valueToXml(s.getTitle()) + "\" ";
			xml += "/>\n";
		}
		return (xml);
	}

	/**
	 * @param e : lment (ElmOfQuery) de formulaire  ajouter.
	 * @return le code xml pour ajouter ce nouvel lment au formulaire
	 */
	private String addFieldToForm(ElmOfQuery e) {
		String xml = "";
		String[] critere = (String[])criteres.get(e.getNameHtml());
		String value="";
		if (critere!=null)value=critere[1];		
		if ((e.getType().equals("text"))
			|| (e.getType().equals("textTable"))) {
			xml = "<FIELD name=\"" + e.getNameHtml() + "\" ";
			xml += "label=\"" + userInterface.valueToXml(e.getLabel()) + "\" ";
			xml += "value=\"" + value + "\" ";
			xml += "saisie=\"1\" ";
			xml += "/>\n";
			eltDeFiltre.add(e);
		} else if (e.getType().equals("listTable")) {
			Table table = myConfig.getTable(e.getTable());
			if (table.getItems().size() > 0) {	
				xml = "<FIELD name=\"" + e.getNameHtml() + "\" ";
				xml += "label=\""
					+ userInterface.valueToXml(e.getLabel())
					+ "\" ";
				xml += "value=\"" + value + "\" ";
				xml += "saisie=\"1\" >\n";
				
				Enumeration enum = table.getItems().keys();
				while (enum.hasMoreElements()) {
					itemTable iT =
						(itemTable) table.getItems().get(
							(String) enum.nextElement());
					xml += "<FIELDVALUE code=\"" + iT.getCode() + "\" ";
					xml += "value=\""
						+ userInterface.valueToXml(iT.getValue())
						+ "\" ";
					xml += "order=\""
						+ userInterface.valueToXml(iT.getOrderValue())
						+ "\"";
					xml += "/>\n";
				}
				xml += "</FIELD>\n";

				eltDeFiltre.add(e);
			}
		} else if (e.getType().equals("direct")) {
			xml = "<FIELD name=\"" + e.getNameHtml() + "\" ";
			xml += "label=\"" + userInterface.valueToXml(e.getLabel()) + "\" ";
			xml += "value=\"" + e.getFilter() + "\" ";
			xml += "saisie=\"0\" ";
			xml += "/>\n";
			eltDeFiltre.add(e);
		}
		return (xml);
	}

	/*******************************************************************************************/
	/****EXECUTION REQUETE****/
	/*******************************************************************************************/

	/**
	 * @param value : filtre  costruire 
	 * @return true ou false selon que le filtre est bien mis  jour
	 *
	 */
	public boolean addIdToFilter(String value) {

		if ((value != null) && (value != "")) {
			String id = myConfig.getServer(serverWork).getQuery().getIdentifiant();
			String[] nouvCritere = new String[3];
			nouvCritere[0] = null;//myConfig.getServer(serverWork).getQuery().getIdentifiantLabel();
			nouvCritere[1] = value;
			nouvCritere[2] = value;
			criteres.put("id", nouvCritere);
			return true;
		} else {
			criteres.remove("id");
			return false;
		}
	}

	/**
	 * 
	 * Met les paramtres reus comme critre de recherche
	 * 
	 * @param listeParametres : parametres recus du formulaire
	 */

	public boolean updateFilter(Map listeParametres) {
		criteres.remove("id");
		boolean champTextMisAJour = false;	
		for (java.util.Iterator j = eltDeFiltre.iterator(); j.hasNext();) {
			ElmOfQuery e = (ElmOfQuery) j.next();
			String value = (String) listeParametres.get(e.getNameHtml());
				
			if (value.length() < e.getMinChar()) value = "";	
			
			if (e.getDelStarBool()) value = value.replaceAll("\\*", "");
				
			if ( (value!=null) && (!value.equals("")) ) {
				/*Un critre est compos de 3 parties : 
				 * critere[0] : le label  afficher 
				 * critere[1] : la valeur  tester 
				 * critere[2] : la valeur  afficher 
				 * */
				String[] nouvCritere = new String[3];
				nouvCritere[0] = e.getLabel();
				nouvCritere[1] = value;
				if (e.getType().equals("text")) {
					champTextMisAJour = true;
					nouvCritere[2] = "'"+value+"'";
				} else if (e.getType().equals("listTable")) {
					champTextMisAJour = true;
					Table T = myConfig.getTable(e.getTable());
					nouvCritere[2] = ((itemTable)T.getItem(value)).getValue();
					criteres.put(e.getNameHtml(), nouvCritere);
				} else if (e.getType().equals("textTable")) {
					champTextMisAJour = true;
					Table T = myConfig.getTable(e.getTable());

					/*Met les attributs LDAP  rcuprer dans un tableau de chaines*/
					String[] attrIDs = new String[1];
					attrIDs[0] = T.getAttrCode();
					LDAPHandler LDAP = new LDAPHandler();
					LDAP.setUrl(myConfig.getServer(serverWork).getUrl());
					LDAP.setBindDn(myConfig.getServer(serverWork).getBinddn());
					LDAP.setBindPass(myConfig.getServer(serverWork).getBindpass());
					LDAP.setAttributes(attrIDs);
					LDAP.setMaxEntries(e.getMaxEntries());
					LDAP.setBase(T.getBase());
					String filtreTmp =
						"(&"
							+ T.getFilter()
							+ "("
							+ T.getAttrValue()
							+ "="
							+ e.getSearchValue().replaceAll("%s", value)
							+ "))";
					LDAP.setFilter(filtreTmp);

					LDAP.setScope(T.getScopeNum());
					
					NamingEnumeration answer = null;
					try {
					    answer = LDAP.search();
					} catch (LDAPException e1) {
						log.error("userInterface:updateFilter() : LDAPException : "+e1);
						
					}
					if (answer != null) {
						nouvCritere[2] = "'"+value+"'";
						criteres.put(e.getNameHtml(), nouvCritere);
						try {
							while (answer.hasMore()) {

								SearchResult sr;
								try {
									sr = (SearchResult) answer.next();
									
									String[] Critere = new String[3];
									Critere[0] = "";
									Critere[1] = e.getFilter().replaceAll(
									"%c",
									(String) sr.getAttributes().get(attrIDs[0]).get(0));	
									Critere[2] = "'"+Critere[1]+"'";
									criteres.put(e.getNameHtml(), Critere);	

								} catch (NamingException f) {
										log.error(
										"Table::loadItems() : Parcours les rponses NullPointerException : "
											+ e.toString());
									break;
								}
							}
						} catch (NullPointerException f) {
								log.error(
								"Table::loadItems() : aucune rponse : "
									+ e.toString());
						} catch (NamingException f) {
								log.error(
								"Table::loadItems() : search : "
									+ e.toString());
						}
						finally{
							LDAP.close();
						}
					}
				}
				criteres.put(e.getNameHtml(), nouvCritere);
				
			}
			else{
				criteres.remove(e.getNameHtml());
			}
		}	
		
		if ((!champTextMisAJour)) {
			return false;
		} else {
			return true;
		}
	}
	/**
	 * 
	 * Execute la requete
	 * 
	 * @return L'ensemble des personnes rusltat sous forme de Vector
	 */
	public boolean executeQuery() {
		result = new Hashtable();
		if (getFiltreComplet() != "") {
			/*Prpare le tableau des attributs LDAP  rcuperer*/
			String[] attrIDs =new String[myConfig.getServer(serverWork).getDisplay().getLines().size()+ 2];
			attrIDs[0] = myConfig.getServer(serverWork).getDisplay().getTri();
			attrIDs[1] = myConfig.getServer(serverWork).getQuery().getIdentifiant();
			int i = 2;
			for (java.util.Iterator j =myConfig.getServer(serverWork).getDisplay().getOrdre().iterator();j.hasNext();) {
				String nomAttr = (String) j.next();
				attrIDs[i] =((Line) myConfig.getServer(serverWork).getDisplay().getLines().get(nomAttr)).getAttribute();
				i++;
			}
			
			/*Cr et value l'objet LDAP*/
			LDAPHandler LDAP = new LDAPHandler();
			LDAP.setUrl(myConfig.getServer(serverWork).getUrl());
			LDAP.setAttributes(attrIDs);
			LDAP.setMaxEntries(myConfig.getServer(serverWork).getQuery().getMaxEntries());
			LDAP.setBase(myConfig.getServer(serverWork).getQuery().getBase());
			LDAP.setBindDn(myConfig.getServer(serverWork).getBinddn());
			LDAP.setBindPass(myConfig.getServer(serverWork).getBindpass());
			LDAP.setFilter(getFiltreComplet());
			LDAP.setScope(myConfig.getServer(serverWork).getQuery().getScope());
			
			if (log.isDebugEnabled()){
			    log.debug("userInterface::executeQuery() : getFiltreComplet "+getFiltreComplet());
			}
			
			
			/*Lance la recherche*/
			NamingEnumeration answer = null;
			try {
			    answer = LDAP.search();
			} catch (LDAPException e1) {
				log.error("userInterface::executeQuery() : LDAPException : "+e1);
				
			}

			int nbRep = 0;
			if (answer != null) {

				try {
					/*Parcours les rponses*/
					while (answer.hasMore()) {
						Personne p = new Personne();
						p.setLink(myConfig.getServer(serverWork).getDisplay().getLink());
						SearchResult sr;
						try {
							sr = (SearchResult) answer.next();
							nbRep++;
						} catch (NamingException e) {
								log.error(
								"userInterface:executeQuery() : "
									+ e.toString());
							return (false);
						}

						/*Ajoute l'attribut de tri pour la personne*/
						Attribute attrib = sr.getAttributes().get(attrIDs[0]);
						try {
							p.addTri((String) attrib.get());
						} catch (NullPointerException f) {
								log.error(
								"userInterface:executeQuery() : L'attribut de tri est nul");
							return (false);
						} catch (NamingException f) {
								log.error(
								"userInterface:executeQuery() : Impossible d'ajouter l'attribut de tri dans la rponse");
							return (false);
						}

						/*Ajoute l'attribut identifiant pour la personne*/
						attrib = sr.getAttributes().get(attrIDs[1]);
						try {
							p.setIdentifiant((String) attrib.get());
						} catch (NamingException f) {
								log.error(
								"userInterface:executeQuery() : Impossible d'ajouter l'attribut identifiant dans la rponse");
							return (false);
						}

						/*Parcours les autres attributs de la rponse et les ajoute pour la perosnne*/
						for (i = 2; i < attrIDs.length; i++) {
							attrib = sr.getAttributes().get(attrIDs[i]);
							Line e = new Line();

							e.setAttribute(attrIDs[i]);
							e.setLabel(((Line) myConfig.getServer(serverWork).getDisplay().getLines().get(attrIDs[i])).getLabel());
							e.setList(((Line) myConfig.getServer(serverWork).getDisplay().getLines().get(attrIDs[i])).getList());
							e.setTabToCard(((Line) myConfig.getServer(serverWork).getDisplay().getLines().get(attrIDs[i])).getTabToCard());
							boolean mailTmp = ( 
												(mailToAllowed) 
												&& (((Line) myConfig.getServer(serverWork).getDisplay().getLines().get(attrIDs[i])).isMail())
												);
							e.setIsMail(mailTmp);
							String type =((Line) myConfig.getServer(serverWork).getDisplay().getLines().get(attrIDs[i])).getType();

							if (type.equals("direct")) {
								/*Rcupration directe dans LDAP de la (des) valeur(s) de cet attribut*/
								try {
									if (attrib != null) {
										e.setValues(attrib.getAll());
									} else {
										e.setValues(null);
									}
								} catch (NamingException f) {
										log.error(
										"userInterface:executeQuery() : "
											+ f.toString());
									return (false);
								}
							} else if (type.equals("table")) {
								try {
									/*Rcupration dans la table lie de la valeur de cet attribut*/
									if (attrib != null) {
										Line L =(Line) myConfig.getServer(serverWork).getDisplay().getLines().get(attrIDs[i]);
										String nomAttrib = L.getAttribute();
										String nomTable = L.getLinktable();
										Table T = myConfig.getTable(nomTable);
										 
										String value = null;
										itemTable test;
										
										for (int k = 0;
											k < attrib.size();
											k++) {

											test =
												T.getItem(
													attrib.get(k).toString());
													
											if ( (test != null) && (!test.getValue().equals(attrib.get(k).toString())) ){
												value = test.getValue();
												//vrifie si l'lment dans la table existe car lorsqu'il n'existait pas, le chanel faisait un JavaNullException
												if (value != null) {
													attrib.set(k, value);
												}
											} 
										}
										e.setValues(attrib.getAll());
										
									} else {
										e.setValues(null);
									}
								} catch (NamingException f) {
										log.error(
										"userInterface:executeQuery() : "
											+ f.toString());
									return (false);
								}
							}
							p.addAttributes(e);
						}
						result.put(p.getIdentifiant(),p);
					}
				} catch (javax.naming.SizeLimitExceededException h) {
					log.warn("userInterface:executeQuery() : Nombre maximum de rponses atteind");
					//Il ne faut pas de return car une fois cette exception dclenche,
					//c'est que le nombre maximum de rponses a t atteind
				} catch (NamingException e) {
						log.error(
						"userInterface:executeQuery() : " + e.toString());
						result = null;
						nbRep = 0;
					return (false);
				}catch (Exception e) {
					log.error(
							"userInterface:executeQuery() : " + e.toString());
					result = null;
					nbRep = 0;
						return (false);
					} finally {
					LDAP.close();
				}
			}

			if (log.isDebugEnabled()){
			    log.debug("userInterface::executeQuery() : nb de rponses trouve : "
						+ nbRep);
			}

			return (true);
		} else {

			if (log.isDebugEnabled()){
			    log.debug("userInterface:executeQuery() : Filtre vide");
			}
			return (false);
		}
	}

	/*******************************************************************************************/
	/****AFFICHAGE RESULTAT****/
	/*******************************************************************************************/

	/**
	 * @return le code xml complet pour afficher le rsultat
	 */
	public String getResultXml() {
		String xml = "<tagEnglobant >\n";

		xml += this.getCriteresXml();

		xml += this.getEnteteXml();

		xml += this.getReponseXml();

		xml += "</tagEnglobant>\n";

		if (this.getNbReponse()
			== myConfig.getServer(serverWork).getQuery().getMaxEntries()) {
			xml += "<ALERT>WARN_MAX_ENTRIES</ALERT>\n";
		}

		return xml;
	}

	/**
	 * @return le code xml des critres slectionns
	 */
	public String getCriteresXml() {
		String xml = "";
		for (java.util.Iterator j = criteres.keySet().iterator();
			j.hasNext();
			) {
			String cle = (String) j.next();
			if (cle.equals("id")){
				xml += "<critere ";
				xml += "label=\"Fiche dtaille\" value=\"\" ";
				xml += "/>\n";
			}
			else{
				String[] s = (String[]) criteres.get(cle);
				if (s[0]!=null){
					xml += "<critere ";
					xml += "label=\"" + s[0] + "\" value=\"" + s[2] + "\" ";
					xml += "/>\n";
				}
			}
		}
		return xml;
	}

	/**
	 * @return le code xml des entetes de colonnes
	 */
	public String getEnteteXml() {
		StringBuffer xml = new StringBuffer();
		/*Rpertorie les attributs*/

		if ( (myConfig.getServer(serverWork).getDisplay().getLink()!=null)
			&& (!myConfig.getServer(serverWork).getDisplay().getLink().equals("")) 
			){
			xml.append("<attributEntete ");
			xml.append("display=\"&#160;\" ");
			xml.append("list=\"1\" ");
			xml.append("/>\n");
		}
		
		for (java.util.Iterator j =
			myConfig.getServer(serverWork).getDisplay().getOrdre().iterator();
			j.hasNext();
			) {
			String nomAttr = (String) j.next();
			Line e =
				(Line) myConfig
					.getServer(serverWork)
					.getDisplay()
					.getLines()
					.get(
					nomAttr);
			xml.append("<attributEntete ");
			xml.append("display=\""
				+ userInterface.valueToXml(e.getLabel())
				+ "\" ");
			if (e.getList())
				xml.append("list=\"1\" ");
			else
				xml.append("list=\"0\" ");
			xml.append("/>\n");
		}

		return xml.toString();
	}

	/**
	 * @return le code xml des rponses
	 */
	public String getReponseXml() {

		boolean hasResult = this.executeQuery();

		String xml = "";

		if (hasResult) {
			/*rpertorie les rsultats
			for (java.util.Iterator j = result.iterator(); j.hasNext();) {
				Personne e = (Personne) j.next();
				xml += e.toXml(myConfig.getServer(serverWork).getDisplay().getOrdre());
			}*/
			for (java.util.Iterator j = result.keySet().iterator(); j.hasNext();) {
				String e = (String) j.next();
				Personne p = (Personne) result.get(e);
				xml += p.toXml(myConfig.getServer(serverWork).getDisplay().getOrdre());
			}
		}
		xml += "<NBREPONSES>" + this.getNbReponse() + "</NBREPONSES>\n";

		return xml;
	}
	/**
	 * @return le nombre de rsultat trouvs
	 */
	public int getNbReponse() {
		if (result != null)
			return result.size();
		else
			return (0);
	}

	/*******************************************************************************************/
	/****GETTER ET SETTER****/
	/*******************************************************************************************/

	/**
	 * @return Returns le filtre compltement gnr
	 */
	public String getFiltreComplet() {
	    String filtre = "";
		filtre = "(&";
		
		Iterator i = criteres.keySet().iterator();
		while (i.hasNext()){
			String key = (String)i.next();
			String[] critere = (String[])criteres.get(key);
			String value = critere[1];
		
			if (key.equals("id")){
				filtre +="("+myConfig.getServer(serverWork).getQuery().getIdentifiant()+"="+value+")";
			}
			else{			
				ElmOfQuery e = (ElmOfQuery)myConfig.getServer(serverWork).getQuery().getElement(key); 	
				filtre += e.updateFilter(value,myConfig.getTable(e.getTable()),myConfig.getServer(serverWork).getUrl());				
			} 
		}
	
		filtre += ")";		
	
		return filtre;
	}

	/**
	 * @return Returns the _serverView.
	 */
	public Vector getEltDeFiltre() {
		return eltDeFiltre;
	}

	/**
	 * @return Returns the _serverView.
	 */
	public String getServerView() {
		return serverView;
	}

	/**
	 * @param view The _serverView to set.
	 */
	public void setServerView(String view) {
		serverView = view;

		boolean setOk = false;
		String work = "";

		/*ECRITURE DU/DES SERVEUR(S) POTENTIEL(S)*/
		if ((serverView.equals("*")) || (serverView.equals(""))) {
			//rcupration des serveurs lus en config
			setOk = this.setServerWork(myConfig.getDefaultServeurKey());
			work = myConfig.getDefaultServeurKey();

		} else {
			//_serverView.matches(","); ne fonctionne pas
			if (serverView.indexOf(',') == -1) {
				setOk = this.setServerWork(serverView);
				work = serverView;
			} else {
				String[] tabView = serverView.split(",");
				setOk = this.setServerWork(tabView[0]);
				work = tabView[0];
			}
		}

		if (!setOk)
				log.error(
				"userInterface::setServerView():Un serveur pass en paramtre d'instanciation n'est pas correct : "
					+ work);

	}

	/**
	 * @return Returns the _serverWork.
	 */
	public String getServerWork() {
		return serverWork;
	}

	/**
	 * Dfinit le "serveur de travail" c'est--dire le serveur actif 
	 * 
	 * @param le nom d'un serveur (prsent en config)
	 * @return true si le serveur a t trouv, false sinon
	 */
	public boolean setServerWork(String value) {

		if (myConfig.getServer(value) != null) {
			serverWork = value;
			return true;
		} else {
			serverWork = null;		
				log.error(
				"userInterface::setServerWork():serveur "
					+ value
					+ " introuvable en config.");
			return false;
		}
	}

	/**
	 * Retourne la liste des rsultats
	 * 
	 * @return la liste des rsultats
	 */
	public Hashtable getResults() {
		return result;
	}
	
	public Personne getResult(String key) {
		Object res = result.get(key);
		if (res!=null){
			return (Personne) res;
		}
		return null;
	}

}
