<?xml version="1.0" encoding="ISO-8859-1" ?>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">
   
	<xsl:import href = "./CAnnuaireEntete.xsl" />

	<xsl:import href = "./CAnnuaireCritere.xsl" />
	
	<xsl:param name="modeServant">none</xsl:param>

   <xsl:param name="mediaPath">media/org/esupportail/portal/channels/CAnnuaire</xsl:param>
	
   <xsl:template match="tagEnglobant">
	<form action="{$baseActionURL}" method="post">
	   <table align="center">  	
			
		<tr><td>
		<xsl:call-template name = "entete" />
		</td></tr>
		
		
		<tr><td>
		<xsl:call-template name = "critere" />
		</td></tr>
		
		<tr>
		<td>   	  	
		
		<xsl:apply-templates select = "resultat" >   	
		<xsl:sort select="attributTri/@value"/>
		</xsl:apply-templates>
		</td>
		</tr>
		
	   </table>
	   
	   <xsl:if test="$modeServant!='none'">
	   <center>
	   <br/>
	   <xsl:choose>
	   <xsl:when test="/RACINE/tagEnglobant/NBREPONSES > 1"> 
		  <input type="hidden" value="root" name="uP_root" />
		  <input type="submit" name="CAnnuaireServantFinished" value="Valider" class="uportal-button" /> 
	   </xsl:when>
	   <xsl:otherwise>
			<input type="hidden" value="root" name="uP_root" />
		   <input type="submit" name="CAnnuaireServantFinished" value="Slectionner" class="uportal-button" /> 
	   </xsl:otherwise>    
	   </xsl:choose>
	   </center>	
	   </xsl:if>
	</form>
   </xsl:template>
   
   

   
<!--AFFICHAGE DES LIGNES RESULTAT-->
   <xsl:template match="resultat">   	
   	<hr />
   	<xsl:if test="/RACINE/tagEnglobant/NBREPONSES > 1"> 
   	<xsl:choose>
		<xsl:when test="$modeServant='multiple'">
			<input type="checkbox" name="pers_id[]" value="{attributId/@value}" />
   			<font class="uportal-channel-text">Slectionner la fiche</font>
		</xsl:when>
		<xsl:when test="$modeServant='single'">
			<input type="radio" name="pers_id" value="{attributId/@value}" />
   			<font class="uportal-channel-text">Slectionner la fiche</font>
		</xsl:when>
	</xsl:choose>    
   	</xsl:if>
   	<table border="0" cellpadding="2" cellspacing="2" align="center">
   	
   	<xsl:apply-templates select = "attributRes" />
	         
	 <xsl:if test="attributLink/@value!=''">
		<tr valign="top">
			<th class="uportal-channel-subtitle" align="right">
				<a href="{attributLink/@value}" target="_blank" >
					<img src="{$mediaPath}/info.gif" title="Coller" border="0"/> 
				</a>
			</th>
			<td class="uportal-channel-text" align="left">
				<a href="{attributLink/@value}" target="_blank" >
					Accs  l'annuaire en ligne
				</a>
			</td>
		</tr>
	 </xsl:if>
   	
   	</table>
   </xsl:template>
   
   
<!--AFFICHAGE DES LIGNES RESULTAT-->
   <xsl:template match="attributRes">
   <xsl:if test="count(valeur)>0">
	   <tr valign="top">
	   <th class="uportal-channel-subtitle" align="left">
	      <xsl:value-of select="@display" /> : 
	   </th>
	   <td class="uportal-channel-text">
		<xsl:choose>
			<xsl:when test = "@isMail!=''">
				<xsl:for-each select = "valeur">
					<a href="{$baseActionURL}?etat=sendMail&amp;attrib={../@isMail}&amp;id={../../attributId/@value}"><xsl:value-of select="current()" /></a><br />
				</xsl:for-each>
			</xsl:when>
			<xsl:otherwise>
				<xsl:for-each select = "valeur">
					<xsl:value-of select="current()" /><br />
				</xsl:for-each>
			</xsl:otherwise>
		</xsl:choose>
	   </td>
	   </tr>
   </xsl:if>
   </xsl:template>
   
   
</xsl:stylesheet>
