/*

ESUP-portail is a french academic project developed under the GPL (General Public License)
augmented according to the following :

A binary or source file developped by ESUP-portail can be used or compiled with products under Apache license.

The official english text of the GPL can be found here : http://www.gnu.org/licenses/gpl.html .

A non official french translation can be found here : http://www.linux-France.org/article/these/gpl.html .

The different kinds of licenses governing the products developed by the Apache
foundation can be found here : http://www.apache.org/licenses .

It follows that you can as well as use download contents as well modify and redistribute
them provided you respect the GPL terms.

Downloading and using such contents do not provide any guaranty.

Be sure that you have well understood the terms of the license before using the contents it covers.

The ESUP-portail distribution includes the following distributions :

* UPortal :
software developed by JA-SIG (Java Architecture - Special Interest Group)
You can find the license page here : http://mis105.udel.edu/ja-sig/uportal/license.html

* CAS :
SSO solution developed by Yale University
You can find the project page here : http://www.yale.edu/tp/auth

* Cocoon :
XML framework distributed by the Apache foundation under Apache license;
Please find the full text here : http://cocoon.apache.org/2.1/license.html

* Mod_dav:
A DAV module for Apache web server
You can find the project page here : http://www.webdav.org/mod_dav

* IMP :
webmail from Horde application framework
You can find the project page here : http://www.horde.org
*/
package org.esupportail.portal.channels.CAnnuaire;
import java.util.*;
import javax.naming.*;
import javax.naming.directory.*;
import javax.naming.NamingEnumeration;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.esupportail.portal.channels.CAnnuaire.LDAP.*;
import org.esupportail.portal.channels.CAnnuaire.LDAP.Exceptions.*;


public class userInterface {

    private static final Log log = LogFactory.getLog(CAnnuaire.class);

	/**
	 * Represente l'objet de config (singleton)
	 */
	private config myConfig;
	
	/**
	 * Represente le serveur visible (si plusieurs, spars par une virgule)
	 */
	private String serverView;
	
	/**
	 * Represente le serveur actif
	 */
	private String serverWork;
	
	/**
	 * Represente le serveur actif
	 */
	private Server myServer;
	
	/**
	 * Represente la liste des rsultats
	 */
	private TreeMap orderedResult;
	private Hashtable result;
	
	/**
	 * 
	 */
	private String lang;
	
	
	
	private Hashtable criteres = new Hashtable();
	
	//
	public userInterface() {
	}

	//
	public userInterface(config C) {
		this.setConfig(C);
	}

	public void setConfig(config C) {
		myConfig = C;
	}

	/*******************************************************************************************/
	/****FORMULAIRE****/
	/*******************************************************************************************/

	/**
	 * 
	 * Transforme les caractres non affichable dans un fichier XML
	 * 
	 * @param entree : texte  formater en XML correcte
	 * @return une chaine xml formate
	 */
	static String valueToXml(String entree) {
		String sortie = "";

		if (entree != null) {
			sortie = entree.replaceAll("&", "&amp;");
			sortie = sortie.replaceAll("\"", "'");
			sortie = sortie.replaceAll(">", "&gt;");
			sortie = sortie.replaceAll("<", "&lt;");
		}

		return sortie;
	}
	
	static String valueToAscii(String entree) {
		String sortie = "";

		if (entree != null) {
			sortie = sortie.replaceAll("", "a");
			sortie = sortie.replaceAll("", "a");
			sortie = sortie.replaceAll("", "a");
			sortie = entree.replaceAll("", "e");
			sortie = sortie.replaceAll("", "e");
			sortie = sortie.replaceAll("", "e");
			sortie = sortie.replaceAll("", "e");
			sortie = sortie.replaceAll("", "i");
			sortie = sortie.replaceAll("", "i");
			sortie = sortie.replaceAll("", "o");
			sortie = sortie.replaceAll("", "o");
			sortie = sortie.replaceAll("", "u");
			sortie = sortie.replaceAll("", "u");
			sortie = sortie.replaceAll("", "u");
		}

		return sortie;
		
	}
	
	
	boolean mailToAllowed = false;
	public void setMailToAllowed(boolean value){
		mailToAllowed = value;
	}
	/**
	 * 
	 * Permet de crer le formulaire de recherche en se basant sur un annuaire
	 * 
	 * @param serveurKey : serveur sur lequel se basera la requete
	 * @return la chaine XML formant le formulaire
	 */
	public StringBuffer getForm() {
		cleanResult();
		/*INITIALISATION DES VALEURS*/
		StringBuffer formXml = new StringBuffer();
		
		if (serverWork == null)
			return (formXml.append(""));
		formXml.append("<FORM>\n");
		

		formXml.append("<INTRO>" + myConfig.get18InText(lang,myServer.getIntro()) + "</INTRO>");

		/*ECRITURE DU/DES SERVEUR(S) POTENTIEL(S)*/
		if ((serverView.equals("*")) || (serverView.equals(""))) {
			//rcupration des serveurs lus en config
			Vector listeServer = myConfig.getAllServers();
			Iterator i = listeServer.iterator();
			while (i.hasNext()) {
				Server s = myConfig.getServer((String) i.next());
				formXml.append(addServerToForm(s));
			}
		} else {
				
			if (serverView.indexOf(",") == -1) {
				//s'il n'y a qu'un serveur
				//_serverView.matches(","); ne fonctionne pas	
				formXml.append(addServerToForm(myConfig.getServer(serverView)));
			} else {
				//s'il y a plusieurs serveurs
				try {
					String[] tabView = serverView.split(",");
					for (int i = 0; i < tabView.length; i++) {
						formXml.append(addServerToForm(myConfig.getServer(tabView[i])));
					}
				} catch (NullPointerException e) {
						log.error(
						"userInterface::getForm():erreur dans la recherche des annuaires");
				}

			}
		}

		/*ECRITURE DES CHAMPS ACCESSIBLES POUR LA REQUETE*/
		if (myServer != null) {
			Vector listeElt = myServer.getQuery().getElements();
			if (listeElt != null) {
				Iterator j = listeElt.iterator();
				while (j.hasNext()) {
					String key = (String) j.next();
					ElmOfQuery e = myServer.getQuery().getElement(key);
					formXml.append(addFieldToForm(e));
				}
			}
		} else {
				log.error(
				"userInterface::getForm():" + serverWork + " non trouve");
			return new StringBuffer("<ALERT>WARN_SERVER_NOT_FOUND</ALERT>\n");

		}

		formXml.append("</FORM>\n");

		return (formXml);
	}

	/**
	 * @param s : le serveur (Server) que l'on doit ajouter  la liste des serveurs disponibles
	 * @return le code xml pour prendre en compte ce nouveau serveur
	 */
	private StringBuffer addServerToForm(Server s) {
		StringBuffer xml = new StringBuffer("");
		if (s != null) {
			String label = myConfig.get18InText(lang,s.getTitle());
			xml.append("<SERVER ");
			xml.append("name=\"" + s.getName() + "\" ");
			xml.append("label=\"" + userInterface.valueToXml(label) + "\" ");
			xml.append("/>\n");
		}
		return (xml);
	}

	
	/**
	 * @param e : lment (ElmOfQuery) de formulaire  ajouter.
	 * @return le code xml pour ajouter ce nouvel lment au formulaire
	 */
	private StringBuffer addFieldToForm(ElmOfQuery e) {
		StringBuffer xml = new StringBuffer();
		String[] critere = (String[])criteres.get(e.getNameHtml());
		String value="";
		if (critere!=null)value=critere[1];	

		String label = myConfig.get18InText(lang,e.getVar18In());
		
		if ((e.getType().equals("text"))
			|| (e.getType().equals("textTable"))) {
			xml.append("<FIELD name=\"" + e.getNameHtml() + "\" ");
			xml.append("label=\"" + userInterface.valueToXml(label) + "\" ");
			xml.append("value=\"" + value + "\" ");
			xml.append("saisie=\"1\" ");
			if (e.getMinChar()>1){
				xml.append("minChar=\""+e.getMinChar()+"\" ");
			}
			xml.append("/>\n");
			//eltDeFiltre.add(e);
		} else if (e.getType().equals("listTable")) {
			Table table = myConfig.getTable(e.getTable());
			if (table.getItems().size() > 0) {	
				xml.append("<FIELD name=\"" + e.getNameHtml() + "\" ");
				xml.append("label=\"");
				xml.append(userInterface.valueToXml(label));
				xml.append("\" ");
				xml.append("value=\"" + value + "\" ");
				xml.append("saisie=\"1\" >\n");
				
				Enumeration enum = table.getItems().keys();
				while (enum.hasMoreElements()) {
					itemTable iT =
						(itemTable) table.getItems().get(
							(String) enum.nextElement());
					xml.append("<FIELDVALUE code=\"" + iT.getCode() + "\" ");
					xml.append("value=\"");
					xml.append(userInterface.valueToXml(iT.getValue()));
					xml.append("\" ");
					xml.append("order=\"");
					xml.append(userInterface.valueToXml(iT.getOrderValue()));
					xml.append("\"");
					xml.append("/>\n");
				}
				xml.append("</FIELD>\n");

				//eltDeFiltre.add(e);
			}
		} else if (e.getType().equals("direct")) {
			xml.append("<FIELD name=\"" + e.getNameHtml() + "\" ");
			xml.append("label=\"" + userInterface.valueToXml(label) + "\" ");
			xml.append("value=\"" + e.getFilter() + "\" ");
			xml.append("saisie=\"0\" ");
			xml.append("/>\n");
			//eltDeFiltre.add(e);
		}
		return (xml);
	}

	/*******************************************************************************************/
	/****EXECUTION REQUETE****/
	/*******************************************************************************************/

	/**
	 * @param value : filtre  costruire 
	 * @return true ou false selon que le filtre est bien mis  jour
	 *
	 */
	public boolean addIdToFilter(String value) {

		if ((value != null) && (value != "")) {
			String id = myServer.getQuery().getIdentifiant();
			String[] nouvCritere = new String[3];
			nouvCritere[0] = null;
			nouvCritere[1] = value;
			nouvCritere[2] = value;
			criteres.put("id", nouvCritere);
			return true;
		} else {
			criteres.remove("id");
			return false;
		}
	}

	/**
	 * 
	 * Met les paramtres reus comme critre de recherche
	 * 
	 * @param listeParametres : parametres recus du formulaire
	 */

	public boolean updateFilter(Map listeParametres) {
		criteres.remove("id");
		
		boolean champTextMisAJour = false;	
		boolean erreurDeSaiie = false;	
		
		
		Vector eltDeFiltre = myServer.getQuery().getElements();		
		Iterator j = eltDeFiltre.iterator();
		while (j.hasNext()) {
			String key = (String) j.next();
			ElmOfQuery e = myConfig.getServer(serverWork).getQuery().getElement(key);
			
			String value = (String) listeParametres.get(e.getNameHtml());
			
			if (e.getWrapToAscii()){
				value = userInterface.valueToAscii(value);
			}
			
			
			if (e.getDelStarBool()){
				value = value.replaceAll("\\*", "");
			}
				
			if ( !value.equals("") ){
				/*
				 * Un critre est compos de 3 parties : 
				 * critere[0] : le label  afficher 
				 * critere[1] : la valeur  tester 
				 * critere[2] : la valeur  afficher 
				 * */
				
				if (value.length() < e.getMinChar()){
					erreurDeSaiie = true;
				}
				
				String label = myConfig.get18InText(lang,e.getVar18In());
				
				String[] nouvCritere = new String[3];
				nouvCritere[0] = valueToXml(label);
				nouvCritere[1] = value;
				if (e.getType().equals("text")) {
					champTextMisAJour = true;
					nouvCritere[2] = "'"+value+"'";
				} else if (e.getType().equals("listTable")) {
					champTextMisAJour = true;
					Table T = myConfig.getTable(e.getTable());
					nouvCritere[2] = ((itemTable)T.getItem(value)).getValue();
					criteres.put(e.getNameHtml(), nouvCritere);
				} else if (e.getType().equals("textTable")) {
					champTextMisAJour = true;
					Table T = myConfig.getTable(e.getTable());

					/*Met les attributs LDAP  rcuprer dans un tableau de chaines*/
					String[] attrIDs = new String[1];
					attrIDs[0] = T.getAttrCode();
					LDAPHandler LDAP = new LDAPHandler();
					LDAP.setUrl(myConfig.getServer(serverWork).getUrl());
					LDAP.setBindDn(myConfig.getServer(serverWork).getBinddn());
					LDAP.setBindPass(myConfig.getServer(serverWork).getBindpass());
					LDAP.setAttributes(attrIDs);
					LDAP.setMaxEntries(e.getMaxEntries());
					LDAP.setBase(T.getBase());
					
					StringBuffer filtreTmp = new StringBuffer();
					filtreTmp.append("(&");
					filtreTmp.append(T.getFilter());
					filtreTmp.append("(");
					filtreTmp.append(T.getAttrValue());
					filtreTmp.append("=");
					filtreTmp.append(e.getSearchValue().replaceAll("%s", value));
					filtreTmp.append("))");
					LDAP.setFilter(filtreTmp.toString());

					LDAP.setScope(T.getScopeNum());
					
					NamingEnumeration answer = null;
					try {
					    answer = LDAP.search();
					} catch (LDAPException e1) {
						log.error("userInterface:updateFilter() : LDAPException : "+e1);
						
					}
					if (answer != null) {
						nouvCritere[2] = "'"+value+"'";
						criteres.put(e.getNameHtml(), nouvCritere);
						try {
							while (answer.hasMore()) {

								SearchResult sr;
								try {
									sr = (SearchResult) answer.next();
									
									String[] Critere = new String[3];
									Critere[0] = "";
									Critere[1] = e.getFilter().replaceAll(
									"%c",
									(String) sr.getAttributes().get(attrIDs[0]).get(0));	
									Critere[2] = "'"+Critere[1]+"'";
									criteres.put(e.getNameHtml(), Critere);	

								} catch (NamingException f) {
										log.error(
										"Table::loadItems() : Parcours les rponses NullPointerException : "
											+ e.toString());
									break;
								}
							}
						} catch (NullPointerException f) {
								log.error(
								"Table::loadItems() : aucune rponse : "
									+ e.toString());
						} catch (NamingException f) {
								log.error(
								"Table::loadItems() : search : "
									+ e.toString());
						}
						finally{
							LDAP.close();
						}
					}
				}
				criteres.put(e.getNameHtml(), nouvCritere);
				
			}
			else{
				criteres.remove(e.getNameHtml());
			}
		}	
		
		if ((champTextMisAJour) && (!erreurDeSaiie)) {
			return true;
		} else {
			return false;
		}
	}
	/**
	 * 
	 * Execute la requete
	 * 
	 * @return L'ensemble des personnes rusltat sous forme de Vector
	 */
	public boolean executeQuery() {
		result = new Hashtable();
		orderedResult = new TreeMap(); 
		if (getFiltreComplet() != "") {
			/*Prpare le tableau des attributs LDAP  rcuperer*/
			String[] attrIDs =new String[myConfig.getServer(serverWork).getDisplay().getLines().size()+ 2];
			attrIDs[0] = myConfig.getServer(serverWork).getDisplay().getTri();
			attrIDs[1] = myConfig.getServer(serverWork).getQuery().getIdentifiant();
			int i = 2;
			for (java.util.Iterator j =myConfig.getServer(serverWork).getDisplay().getOrdre().iterator();j.hasNext();) {
				String nomAttr = (String) j.next();
				attrIDs[i] =((Line) myConfig.getServer(serverWork).getDisplay().getLines().get(nomAttr)).getAttribute();
				i++;
			}
			
			/*Cr et value l'objet LDAP*/
			LDAPHandler LDAP = new LDAPHandler();
			LDAP.setUrl(myConfig.getServer(serverWork).getUrl());
			LDAP.setAttributes(attrIDs);
			LDAP.setMaxEntries(myConfig.getServer(serverWork).getQuery().getMaxEntries());
			LDAP.setBase(myConfig.getServer(serverWork).getQuery().getBase());
			LDAP.setBindDn(myConfig.getServer(serverWork).getBinddn());
			LDAP.setBindPass(myConfig.getServer(serverWork).getBindpass());
			LDAP.setFilter(getFiltreComplet());
			LDAP.setScope(myConfig.getServer(serverWork).getQuery().getScope());
			
			if (log.isDebugEnabled()){
			    log.debug("userInterface::executeQuery() : getFiltreComplet "+getFiltreComplet());
			}
			
			
			/*Lance la recherche*/
			NamingEnumeration answer = null;
			try {
			    answer = LDAP.search();
			} catch (LDAPException e1) {
				log.error("userInterface::executeQuery() : LDAPException : "+e1);
				
			}

			int nbRep = 0;
			if (answer != null) {

				try {
					/*Parcours les rponses*/
					while (answer.hasMore()) {
						Personne p = new Personne();
						p.setLink(myConfig.getServer(serverWork).getDisplay().getLink());
						SearchResult sr;
						try {
							sr = (SearchResult) answer.next();
							nbRep++;
						} catch (NamingException e) {
								log.error(
								"userInterface:executeQuery() : "
									+ e.toString());
							return (false);
						}

						/*Ajoute l'attribut de tri pour la personne*/
						Attribute attrib = sr.getAttributes().get(attrIDs[0]);
						try {
							p.addTri((String) attrib.get());
						} catch (NullPointerException f) {
								log.error(
								"userInterface:executeQuery() : L'attribut de tri est nul");
							return (false);
						} catch (NamingException f) {
								log.error(
								"userInterface:executeQuery() : Impossible d'ajouter l'attribut de tri dans la rponse");
							return (false);
						}

						/*Ajoute l'attribut identifiant pour la personne*/
						attrib = sr.getAttributes().get(attrIDs[1]);
						try {
							p.setIdentifiant((String) attrib.get());
						} catch (NamingException f) {
								log.error(
								"userInterface:executeQuery() : Impossible d'ajouter l'attribut identifiant dans la rponse");
							return (false);
						}

						/*Parcours les autres attributs de la rponse et les ajoute pour la perosnne*/
						for (i = 2; i < attrIDs.length; i++) {
							attrib = sr.getAttributes().get(attrIDs[i]);
							Line e = new Line();

							e.setAttribute(attrIDs[i]);
							String tmp = ((Line) myConfig.getServer(serverWork).getDisplay().getLines().get(attrIDs[i])).getVar18In();
							e.setLabel(myConfig.get18InText(lang,tmp));
							e.setList(((Line) myConfig.getServer(serverWork).getDisplay().getLines().get(attrIDs[i])).getList());
							e.setTabToCard(((Line) myConfig.getServer(serverWork).getDisplay().getLines().get(attrIDs[i])).getTabToCard());
							boolean mailTmp = ( 
												(mailToAllowed) 
												&& (((Line) myConfig.getServer(serverWork).getDisplay().getLines().get(attrIDs[i])).isMail())
												);
							e.setIsMail(mailTmp);
							String type =((Line) myConfig.getServer(serverWork).getDisplay().getLines().get(attrIDs[i])).getType();

							if (type.equals("direct")) {
								/*Rcupration directe dans LDAP de la (des) valeur(s) de cet attribut*/
								try {
									if (attrib != null) {
										e.setValues(attrib.getAll());
									} else {
										e.setValues(null);
									}
								} catch (NamingException f) {
										log.error(
										"userInterface:executeQuery() : "
											+ f.toString());
									return (false);
								}
							} else if (type.equals("table")) {
								try {
									/*Rcupration dans la table lie de la valeur de cet attribut*/
									if (attrib != null) {
										Line L =(Line) myConfig.getServer(serverWork).getDisplay().getLines().get(attrIDs[i]);
										String nomAttrib = L.getAttribute();
										String nomTable = L.getLinktable();
										Table T = myConfig.getTable(nomTable);
										 
										String value = null;
										itemTable test;
										
										for (int k = 0;
											k < attrib.size();
											k++) {

											test =
												T.getItem(
													attrib.get(k).toString());
													
											if ( (test != null) && (!test.getValue().equals(attrib.get(k).toString())) ){
												value = test.getValue();
												//vrifie si l'lment dans la table existe car lorsqu'il n'existait pas, le chanel faisait un JavaNullException
												if (value != null) {
													attrib.set(k, value);
												}
											} 
										}
										e.setValues(attrib.getAll());
										
									} else {
										e.setValues(null);
									}
								} catch (NamingException f) {
										log.error(
										"userInterface:executeQuery() : "
											+ f.toString());
									return (false);
								}
							}
							p.addAttributes(e);
						}
						orderedResult.put(p.getTri()+nbRep,p.getIdentifiant());
						result.put(p.getIdentifiant(),p);
					}
				} catch (javax.naming.SizeLimitExceededException h) {
					log.warn("userInterface:executeQuery() : Nombre maximum de rponses atteind");
					//Il ne faut pas de return car une fois cette exception dclenche,
					//c'est que le nombre maximum de rponses a t atteind
				} catch (NamingException e) {
						log.error(
						"userInterface:executeQuery() : " + e.toString());
						result = null;
						nbRep = 0;
					return (false);
				}catch (Exception e) {
					log.error(
							"userInterface:executeQuery() : " + e.toString());
					result = null;
					nbRep = 0;
						return (false);
					} finally {
					LDAP.close();
				}
			}

			if (log.isDebugEnabled()){
			    log.debug("userInterface::executeQuery() : nb de rponses trouve : "
						+ nbRep);
			}

			return (true);
		} else {

			if (log.isDebugEnabled()){
			    log.debug("userInterface:executeQuery() : Filtre vide");
			}
			return (false);
		}
	}

	/*******************************************************************************************/
	/****AFFICHAGE RESULTAT****/
	/*******************************************************************************************/

	/**
	 * @return le code xml complet pour afficher le rsultat
	 */
	public StringBuffer getResultXml() {
		StringBuffer xml = new StringBuffer("<tagEnglobant >\n");

		xml.append(this.getCriteresXml());

		xml.append(this.getEnteteXml());

		xml.append(this.getReponseXml());

		xml.append("</tagEnglobant>\n");

		if (this.getNbReponse()
			== myConfig.getServer(serverWork).getQuery().getMaxEntries()) {
			xml.append("<ALERT>WARN_MAX_ENTRIES</ALERT>\n");
		}

		return xml;
	}

	/**
	 * @return le code xml des critres slectionns
	 */
	private StringBuffer getCriteresXml() {
		StringBuffer xml = new StringBuffer();
		for (java.util.Iterator j = criteres.keySet().iterator();
			j.hasNext();
			) {
			String cle = (String) j.next();
			if (!cle.equals("id")){
				String[] s = (String[]) criteres.get(cle);
				if (s[0]!=null){
					xml.append("<critere ");
					xml.append("label=\"" + userInterface.valueToXml(s[0]) + "\" value=\"" + userInterface.valueToXml(s[2]) + "\" ");
					xml.append("/>\n");
				}
			}
		} 
		return xml;
	}

	/**
	 * @return le code xml des entetes de colonnes
	 */
	private StringBuffer getEnteteXml() {
		StringBuffer xml = new StringBuffer();
		/*Rpertorie les attributs*/

		if ( (myConfig.getServer(serverWork).getDisplay().getLink()!=null)
			&& (!myConfig.getServer(serverWork).getDisplay().getLink().equals("")) 
			){
			xml.append("<attributEntete ");
			xml.append("display=\"&#160;\" ");
			xml.append("list=\"1\" ");
			xml.append("/>\n");
		}
		
		for (java.util.Iterator j =
			myConfig.getServer(serverWork).getDisplay().getOrdre().iterator();
			j.hasNext();
			) {
			String nomAttr = (String) j.next();
			Line e =
				(Line) myConfig
					.getServer(serverWork)
					.getDisplay()
					.getLines()
					.get(
					nomAttr);
			xml.append("<attributEntete ");
			String label = myConfig.get18InText(lang,e.getVar18In());
			xml.append("display=\""
				+ userInterface.valueToXml(label)
				+ "\" ");
			if (e.getList())
				xml.append("list=\"1\" ");
			else
				xml.append("list=\"0\" ");
			xml.append("/>\n");
		}

		return xml;
	}

	/**
	 * @return le code xml des rponses
	 */
	private StringBuffer getReponseXml() {

		boolean hasResult = this.executeQuery();

		StringBuffer xml = new StringBuffer();

		if (hasResult) {
			/*rpertorie les rsultats*/
			for (java.util.Iterator j = orderedResult.keySet().iterator(); j.hasNext();) {
				String triId = (String) j.next();
				String id = (String) orderedResult.get(triId);
				Personne p = (Personne) result.get(id);
				xml.append(p.toXml(myConfig.getServer(serverWork).getDisplay().getOrdre()));
			}
		}
		xml.append("<NBREPONSES>" + this.getNbReponse() + "</NBREPONSES>\n");

		return xml;
	}

	/**
	 * @return le code xml complet pour afficher le rsultat
	 */
	public StringBuffer getResultCsv() {
		StringBuffer csv = new StringBuffer();

		csv.append(this.getEnteteCsv());

		csv.append(this.getReponseCsv());

		return csv;
	}
	/**
	 * @return le code csv des entetes de colonnes
	 */
	private StringBuffer getEnteteCsv() {
		StringBuffer csv = new StringBuffer();
		/*Rpertorie les attributs*/

		for (java.util.Iterator j =
			myConfig.getServer(serverWork).getDisplay().getOrdre().iterator();
			j.hasNext();
			) {
			String nomAttr = (String) j.next();
			Line e =
				(Line) myConfig
					.getServer(serverWork)
					.getDisplay()
					.getLines()
					.get(
					nomAttr);
			String label = myConfig.get18InText(lang,e.getVar18In());
			csv.append(label+";");
		}
		csv.append("\n");
		return csv;
	}
	
	/**
	 * @return le code csv des rponses
	 */
	private StringBuffer getReponseCsv() {

		boolean hasResult = this.executeQuery();

		StringBuffer csv = new StringBuffer();
		if (hasResult) {
			/*rpertorie les rsultats*/
			int i = 0;
			for (java.util.Iterator j = orderedResult.keySet().iterator(); j.hasNext();) {
				String  triId= (String) j.next(); 
				String id = (String) orderedResult.get(triId);
				Personne p = (Personne) result.get(id);
				csv.append(p.toCsv(myConfig.getServer(serverWork).getDisplay().getOrdre()));
			}
		}
		
		csv.append("\n");
		return csv;
	}	
	
	/**
	 * @return le nombre de rsultat trouvs
	 */
	public int getNbReponse() {
		if (result != null)
			return result.size();
		else
			return (0);
	}

	/*******************************************************************************************/
	/****GETTER ET SETTER****/
	/*******************************************************************************************/

	/**
	 * @return Returns le filtre compltement gnr
	 */
	public String getFiltreComplet() {
	    String filtre = "";
		filtre = "(&";
		
		Iterator i = criteres.keySet().iterator();
		while (i.hasNext()){
			String key = (String)i.next();
			String[] critere = (String[])criteres.get(key);
			String value = critere[1];
		
			if (key.equals("id")){
				filtre +="("+myConfig.getServer(serverWork).getQuery().getIdentifiant()+"="+value+")";
			}
			else{			
				ElmOfQuery e = (ElmOfQuery)myConfig.getServer(serverWork).getQuery().getElement(key); 	
				filtre += e.updateFilter(value,myConfig.getTable(e.getTable()),myConfig.getServer(serverWork).getUrl());				
			} 
		}
	
		filtre += ")";		
	
		return filtre;
	}

	/**
	 * @return Returns the _serverView.
	 */
	public Vector getEltDeFiltre() {
		return null;
	}

	/**
	 * @return Returns the _serverView.
	 */
	public String getServerView() {
		return serverView;
	}

	/**
	 * @param view The _serverView to set.
	 */
	public void setServerView(String view) {
		serverView = view;

		boolean setOk = false;
		String work = "";

		/*ECRITURE DU/DES SERVEUR(S) POTENTIEL(S)*/
		if ((serverView.equals("*")) || (serverView.equals(""))) {
			//rcupration des serveurs lus en config
			setOk = this.setServerWork(myConfig.getDefaultServeurKey());
			work = myConfig.getDefaultServeurKey();

		} else {
			//_serverView.matches(","); ne fonctionne pas
			if (serverView.indexOf(',') == -1) {
				setOk = this.setServerWork(serverView);
				work = serverView;
			} else {
				String[] tabView = serverView.split(",");
				setOk = this.setServerWork(tabView[0]);
				work = tabView[0];
			}
		}

		if (!setOk)
				log.error(
				"userInterface::setServerView():Un serveur pass en paramtre d'instanciation n'est pas correct : "
					+ work);

	}

	/**
	 * @return Returns the _serverWork.
	 */
	public String getServerWork() {
		return serverWork;
	}

	/**
	 * Dfinit le "serveur de travail" c'est--dire le serveur actif 
	 * 
	 * @param le nom d'un serveur (prsent en config)
	 * @return true si le serveur a t trouv, false sinon
	 */
	public boolean setServerWork(String value) {

		serverWork = null;	
		if (value==null){
			/*Si la valeur est null, le canal prend le premier annuaire dclar*/
			if (serverView==null)
				return false;
			
			if (serverView.indexOf(',') == -1) {
				serverWork = serverView;
			} else {
				String[] tabView = serverView.split(",");
				serverWork = tabView[0];
			}
			myServer = myConfig.getServer(serverWork);
			return true;
		}
		
		if (myConfig.getServer(value) != null) {
			if (serverView.matches(".*"+value+".*")){
				serverWork = value;
				myServer = myConfig.getServer(serverWork);
				return true;
			}
			else{
				return false;
			}
		} else {	
				log.error(
				"userInterface::setServerWork():serveur "
					+ value
					+ " introuvable en config.");
			return false;
		}
	}

	/**
	 * Retourne la liste des rsultats
	 * 
	 * @return la liste des rsultats
	 */
	public Hashtable getResults() {
		return result;
	}
	
	public Personne getResult(String key) {
		Object res = result.get(key);
		if (res!=null){
			return (Personne) res;
		}
		return null;
	}
	
	public void cleanResult(){
		result.clear();
	}
	
	
	public void cleanCritere(){
		criteres.clear();
		//eltDeFiltre.clear();
	}
	/**
	 * @return Renvoie lang.
	 */
	public String getLang() {
		return lang;
	}
	/**
	 * @param lang lang  dfinir.
	 */
	public void setLang(String lang) {
		this.lang = lang;
	}
}
