/*
    
 ESUP-portail is a french academic project developed under the GPL (General Public License)
 augmented according to the following :
 
 A binary or source file developped by ESUP-portail can be used or compiled with products under Apache license.
 
 The official english text of the GPL can be found here : http://www.gnu.org/licenses/gpl.html .
  
 A non official french translation can be found here : http://www.linux-France.org/article/these/gpl.html .
 
 The different kinds of licenses governing the products developed by the Apache
 foundation can be found here : http://www.apache.org/licenses .
 
 It follows that you can as well as use download contents as well modify and redistribute
 them provided you respect the GPL terms.
  
 Downloading and using such contents do not provide any guaranty.
 
 Be sure that you have well understood the terms of the license before using the contents it covers.
 
 The ESUP-portail distribution includes the following distributions :
 
 * UPortal :
 software developed by JA-SIG (Java Architecture - Special Interest Group)
 You can find the license page here : http://mis105.udel.edu/ja-sig/uportal/license.html
 
 * CAS :
 SSO solution developed by Yale University
 You can find the project page here : http://www.yale.edu/tp/auth
 
 * Cocoon :
 XML framework distributed by the Apache foundation under Apache license;
 Please find the full text here : http://cocoon.apache.org/2.1/license.html
 
 * Mod_dav:
 A DAV module for Apache web server
 You can find the project page here : http://www.webdav.org/mod_dav
 
 * IMP :
 webmail from Horde application framework
 You can find the project page here : http://www.horde.org
 */
package org.esupportail.portal.channels.CAnnuaire;


import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.Vector;
import org.jasig.portal.*;
import org.jasig.portal.utils.*;
import org.xml.sax.*;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class CAnnuaire implements IChannel, ICacheable, IMimeResponse {
	
	private static final Log log = LogFactory.getLog(CAnnuaire.class);
	
	
	/****************************/
	/*Variables de configuration*/
	/****************************/
	
	/*fichier de configuration*/
	private final static String configFilePath =
		"/properties/channels/org_esup/CAnnuaire/CAnnuaire.xml";
	
	/*feuille ssl*/
	private final static String xslLocation = "CAnnuaire.ssl";
	
	/*temp de cache en secondes*/
	private int cacheTimeOut = 86400;//24 heures
	
	private final static String mailToClass =
		"org.esupportail.portal.channels.CMailTo.CMailToServant";

	/****************************/
	/*Variables de programmation*/
	/****************************/
	
	/*Les tats du canal*/
	private final String ETAT_FORMULAIRE = "Formulaire";
	private final String ETAT_RESULTAT = "afficheResult";
	private final String ETAT_DETAIL = "Detail";
	private final String ETAT_MAIL = "sendMail";
	
	private String etat = null;
	private boolean passeParTab = false;
	private boolean errorConnect = false;
	
	/*interface utilisateur*/
	protected userInterface UI;
	
	ChannelStaticData staticData = null;
	ChannelRuntimeData runtimeData = null;
	boolean formWellFilled = true;
	
	
	/*Servant MailTo*/
	private IServant servant;
	private boolean servantAllowed = false;
	//private boolean servantAvailable = false;
	private String nextMail;
	private final static String toField ="to";//Mail.TO : pour viter la dpendence on n'utilise pas la constante
	
	/*Appel direct*/
	private String detailPers = null;
	private String detailAnnuaire = null;
	private Locale lang = null;
	private Locale lastLang = null;
	private config conf;
	private ResourceBundle ficLang=null;
	
	//Constructeur
	public CAnnuaire() {
		etat = ETAT_FORMULAIRE;
		
		conf = config.getInstance(configFilePath);
		
		UI = new userInterface(conf);
	}
	
	
	
	public ChannelRuntimeProperties getRuntimeProperties() {
		return new ChannelRuntimeProperties();
	}
	
	/** Processes layout-level events coming from the portal
	 * @param ev a portal layout event
	 */
	public void receiveEvent(PortalEvent ev) {
	}
	
	/** Receive static channel data from the portal
	 * @param sd static channel data
	 */
	public void setStaticData(ChannelStaticData sd) {
		this.staticData = sd;
		
		String serveurAuthorise = sd.getParameter("serverView");
		if ((serveurAuthorise == null) || (serveurAuthorise == ""))
			serveurAuthorise = "*";

		errorConnect = !UI.setServerView(serveurAuthorise);
		
		if ( (!staticData.getPerson().isGuest())
			&& (staticData.getParameter("CAnnuaireServantMode")== null)
			){
			servantAllowed=true;
			UI.setMailToAllowed(servantAllowed);
		}
		lastLang = Locale.getDefault();
	}
	
	/** Receives channel runtime data from the portal and processes actions
	 * passed to it.  The names of these parameters are entirely up to the channel.
	 * @param rd handle to channel runtime data
	 * @throws PortalException
	 */
	public void setRuntimeData(ChannelRuntimeData rd) throws PortalException {
		this.runtimeData = rd;
		
		try {
			Locale[] langs = runtimeData.getLocales();			
			if (langs!=null){
				lang = langs[0];
			}
			ficLang = ResourceBundle.getBundle("/org/esupportail/portal/channels/CAnnuaire/languages/CAnnuaire",lang);
			lastLang = lang;			
			
		} catch (Exception e) {//MissingResource
			lang = lastLang;
			ficLang = ResourceBundle.getBundle("/org/esupportail/portal/channels/CAnnuaire/languages/CAnnuaire",lang);
		}
		
		UI.setLang(lang.toString());
		
		
		if (rd.getParameter("etat")!=null)
			etat = rd.getParameter("etat"); 
		
		
		if (!errorConnect){
			if ( (servantAllowed)
				&&(!etat.equals(ETAT_MAIL))
				&&(runtimeData.getParameter("action")!=null)
				&&(runtimeData.getParameter("action").equals("sendMail"))
				){
				
				etat = ETAT_MAIL;
				
				if (log.isDebugEnabled()){
					log.debug("CAnnuaire::setRuntimeData : prepare envoi de mail ");
				}
				
				nextMail = new String();
				String id = rd.getParameter("id");
				String attrib = rd.getParameter("attrib");
				Personne p = UI.getResult(id);
				Vector values = (Vector)p.getAttribute(attrib);
				Iterator i = values.iterator();
				//l'envoi de mail ne se fait que sur la premire adresse
				if (i.hasNext()){
					String val = (String)i.next();
					nextMail += val;
				}
	
				if (log.isDebugEnabled()){
					log.debug("CAnnuaire::setRuntimeData : adresse="+nextMail);
				}
			} 
			
			if (etat.equals(ETAT_MAIL)){	
				
				String[] att = new String[3];
		        att[0] = nextMail;
		        att[1] = "false";
		        att[2] = "true";
		        runtimeData.setParameterValues(toField,att);
			    
			    
			    try {
	
					if (log.isDebugEnabled()){
						log.debug("CAnnuaire::setRuntimeData : appel du servant");
					}
	                Class servantClass = Class.forName(mailToClass);
	                // Instanciation du servant
	                Object servantObj = servantClass.newInstance();
	                servant = (IServant)servantObj;
	            } catch (ClassNotFoundException e) {
	                log.error("CAnnuaire::setRuntimeData:ClassNotFoundException : "+e.getMessage());
	                etat=ETAT_RESULTAT;//servantAvailable = false;
	            } catch (InstantiationException e) {
	            	log.error("CAnnuaire::setRuntimeData:InstantiationException : "+e.getMessage());
	            	etat=ETAT_RESULTAT;//servantAvailable = false;
	            } catch (IllegalAccessException e) {
	            	log.error("CAnnuaire::setRuntimeData:IllegalAccessException : "+e.getMessage());
	            	etat=ETAT_RESULTAT;//servantAvailable = false;
	            } catch (Exception e) {
	            	log.error("CAnnuaire::setRuntimeData:Exception : "+e.getMessage());
	            	etat=ETAT_RESULTAT;//servantAvailable = false;
	            }
	
	            //Passage des paramtres
	            servant.setStaticData(staticData);
	            servant.setRuntimeData(runtimeData);
	            
	            if (servant.isFinished()) {
	            	etat=ETAT_RESULTAT;//
	    			rd.setParameter("backToList","true");
	                nextMail = "";
	            }		    
			}
			else{
				boolean isAction = false;
				
				if (runtimeData.getParameter("updateQuery")!=null){
					etat = ETAT_FORMULAIRE;
					isAction = true;
					passeParTab = false;
				}
				else if (runtimeData.getParameter("backToList")!=null){
					etat=ETAT_RESULTAT;
					UI.addIdToFilter("");
					isAction = true;
				}
				else if (runtimeData.getParameter("id")!=null) {
					etat=ETAT_DETAIL;
					UI.addIdToFilter(runtimeData.getParameter("id"));
					isAction = true;
				}
				else if (runtimeData.getParameter("lanceRecherche")!=null) {
					etat=ETAT_RESULTAT;
					isAction = true;
				}
				else if (runtimeData.getParameter("action")!=null){
					if (runtimeData.getParameter("action").equals("exportList")){
						isAction = true;
					}
				}
						
				/*Appel en mode fiche*/
				if (rd.getParameter("uP_fname")!=null){
					detailPers = runtimeData.getParameter("id");
					detailAnnuaire = runtimeData.getParameter("annuaire");	
					errorConnect = !UI.setServerWork(detailAnnuaire);	
				}
				
				if (!isAction){
					etat = ETAT_FORMULAIRE;
					UI.cleanCritere();
					passeParTab = false;
					if (runtimeData.getParameter("annuaire")!=null)
						errorConnect = !UI.setServerWork(runtimeData.getParameter("annuaire"));
				}
			}
	
			
			if (log.isDebugEnabled()){
				log.debug("CAnnuaire::setRuntimeData : etat="+etat);
			}
		}
	}
	
	/** Output channel content to the portal
	 * @param out a sax document handler
	 */
	public void renderXML(ContentHandler out) throws PortalException {
		
		
		if (etat.equals(ETAT_MAIL)) {
			servant.renderXML(out);
		}
        else{
        	myRenderXML(out);
        }
	}
		
	private  void myRenderXML(ContentHandler out) throws PortalException {	
		int nbRes = 0;
		
		StringBuffer xml = new StringBuffer();
		xml.append("<?xml version=\"1.0\" encoding=\"UTF-8\" ?>\n<RACINE>\n");
		
		if (UI.getServerWork()==null) {
			xml.append("<ALERT>ERROR_FORM_NONE_SERVER_FOUND</ALERT>\n");
		}
		
		if (!errorConnect) {
			if (etat.equals(ETAT_FORMULAIRE)) {
				xml.append(UI.getForm()); 
			} else {
						
				if ( (etat.equals(ETAT_RESULTAT)) 
					&& (runtimeData.getParameter("backToList")==null)
					){
					formWellFilled = UI.updateFilter(runtimeData.getParameters());
				}
				
				if (!formWellFilled) {
					xml.append("<ALERT>WARN_FORM_NOT_FILLED</ALERT>\n");
					etat = ETAT_FORMULAIRE;
					xml.append(UI.getForm());
				} else {
					xml.append(UI.getResultXml());
					if (log.isDebugEnabled()){
						log.debug("CAnnuaire::myRenderXML : filtre de recherche ="+UI.getFiltreComplet());
					}
				}
			}
		} else {
			xml.append("<ALERT>WARN_SERVER_NOT_FOUND</ALERT>\n");
			etat = ETAT_FORMULAIRE;
		}
		xml.append("</RACINE>\n");
		
		/*traitement de la chaine XML*/
		XSLT xslt = new XSLT(this);
		xslt.setXML(xml.toString());

		
		/*Affectation de la feuille XSL en fonction du nombre de rsultat*/
		String feuille = new String();
		if (etat.equals(ETAT_FORMULAIRE)) {
			feuille = "form";
		} else {
			
			nbRes = UI.getNbReponse();
			
			if (nbRes == 0) {
				feuille = "vide";
			} else if ((nbRes > 0)&& (nbRes<= conf.getServer(UI.getServerWork()).getDisplay().getMaxCard())) {
				feuille = "fiche";
				etat=ETAT_DETAIL;
			} else if ((nbRes > conf.getServer(UI.getServerWork()).getDisplay().getMaxCard())) {
				feuille = "tabRes";
				passeParTab = true;
			}
			
		}
		if (log.isDebugEnabled()){
			log.debug("CAnnuaire::myRenderXML : Nombre de rsultat ="+nbRes);
			log.debug("CAnnuaire::myRenderXML : feuille xsl ="+feuille);
		}
		
		try {
			xslt.setXSL(xslLocation, feuille, runtimeData.getBrowserInfo());
		} catch (PortalException e) {
			log.error("CAnnuaire::renderXml() : " + e.toString());
		}
		

		/*Envoie des paramtres au fichierXSL*/
		xslt.setStylesheetParameter("baseActionURL",runtimeData.getBaseActionURL());
		xslt.setStylesheetParameter("baseDownloadURL",runtimeData.getBaseWorkerURL(UPFileSpec.FILE_DOWNLOAD_WORKER, true).replaceAll("%2F", "/"));
		
		if (UI.getServerWork()!=null){
			xslt.setStylesheetParameter("annuSelect", UI.getServerWork());
			if (conf.getServer(UI.getServerWork()).isAllowExport())
				xslt.setStylesheetParameter("allowExport","true");
		}
		
		String rtt = new String();
		if ( (passeParTab) && (etat.equals(ETAT_DETAIL)) )rtt="true"; else rtt="false";
		xslt.setStylesheetParameter("returnToTab", rtt);
		
		String displayHeader = new String();
		if ( detailPers!=null )displayHeader="false"; else displayHeader="true";
		xslt.setStylesheetParameter("displayHeader", displayHeader);
		
		
		if (this.staticData.getParameter("CAnnuaireServantMode") != null) {
			if (this.staticData.getParameter("returnServant")==null)
					this.staticData.put("returnServant","single");
			if (this.staticData.getParameter("returnServant").equals("single"))
				xslt.setStylesheetParameter("modeServant", "single");
			else
				xslt.setStylesheetParameter("modeServant", "multiple");
		}

		xslt.setResourceBundle(ficLang);
		
		
		
		xslt.setTarget(out);
		try {
			xslt.transform();
		} catch (PortalException e) {
			log.error("CAnnuaire::myRenderXML() : Une erreur est survenue lors du parsing XML/XSL : ",e);
			XSLT xsltError = new XSLT(this);
			xml.delete(0,xml.toString().length());
			xml.append("<?xml version=\"1.0\" encoding=\"UTF-8\" ?>\n<RACINE>\n");
			xml.append("<ALERT>ERROR_WHILE_PARSING</ALERT>\n");
			xml.append("</RACINE>\n");
			xsltError.setXML(xml.toString());
			xsltError.setResourceBundle(ficLang);
			xsltError.setTarget(out);
			try {
				xsltError.setXSL(xslLocation, "form", runtimeData.getBrowserInfo());
			} catch (PortalException f) {
				log.error("CAnnuaire::renderXml() : " + f.toString());
			}
			try {
				xsltError.transform();
			} catch (PortalException f) {
				log.error("CAnnuaire::myRenderXML() : L'affichage de l'erreur a chou : ",f);
			}
		}
		
	}
	
	/******************************************************************************/
	/** Genration d'une cle pour le cache
	 * 
	 * @return ChannelCacheKey cle du cache
	 */
	public ChannelCacheKey generateKey() {
		
		if (!etat.equals(ETAT_FORMULAIRE))  return null;
		
		if (!formWellFilled)  return null;
		
		if (runtimeData.getParameter("updateQuery")!=null)return null;
		
		StringBuffer sbKey = new StringBuffer(1024);
		sbKey.append(this.getClass().getName() + " : ");
		sbKey.append("language:").append(lang).append(", ");
		sbKey.append("serverview:").append(UI.getServerView()).append(", ");
		sbKey.append("serverwork:").append(UI.getServerWork());
		
		ChannelCacheKey k = new ChannelCacheKey();
		
		k.setKeyScope(ChannelCacheKey.INSTANCE_KEY_SCOPE);

		if (log.isDebugEnabled()){
			log.debug("CAnnuaire::generateKey : sbKey="+sbKey);
		}
		
		k.setKey(sbKey.toString());
		k.setKeyValidity(new Long(System.currentTimeMillis()));
		return k;
	}
	
	/**
	 * Teste si le cache est valide
	 * @param validity
	 * @return boolean
	 */
	public boolean isCacheValid(Object validity) {
		
		if (!etat.equals(ETAT_FORMULAIRE)) return false;
		
		if (runtimeData.getParameter("updateQuery")!=null)return false;
			
		boolean cacheValid = false;
		
		if (validity instanceof Long) {
			Long oldtime = (Long) validity;
			// Si validity  moins de cacheTimeOut secondes le cache est valide
			if (System.currentTimeMillis() - oldtime.longValue()
					< cacheTimeOut * 1000) {
				cacheValid = true;
			}
		}
		if (log.isDebugEnabled()){
			log.debug("CAnnuaire::isCacheValid : "+cacheValid);
		}
		return cacheValid;
	}
	/********************************************************/

	
	/**
	* Retourne le type MIME du document
	* @return Le type MIME
	*/
	public String getContentType() {
		return "application/octet-stream";
	}

	/**
	* Retourne un InputStream correspondant au fichier  tlcharger
	* @return Le flux de donnes
	*/
	public InputStream getInputStream() throws IOException {
		return null; // construction du fichier  la vole sinon retourner un InputStream valide vers un fichier
	}

	/**
	* Mthode qui construit le flux csv
	* @param out Un OutputStream vers le navigateur du client
	*/
	public void downloadData(OutputStream out) throws IOException {
		StringBuffer csv = new StringBuffer();
		csv.append(UI.getResultCsv());
		out.write(csv.toString().getBytes());
		out.close();
	}
	
	/**
	* Retourne le nom du fichier
	* @return Le nom du fichier
	*/
	public String getName() {
		return "export.csv"; // nom du fichier  tlcharger
	}

	/**
	* Retourne la liste des headers HTTP  envoyer au navigateur
	* @return La liste des headers
	*/
	public Map getHeaders() {
			HashMap map = new HashMap(); 
          map.put("Content-disposition", "attachment; filename=" + getName()); 
          return map;

	}

	/**
	* Mthode appele si une erreur se produit durant le tlchargement
	* @param e L'exception leve
	*/
	public void reportDownloadError(Exception e) {
		log.error("ListeCSV::reportingDownloadError() : " + e);
		
	}
}
