<?xml version="1.0" encoding="ISO-8859-1" ?>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">

    <xsl:param name="baseActionURL">donne par le code</xsl:param>
    <xsl:param name="baseDownloadURL">donne par le code</xsl:param>
    <xsl:param name="returnToTab">donne par le code</xsl:param>
    <xsl:param name="mediaPath">media/org/esupportail/portal/channels/CAnnuaire</xsl:param>
	<xsl:param name="allowExport">false</xsl:param>
   
   <xsl:template name="entete">
   <table align="center" width="100%">
   <tr>
   		<th class="uportal-channel-subtitle">
   			<xsl:if test="$returnToTab='true'">
   				<a href="{$baseActionURL}?uP_root=root&amp;backToList=true"><img src="{$mediaPath}/back.gif" title="{$TXT_HEADER_BACK_TO_LIST_OF_RESULT}" border="0"/>&#160;<xsl:value-of select="$TXT_HEADER_BACK_TO_LIST_OF_RESULT" disable-output-escaping="yes" /></a>  
				&#160;&#160;&#160;
   			</xsl:if>   

   			<a href="{$baseActionURL}?uP_root=root&amp;updateQuery=true"><img src="{$mediaPath}/modify.gif" title="{$TXT_HEADER_MODIFY_QUERY}" border="0"/>&#160;<xsl:value-of select="$TXT_HEADER_MODIFY_QUERY" disable-output-escaping="yes" /></a> 
   			
   			&#160;&#160;&#160; 
   			<a href="{$baseActionURL}?uP_root=root&amp;newQuery=true"><img src="{$mediaPath}/newfile.gif" title="{$TXT_HEADER_NEW_QUERY}" border="0"/>&#160;<xsl:value-of select="$TXT_HEADER_NEW_QUERY" disable-output-escaping="yes" /></a> 
			
			<xsl:if test="$allowExport='true'">
				&#160;&#160;&#160; 
				<a href="{$baseDownloadURL}?action=exportList"><img src="{$mediaPath}/save.gif" title="{$TXT_HEADER_EXPORT}" border="0"/>&#160;<xsl:value-of select="$TXT_HEADER_EXPORT" disable-output-escaping="yes" /></a> 
   			</xsl:if>   
   			<hr/>
   		</th>
   	</tr>
   	
   	<xsl-if test="$TXT_HEADER_COMMENT!=''">
   	<tr>
   		<td class="uportal-channel-text">
   		<xsl:value-of select="$TXT_HEADER_COMMENT" disable-output-escaping="yes" />
		</td>
	</tr>
	</xsl-if>
   	<tr>
   		<td class="uportal-channel-strong" align="center">
   		
   		<xsl:choose>
   			<xsl:when test="NBREPONSES=0">
   				<xsl:value-of select="$TXT_HEADER_NO_RESULT" disable-output-escaping="yes" />
   			</xsl:when>
   			
   			<xsl:when test="NBREPONSES=1">
   				<xsl:value-of select="$TXT_HEADER_ONE_RESULT" disable-output-escaping="yes" />
   			</xsl:when>
   		  
   			<xsl:otherwise>
   				<xsl:value-of select="substring-before($TXT_HEADER_SOME_RESULT,'%d')" disable-output-escaping="yes" />
   				<xsl:value-of select="NBREPONSES" />
   				<xsl:value-of select="substring-after($TXT_HEADER_SOME_RESULT,'%d')" disable-output-escaping="yes" />
   			</xsl:otherwise>
   		</xsl:choose>
   		</td>
   		
   	</tr>
   	</table>
   	<a href=""></a>  
   			
   </xsl:template>  
   
  
   
</xsl:stylesheet>
