<?xml version="1.0" encoding="ISO-8859-1" ?>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">
   
	<xsl:include href = "${stylesheets.fullpath}/CAnnuaireEntete.xsl" />

	<xsl:include href = "${stylesheets.fullpath}/CAnnuaireCritere.xsl" />
	
	<xsl:param name="modeServant">none</xsl:param>
	
	<xsl:param name="displayHeader">none</xsl:param>

   <xsl:param name="mediaPath">media/org/esupportail/portal/channels/CAnnuaire</xsl:param>
	
   <xsl:template match="tagEnglobant">
	<form action="{$baseActionURL}" method="post">
	   <table align="center" width="100%">  	
			
		<xsl:if test="$displayHeader='true'">
			<tr><td>
			<xsl:call-template name = "entete" />
			</td></tr>
		
			<tr><td>
			<xsl:call-template name = "critere" />
			</td></tr>
		</xsl:if>
		
		<tr>
		<td>   
		<xsl:apply-templates select = "resultat" >   	
		<xsl:sort select="attributTri/@value"/>
		</xsl:apply-templates>
		</td>
		</tr>
		
		<xsl:if test="$displayHeader='false'">
			<tr><td>
				<input type="hidden" name="uP_root" value="root"/>
				<input type="submit" name="CAnnuaireReturnToChannel" value="{$TXT_SERVANT_BACK}"  class="uportal-button"/>
			</td></tr>
		</xsl:if>
		
	   </table>
	   
	   <xsl:if test="$modeServant!='none'">
	   <center>
	   <br/>
	   <xsl:choose>
	   <xsl:when test="/RACINE/tagEnglobant/NBREPONSES > 1"> 
		  <input type="hidden" value="root" name="uP_root" />
		  <input type="submit" name="CAnnuaireServantFinished" value="{$TXT_SERVANT_VALID}" class="uportal-button" /> 
	   </xsl:when>
	   <xsl:otherwise>
			<input type="hidden" value="root" name="uP_root" />
		   <input type="submit" name="CAnnuaireServantFinished" value="{$TXT_SERVANT_SELECT}" class="uportal-button" /> 
	   </xsl:otherwise>    
	   </xsl:choose>
	   </center>	
	   </xsl:if>
	</form>
   </xsl:template>
   
   

   
<!--AFFICHAGE DES LIGNES RESULTAT-->
   <xsl:template match="resultat">   	
   	
   	<xsl:if test="/RACINE/tagEnglobant/NBREPONSES > 1"> 
   	<xsl:choose>
		<xsl:when test="$modeServant='multiple'">
			<input type="checkbox" name="pers_id[]" value="{attributId/@value}" />
   			<font class="uportal-channel-text">Slectionner la fiche</font>
		</xsl:when>
		<xsl:when test="$modeServant='single'">
			<input type="radio" name="pers_id" value="{attributId/@value}" />
   			<font class="uportal-channel-text">Slectionner la fiche</font>
		</xsl:when>
	</xsl:choose>    
   	</xsl:if>
   	<table border="4" cellpadding="0" cellspacing="0" align="center" width="300" border-style="outset" >
   	<tr>
   		<td>
   			<table border="0" cellpadding="2" cellspacing="2" align="center" width="100%">   
			
			<xsl:apply-templates select = "attributRes" />
	      
			 <xsl:if test="attributLink/@value!=''">
				<tr valign="top">
					<td align="left" colspan="2">
						<a href="{attributLink/@value}" target="_blank" >
							<img src="{$mediaPath}/info.gif" title="{$TXT_INFO_EXTERN_ANNUARY}" border="0"/>
							<xsl:value-of select="$TXT_INFO_EXTERN_ANNUARY" />
						</a>
					</td>
				</tr>
			 </xsl:if>
			</table>
   		</td>
   	</tr>
   	</table>
			<br/>
   </xsl:template>
   
   
<!--AFFICHAGE DES LIGNES RESULTAT-->
   <xsl:template match="attributRes">
   <xsl:if test="count(valeur)>0">
	   <tr valign="top">
	   <td class="uportal-label" align="left">
	      <xsl:value-of select="@display" />&#160;: 
	   </td>
	   <td class="uportal-channel-text">
		<xsl:choose>
			<xsl:when test = "@isMail!=''">
				<xsl:variable name="title">
					<xsl:value-of select="substring-before($TXT_INFO_SEND_MAIL,'%s')" disable-output-escaping="yes" />
					<xsl:value-of select="valeur[position()=1]" />
					<xsl:value-of select="substring-after($TXT_INFO_SEND_MAIL,'%s')" disable-output-escaping="yes" />
				</xsl:variable>
				<a href="{$baseActionURL}?action=sendMail&amp;attrib={@isMail}&amp;id={../attributId/@value}"
					title="{$title}">
					<xsl:for-each select = "valeur">
						<xsl:value-of select="current()" /><br />
					</xsl:for-each>
				</a>
			</xsl:when>
			<xsl:otherwise>
				<xsl:for-each select = "valeur">
					<xsl:value-of select="current()" /><br />
				</xsl:for-each>
			</xsl:otherwise>
		</xsl:choose>
	   </td>
	   </tr>
   </xsl:if>
   </xsl:template>
   
   
</xsl:stylesheet>
