<?xml version="1.0" encoding="ISO-8859-1" ?>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">
  	
	<xsl:include href = "${stylesheets.fullpath}/CAnnuaireAlertes.xsl" />

 	<xsl:output method="html" encoding="UTF-8" />

   <xsl:param name="baseActionURL">donne par le code</xsl:param>

   <xsl:param name="annuSelect">donne par le code</xsl:param>

   <xsl:param name="numCanal"/>
 
   <xsl:param name="modeServant">none</xsl:param>
 
 
   <xsl:template match="RACINE">
   <xsl:apply-templates select="ALERT" /> 
   

   <xsl:apply-templates select="FORM" />
 
   </xsl:template>
 
 
   <xsl:template match="FORM">
   
         <form action="{$baseActionURL}" method="POST" name="myForm">
            <input type="hidden" value="" name="action" />

            <table class="uportal-background-content">

               <xsl:choose>
                  <xsl:when test="count(SERVER)&gt;1">
                     <tr>
                        <td align="rigth">
                           <font class="uportal-channel-text"><xsl:value-of select="$TXT_FORM_CHOOSE_ANNUARY" disable-output-escaping="yes" /></font>
                        </td>

                        <th align="left">
                           <select name="annuaire" onchange="submit()" class="uportal-input-text">
                              <xsl:for-each select="SERVER">
                                 <xsl:choose>
                                    <xsl:when test="$annuSelect=@name">
                                       <option value="{@name}" selected="true">
                                          <xsl:value-of select="@label" />
                                       </option>
                                    </xsl:when>

                                    <xsl:otherwise>
                                       <option value="{@name}">
                                          <xsl:value-of select="@label" />
                                       </option>
                                    </xsl:otherwise>
                                 </xsl:choose>
                              </xsl:for-each>
                           </select>
                        </th>
                     </tr>
                  </xsl:when>

                  <xsl:when test="count(SERVER)=1">
                     <tr>
                        <th class="uportal-channel-subtitle" align="rigth">
                           <span class="uportal-channel-text"><xsl:value-of select="$TXT_HEADER_SEARCH_ON" disable-output-escaping="yes" /></span>
                        </th>

                        <th align="left">
                                <xsl:value-of select="SERVER/@label" />
                        </th>
                     </tr>
                  </xsl:when>
               </xsl:choose>  

				 <xsl:if test="INTRO!='null'">
					 <tr>
						<td colspan="2" align="center" class="uportal-channel-warning">
						   <xsl:value-of select="INTRO" />
						</td>
					 </tr>
				 </xsl:if>    

                     <xsl:call-template name="FIELDS" />

                     <tr>
                        <td colspan="2" align="center">
                           <input type="submit" class="uportal-button" value="{$TXT_FORM_LUNCH_SEARCH}" name="lanceRecherche" />
                        </td>
                     </tr>       
                  
		         <xsl:if test="$modeServant!='none'">
		         
		         <tr>
		         	<td colspan="2" align="center">
		   	        	<form action="{$baseActionURL}" method="post" name="form_retour">
							<input type="hidden" name="retour" value="1"/>		   	        	
		   					<input type="submit" name="CAnnuaireServantFinished" value="Retour" class="uportal-button"/> 
		   				</form>
		    	   	</td>
		         </tr>
		   		   		
		   		</xsl:if>
            </table>
         </form>
   </xsl:template>

<!--TEMPLATE DE L'AFFICHAGE DES CHAMPS-->
   <xsl:template name="FIELDS">
      <tr>
         <td colspan="2">&#160;</td>
      </tr>

      <tr>
         <td colspan="2">
            <table border="0" class="uportal-background-content">
               <xsl:apply-templates select="FIELD" />
            </table>
         </td>
      </tr>

      <tr>
         <td colspan="2">&#160;</td>
      </tr>
   </xsl:template>

<!--TEMPLATE D'UN CHAMP-->
   <xsl:template match="FIELD">
      <xsl:choose>
         <xsl:when test="@saisie=1">
            <tr>
               <td class="uportal-channel-label">
                  <xsl:value-of select="@label" />
               </td>

               <td>
                  <xsl:choose>
                     <xsl:when test="count(FIELDVALUE)=0">
                        <input type="text" name="{@name}" value="{@value}" class="uportal-input-text"/>                       
                        
                        <xsl:if test="@minChar!=''">&#160;
                        	<font class="uportal-channel-text">
   								<xsl:value-of select="substring-before($TXT_FORM_AT_LEAST_N_CHARACTERS,'%d')" disable-output-escaping="yes" />
								<xsl:value-of select="@minChar" />
								<xsl:value-of select="substring-after($TXT_FORM_AT_LEAST_N_CHARACTERS,'%d')" disable-output-escaping="yes" />
							</font>
                        </xsl:if>
                     </xsl:when>

                     <xsl:otherwise>
                        <select name="{@name}" class="uportal-input-text">
	                       <option value="">&#160;</option>
                           <xsl:for-each select="FIELDVALUE">
                              <xsl:sort select="@order" />
                  			<xsl:choose>
                     			<xsl:when test="@code=../@value">
	                              <option value="{@code}" selected="true">
	                                 <xsl:value-of select="@value" />
	                              </option>
								</xsl:when>
                     			
                     			<xsl:otherwise>
	                              <option value="{@code}">
	                                 <xsl:value-of select="@value" />
	                              </option>
                     			</xsl:otherwise>
                  			</xsl:choose>
                           </xsl:for-each>
                        </select>
                     </xsl:otherwise>
                  </xsl:choose>
               </td>
            </tr>
         </xsl:when>

         <xsl:otherwise>
            <input type="hidden" name="{@name}" value="{@value}" />
         </xsl:otherwise>
      </xsl:choose>
   </xsl:template>
</xsl:stylesheet>

