<?xml version="1.0" encoding="ISO-8859-1" ?>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">
	 
	

	<xsl:include href = "${stylesheets.fullpath}/CAnnuaireAlertes.xsl" />

	<xsl:include href = "${stylesheets.fullpath}/CAnnuaireEntete.xsl" />

	<xsl:include href = "${stylesheets.fullpath}/CAnnuaireCritere.xsl" />

   <xsl:param name="baseActionURL">donne par le code</xsl:param>

   <xsl:param name="mediaPath">media/org/esupportail/portal/channels/CAnnuaire</xsl:param>

   <xsl:param name="modeServant">none</xsl:param>



   <xsl:template match="RACINE">
   
   <xsl:apply-templates select = "ALERT" />  
   
   <xsl:apply-templates select = "tagEnglobant" />  
 
   </xsl:template>
   
   <xsl:template match="tagEnglobant">
   	  <form action="{$baseActionURL}" name="formAnnuary" method="post">	
   	
   	  	
   	<table align="center" width="100%">
   	
   	<tr><td>
   	<xsl:call-template name = "entete" />
   	</td></tr>
   

   	<tr><td align="center">
   	<xsl:call-template name = "critere" />
   	</td></tr>
   	   	
   	
   	<tr>
   	<td align="center">
   	
   	<table border="1" cellpadding="2" cellspacing="3"> 
   	
   	<tr class="uportal-background-med">   
		<xsl:if test="$modeServant!='none'">
			<th class="uportal-channel-table-header">&#160;</th>
		</xsl:if>	
		
		<xsl:apply-templates select = "attributEntete" />
   	</tr> 
   	  	
   	
   	<xsl:apply-templates select = "resultat" >   	
   	<!--<xsl:sort select="attributTri/@value"/>-->
   	</xsl:apply-templates>
   	
   	</table>
   	
   	</td>
   	</tr>
   	
   </table>

      <xsl:if test="$modeServant!='none'">
         <center>
         		<br/>
               <input type="submit" name="CAnnuaireServantFinished" value="{$TXT_SERVANT_SELECT}" class="uportal-button" />
         </center>
      </xsl:if>
      </form>
   	
   </xsl:template>
   
   

   
   
<!--AFFICHAGE DES ENTETES EN FONCTION DES ATTRIBUTS RECHERCHES-->
   <xsl:template match="attributEntete">   
   <xsl:if test = "@list=1">
   	<th class="uportal-channel-table-caption" ><xsl:value-of select="@display" /></th>
   </xsl:if>
   </xsl:template>
   
<!--AFFICHAGE DES LIGNES RESULTAT-->
   <xsl:template match="resultat">
		<xsl:param name="background">
			<xsl:choose>
				<xsl:when test="(position() mod 2) = 0">uportal-background-light</xsl:when>
				<xsl:otherwise>uportal-background-content</xsl:otherwise>
			</xsl:choose>
		</xsl:param>

		<tr class="{$background}" onmouseover="this.className='uportal-background-highlight';" onmouseout="this.className='{$background}';">
	      	 
	      	 <xsl:if test="$modeServant!='none'">
	            <td>
	            <xsl:choose>
	         		<xsl:when test="$modeServant='multiple'">
	                <input type="checkbox" name="pers_id[]" value="{attributId/@value}" />
	                </xsl:when>
	                <xsl:when test="$modeServant='single'">
	                <input type="radio" name="pers_id" value="{attributId/@value}" />
	                </xsl:when>
	            </xsl:choose>    
	            </td>
	         </xsl:if>
	         
	         <xsl:if test="attributLink/@value!=''">
	            <td>
	            	<a href="{attributLink/@value}" target="_blank" >
						<img src="{$mediaPath}/info.gif" title="{$TXT_INFO_EXTERN_ANNUARY}" border="0"/>
	            	</a>
	            </td>
	         </xsl:if>
	        <xsl:apply-templates select = "attributRes" />
		</tr>
   </xsl:template>
   
   
<!--AFFICHAGE DES LIGNES RESULTAT-->
   <xsl:template match="attributRes"> 
	   <xsl:if test = "@list=1">
	   	  <xsl:choose>
		   	  
		   	  <xsl:when test = "count(valeur)=0">
			   <td class="uportal-channel-text">
			   &#160;<!--espace-->
			   </td>
		   	  </xsl:when>
		   	  
		   	  <xsl:when test = "@linkToCard=1">
			   	<xsl:variable name="title">
   					<xsl:value-of select="substring-before($TXT_INFO_DETAIL,'%s')" disable-output-escaping="yes" />
					<xsl:value-of select="valeur" />
					<xsl:value-of select="substring-after($TXT_INFO_DETAIL,'%s')" disable-output-escaping="yes" />
			   	</xsl:variable>
			   <td class="uportal-channel-text">
			   	<a href="{$baseActionURL}?id={../attributId/@value}" title="{$title}"><xsl:value-of select="valeur" /></a><br />			   
			   </td>
		   	  </xsl:when>
		   	  
		   	  <xsl:when test = "@isMail!=''">
			   	<xsl:variable name="title">
   					<xsl:value-of select="substring-before($TXT_INFO_SEND_MAIL,'%s')" disable-output-escaping="yes" />
					<xsl:value-of select="valeur[position()=1]" />
					<xsl:value-of select="substring-after($TXT_INFO_SEND_MAIL,'%s')" disable-output-escaping="yes" />
			   	</xsl:variable>
			   <td class="uportal-channel-text">
			   <a href="{$baseActionURL}?action=sendMail&amp;attrib={@isMail}&amp;id={../attributId/@value}" title="{$title}">
			   	<xsl:for-each select = "valeur">
					<xsl:value-of select="current()" /><br />
				</xsl:for-each>
			   </a>
			   	
			   </td>
		   	  </xsl:when>
			  
			  <xsl:otherwise>
			   <td class="uportal-channel-text">
			   <xsl:for-each select = "valeur">
				<xsl:value-of select="current()" /><br />
			   </xsl:for-each>
			   </td>
			  </xsl:otherwise> 
		  </xsl:choose>
	   </xsl:if>
   </xsl:template>
   
   
</xsl:stylesheet>

