/*

ESUP-portail is a french academic project developed under the GPL (General Public License)
augmented according to the following :

A binary or source file developped by ESUP-portail can be used or compiled with products under Apache license.

The official english text of the GPL can be found here : http://www.gnu.org/licenses/gpl.html .

A non official french translation can be found here : http://www.linux-France.org/article/these/gpl.html .

The different kinds of licenses governing the products developed by the Apache
foundation can be found here : http://www.apache.org/licenses .

It follows that you can as well as use download contents as well modify and redistribute
them provided you respect the GPL terms.

Downloading and using such contents do not provide any guaranty.

Be sure that you have well understood the terms of the license before using the contents it covers.

The ESUP-portail distribution includes the following distributions :

* UPortal :
software developed by JA-SIG (Java Architecture - Special Interest Group)
You can find the license page here : http://mis105.udel.edu/ja-sig/uportal/license.html

* CAS :
SSO solution developed by Yale University
You can find the project page here : http://www.yale.edu/tp/auth

* Cocoon :
XML framework distributed by the Apache foundation under Apache license;
Please find the full text here : http://cocoon.apache.org/2.1/license.html

* Mod_dav:
A DAV module for Apache web server
You can find the project page here : http://www.webdav.org/mod_dav

* IMP :
webmail from Horde application framework
You can find the project page here : http://www.horde.org
*/
package org.esupportail.portal.channels.CAnnuaire;

import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Vector;

import org.esupportail.portal.channels.CAnnuaire.config.AttributeLine;
import org.esupportail.portal.channels.CAnnuaire.config.Line;
import org.esupportail.portal.channels.CAnnuaire.config.custom.ACustomMail;

public class Personne {
    //private static final Log log = LogFactory.getLog(CAnnuaire.class); 

	/**
	 * LDAP attributs to get by person
	 */
	private Hashtable attributes = new Hashtable();
	
	/**
	 * Value to order results
	 */
	private String attribOrder;
	
	/**
	 * Represent the identifier of the person
	 */
	private String identifier;
	
	/**
	 * Link to an external annuary
	 * (%uid is the place of the identifier in the url)
	 */
	private String link;

	/**
	 * Returns all attributs 
	 * 
	 * @return  Hashtable
	 */
	public Hashtable getAttributes() {
		return attributes;
	}


	/**
	 * Routrne la/les valeurs de l'attribut dont le code est pass en paramtre
	 * 
	 * @return la valeur de l'attribut
	 */
	public Vector getAttribute(String idLdap) {
		if (attributes.get(idLdap) != null)
			return ((AttributeLine) attributes.get(idLdap)).getValues();
		else
			return null;
	}

	/**
	 * Add attribute
	 * 
	 * @param AttributeLine
	 */
	public void addAttributes(AttributeLine attr) {
		if ((attr != null) && (attr.getVarI18n() != ""))
			attributes.put(attr.getAttribute(), attr);
	}


	/**
	 * Ajoute la valeur de tri de la personne
	 * 
	 * @param la valeur de tri
	 */
	public void setSort(String value) {
		attribOrder = value;
	}


	/**
	 * Retourne une chaine xml pour prsenter tous les attributs d'une personne
	 * L'ordre de ces attributs est le Vecteur pass en paramtre
	 * 
	 * @param ordre des attributs
	 * @return chaine XML
	 */
	public StringBuffer toXml(Vector lineOrder,boolean servantActive,boolean guestMode) {
		StringBuffer xml = new StringBuffer();
		if (attributes != null) {
			xml.append("<resultat>\n");
			xml.append("<attributTri  value=\"" + userInterface.valueToXml(attribOrder) + "\" />\n");
			if ( (link!=null) && (!link.equals("")) ){
				xml.append("<attributLink  value=\"" + userInterface.valueToXml(link.replaceAll("%uid",identifier)) + "\" />\n");
			}
			xml.append("<attributId value=\"" + userInterface.valueToXml(identifier) + "\" />\n");
			Iterator i = lineOrder.iterator();
			while (i.hasNext()) { 
				Line maLigne = (Line)i.next();

				xml.append("<line ");
				xml.append("display=\"").append(userInterface.valueToXml(maLigne.getVarI18n(), userInterface.getLang())).append("\" ");
				xml.append("visibility=\"").append(maLigne.getVisibility()).append("\" ");
				xml.append("linkType=\"").append(maLigne.getLinkType()).append("\" ");
				xml.append("fieldConnection=\"").append(maLigne.getFieldConnection()).append("\" ");
				xml.append(">\n");
				Iterator j = maLigne.getAttributes().iterator();
				while (j.hasNext()) { 
					String attrCle = (String) j.next();
					AttributeLine attr = (AttributeLine) attributes.get(attrCle);

					if (attr!=null){
						if (attr.getValues() != null) {	
							Enumeration val = attr.getValues().elements();
							if (val != null) {
								int compteur = 0;
								while (val.hasMoreElements()) {
									
									String v = (String) val.nextElement();
									/*le $ est le saut de ligne pour un champ LDAP => 1 valeur par ligne*/
									String[] vals = v.split("\\$");
									for (int tmp=0;tmp<vals.length;tmp++) {
										xml.append("<value ");
										xml.append("name=\"").append(attrCle).append( "\" ");

										if (maLigne.getLinkType().equals(Line.LINE_LINK_TYPE_MAIL)){
											ACustomMail custom = maLigne.getCustomMailClass(); 
											xml.append("externalLink=\"").append(custom.getUrl(servantActive,guestMode,attrCle,identifier,vals[tmp])).append("\" ");
										}
										if (maLigne.getLinkType().equals(Line.LINE_LINK_TYPE_EXTERNAL)){
											link = maLigne.getRealExternalLink((String)attr.getRealValues().get(compteur),(String)attr.getValues().get(compteur));
											xml.append("externalLink=\"").append(link).append("\" ");
										}									
										xml.append(" >");
										
										xml.append(userInterface.valueToXml(vals[tmp]));
											
									    xml.append("</value>\n");
									
										
									}
									compteur++;
								}
								
							}
						}
					}
				}
				xml.append("</line>\n");
			}
			
			xml.append("</resultat>\n");
		}

		return xml;
	}
	
	/**
	 * Retourne une chaine csv pour prsenter tous les attributs d'une personne
	 * L'ordre de ces attributs est le Vecter pass en paramtre
	 * 
	 * @param ordre des attributs
	 * @return chaine XML
	 */
	public StringBuffer toCsv(Vector ordre) {
		StringBuffer csv = new StringBuffer();
		if (attributes != null) {
			Iterator i = ordre.iterator();
			while (i.hasNext()) { 
				Line maLigne = (Line)i.next();
				
				Iterator j = maLigne.getAttributes().iterator();
				csv.append("\"");
				while (j.hasNext()) { 
					String attrCle = (String) j.next();
					AttributeLine attr = (AttributeLine) attributes.get(attrCle);
					
					if (attr.getValues() != null) {
						Enumeration val = attr.getValues().elements();
						boolean first = true;
						if (val != null) {
							while (val.hasMoreElements()) {
								char cr = 10;
								if (!first)csv.append(cr);
								String v = (String) val.nextElement();
								v = v.replaceAll("\\$",String.valueOf(cr));
								csv.append(v);
								first = false;
							}
						}
					}
					csv.append(" ");
				}
				csv.append("\";");
			}
		}

		csv.append("\n");
		return csv;
	}

	/**
	 * 
	 * @return
	 * @deprecated ATTENTION, LE NOM A CHANGE EN getIdentifier()
	 */
	public String getIdentifiant() {
		return getIdentifier();
	}
	/**
	 * Retourne la valeur de l'identifiant de cette personne
	 * 
	 * @return la valeur de l'identifiant
	 */
	public String getIdentifier() {
		return identifier;
	}

	/**
	 * Dfinit la valeur de l'identifiant de cette personne
	 * 
	 * @param la valeur de l'identifiant
	 */
	public void setIdentifier(String string) {
		identifier = string;
	}
	
	/**
	 * Dfinit la valeur du lien vers une application extrieure
	 * (%uid pour l'emplacement de l'identifiant de la personne)
	 * @param le lien
	 */
	public void setLink(String string) {
		link = string;
	}	
	
	public String getSort(){
		return attribOrder;
	}
}
