/*

ESUP-portail is a french academic project developed under the GPL (General Public License)
augmented according to the following :

A binary or source file developped by ESUP-portail can be used or compiled with products under Apache license.

The official english text of the GPL can be found here : http://www.gnu.org/licenses/gpl.html .

A non official french translation can be found here : http://www.linux-France.org/article/these/gpl.html .

The different kinds of licenses governing the products developed by the Apache
foundation can be found here : http://www.apache.org/licenses .

It follows that you can as well as use download contents as well modify and redistribute
them provided you respect the GPL terms.

Downloading and using such contents do not provide any guaranty.

Be sure that you have well understood the terms of the license before using the contents it covers.

The ESUP-portail distribution includes the following distributions :

* UPortal :
software developed by JA-SIG (Java Architecture - Special Interest Group)
You can find the license page here : http://mis105.udel.edu/ja-sig/uportal/license.html

* CAS :
SSO solution developed by Yale University
You can find the project page here : http://www.yale.edu/tp/auth

* Cocoon :
XML framework distributed by the Apache foundation under Apache license;
Please find the full text here : http://cocoon.apache.org/2.1/license.html

* Mod_dav:
A DAV module for Apache web server
You can find the project page here : http://www.webdav.org/mod_dav

* IMP :
webmail from Horde application framework
You can find the project page here : http://www.horde.org
*/
package org.esupportail.portal.channels.CAnnuaire.config;
import java.util.*;
import javax.naming.directory.*;

import org.esupportail.portal.channels.CAnnuaire.config.elemOfQuery.AElmOfQuery;


public class Query {

	/**
	 * Represente la liste des lments prsents sur le formulaire
	 * indxs par le nom html du champ
	 */
	private Hashtable elements = new Hashtable();

	/**
	 * Represente l'ordre des lments prsents sur le formulaire
	 */
	private Vector ordreElements = new Vector();
	
	/**
	 * Represente la base LDAP de recherche
	 */
	private String base;

	/**
	 * Represente le nombre maximum que le serveur peut retourner
	 */
	private int maxEntries;

	/**
	 * Represente le type de recehrche effectu 
	 * (SearchControls.SUBTREE_SCOPE ONELEVEL_SCOPE) 
	 */
	private int scope;

	/**
	 * Represente l'identifiant (champ LDAP) d'un rsultat
	 * sert pour passer de l'affichage du tableau  l'affichage
	 * en mode fiche
	 */
	private String identifier;


	
	/**
	 * @return l'identifiant (champ LDAP) d'un rsultat
	 */
	public String getIdentifier() {
		return identifier;
	}

	/**
	 * Dfinit l'identifiant (champ LDAP) d'un rsultat
	 * 
	 * @param string
	 */
	public void setIdentifier(String string) {
		identifier = string;
	}

	/**
	 *
	 * @return la base LDAP de recherche
	*/ 
	public String getBase() {
		return base;
	} // end getBase

	/**
	 * Dfinit la base LDAP de recherche
	 *
	 *
	 * @param la base
	*/ 
	public void setBase(String _base) {
		base = _base;
	} // end setBase

	/**
	 * Ajoute un lment au formulaire de recherche
	 *
	 * @param un lment
	 */
	public void addElement(AElmOfQuery _elem) { 
		_elem.setNameHtml("element" + elements.size());
		elements.put(_elem.getNameHtml(),_elem);
		ordreElements.add(_elem.getNameHtml());
	} // end addElement

	/**
	 * Retourne tous les lments du formulaire
	 * 
	 * @return les lments indexs sur le nom html
	 */
	public Vector getElements() {
		return (ordreElements);
	}

	/**
	 * Retourne un lment du formulaire dont le nom html est pass en paramtre
	 * 
	 * @param nameHtml
	 * @return l'lment demand
	*/
	public AElmOfQuery getElement(String nameHtml) {
		return ((AElmOfQuery)elements.get(nameHtml));
	} 


	/**
	 * Dans le cas d'une liste droulante
	 * Retourne le nombre maximum d'lments que LDAP doit retourner
	 *  
	 * @return le nombre maximum d'lments
	*/ 
	public int getMaxEntries() {
		return maxEntries;
	}

	/**
	 * Dans le cas d'un lien avec une table
	 * Dfninit le nombre maximum d'lments que LDAP doit retourner
	 * 
	 * @param maxEntries
	*/ 
	public void setMaxEntries(int _maxEntries) {
		maxEntries = _maxEntries;
	}

	/**
	 * Dans le cas d'un lien avec une table
	 * Retrourne le mode de recherche dans LDAP 
	 * 
	 * @return SearchControls.SUBTREE_SCOPE ou SearchControls.ONELEVEL_SCOPE
	 */
	public int getScope() {
		return scope;
	}

	/**
	 * Dans le cas d'un lien avec une table
	 * dfinit le mode de recherche dans LDAP 
	 * 
	 * @param scope
	 */
	public void setScope(String _scope) {
		if (_scope.equalsIgnoreCase("sub")) {
			scope = SearchControls.SUBTREE_SCOPE;
		} else {
			scope = SearchControls.ONELEVEL_SCOPE;
		}
	}

	/**
	 * Retourne le libell de l'identifiant (champ LDAP) d'un rsultat 
	 * 
	 * @return le libell
	 
	public String getIdentifiantLabel() {
		return identifiantLabel;
	}*/

	/**
	 * Dfinit le libell de l'identifiant (champ LDAP) d'un rsultat
	 * sert ajouter ce critre une fois arriv sur le mode fiche
	 * depuis le mode tableau
	 * 
	 * @param le libell
	 
	public void setIdentifiantLabel(String string) {
		identifiantLabel = string;
	}*/

} // end Query