/*

 ESUP-portail is a french academic project developed under the GPL (General Public License)
 augmented according to the following :

 A binary or source file developped by ESUP-portail can be used or compiled with products under Apache license.

 The official english text of the GPL can be found here : http://www.gnu.org/licenses/gpl.html .

 A non official french translation can be found here : http://www.linux-France.org/article/these/gpl.html .

 The different kinds of licenses governing the products developed by the Apache
 foundation can be found here : http://www.apache.org/licenses .

 It follows that you can as well as use download contents as well modify and redistribute
 them provided you respect the GPL terms.

 Downloading and using such contents do not provide any guaranty.

 Be sure that you have well understood the terms of the license before using the contents it covers.

 The ESUP-portail distribution includes the following distributions :

 * UPortal :
 software developed by JA-SIG (Java Architecture - Special Interest Group)
 You can find the license page here : http://mis105.udel.edu/ja-sig/uportal/license.html

 * CAS :
 SSO solution developed by Yale University
 You can find the project page here : http://www.yale.edu/tp/auth

 * Cocoon :
 XML framework distributed by the Apache foundation under Apache license;
 Please find the full text here : http://cocoon.apache.org/2.1/license.html

 * Mod_dav:
 A DAV module for Apache web server
 You can find the project page here : http://www.webdav.org/mod_dav

 * IMP :
 webmail from Horde application framework
 You can find the project page here : http://www.horde.org
 */

package org.esupportail.portal.channels.CAnnuaire.config.elemOfQuery;

import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;

import org.esupportail.portal.channels.CAnnuaire.userInterface;
import org.esupportail.portal.channels.CAnnuaire.config.config;
import org.esupportail.portal.channels.CAnnuaire.config.itemTable;
import org.esupportail.portal.channels.CAnnuaire.config.table.ATable;

public class ElmOfQuerySubTable extends AElmOfQuery {

	public boolean writable() {
		return true;
	}

	public Hashtable getCritere(String[] values) {

		if ((values == null) || (values.equals(""))) return null;


		ATable T = config.getTable(getTable());
		Hashtable nouvCritere = new Hashtable();
		nouvCritere.put("label",getVarI18n());
		nouvCritere.put("searchValues",values);
		String[] tmp = new String[1];
		if (values[1].equals("")){
			tmp[0] = "ALL_SUB_VALUES";
		}
		else{
			tmp[0] = ((itemTable)T.getItem(values[1])).getValue();
		}		
		nouvCritere.put("displayValues",tmp);

		return nouvCritere;
	}

	public String updateFilter(String[] _value, String urlServeur) {
		String filterTemp = filter.replaceAll("%cm", _value[0]);
		if (_value[1].equals("")){
			filterTemp = filterTemp.replaceAll("%cc", "*");
		}
		else{
			filterTemp = filterTemp.replaceAll("%cc", _value[1]);
		}			
		return filterTemp;
		/*return "";*/
	}

	public StringBuffer valuesToXml(Vector selectedValues) {
		
		StringBuffer xml = new StringBuffer();
		ATable table = config.getTable(getTable());
		ATable masterTable = config.getTable(table.getTableLink());
		Enumeration masterList = masterTable.getItems().keys();
		while (masterList.hasMoreElements()) {
			itemTable iT = (itemTable) masterTable.getItems().get((String) masterList.nextElement());
			xml.append("<MASTERFIELDVALUE code=\"").append(iT.getCode()).append("\" ");
			xml.append("value=\"").append(userInterface.valueToXml(iT.getValue())).append("\" ");
			xml.append("order=\"").append(userInterface.valueToXml(iT.getOrderValue())).append("\" ");
			xml.append("selected=\"").append(selectedValues.contains(iT.getCode())).append("\" ");
			xml.append(">\n");
			Enumeration liste = table.getItems(iT.getCode()).keys();
			while (liste.hasMoreElements()) {
				itemTable subIT = (itemTable) table.getItems().get((String) liste.nextElement());
				xml.append("<FIELDVALUE code=\"").append(subIT.getCode()).append("\" ");
				xml.append("value=\"").append(userInterface.valueToXml(subIT.getValue())).append("\" ");
				xml.append("order=\"").append(userInterface.valueToXml(subIT.getOrderValue())).append("\" ");
				xml.append("linked=\"").append(userInterface.valueToXml(subIT.getLinkedValue())).append("\" ");
				xml.append("selected=\"").append(selectedValues.contains(subIT.getCode())).append("\" ");
				xml.append("/>\n");
			}
			xml.append("</MASTERFIELDVALUE>\n");
		}
		
		return xml;
	}

} // end ElmOfQuery
