/*

ESUP-portail is a french academic project developed under the GPL (General Public License)
augmented according to the following :

A binary or source file developped by ESUP-portail can be used or compiled with products under Apache license.

The official english text of the GPL can be found here : http://www.gnu.org/licenses/gpl.html .

A non official french translation can be found here : http://www.linux-France.org/article/these/gpl.html .

The different kinds of licenses governing the products developed by the Apache
foundation can be found here : http://www.apache.org/licenses .

It follows that you can as well as use download contents as well modify and redistribute
them provided you respect the GPL terms.

Downloading and using such contents do not provide any guaranty.

Be sure that you have well understood the terms of the license before using the contents it covers.

The ESUP-portail distribution includes the following distributions :

* UPortal :
software developed by JA-SIG (Java Architecture - Special Interest Group)
You can find the license page here : http://mis105.udel.edu/ja-sig/uportal/license.html

* CAS :
SSO solution developed by Yale University
You can find the project page here : http://www.yale.edu/tp/auth

* Cocoon :
XML framework distributed by the Apache foundation under Apache license;
Please find the full text here : http://cocoon.apache.org/2.1/license.html

* Mod_dav:
A DAV module for Apache web server
You can find the project page here : http://www.webdav.org/mod_dav

* IMP :
webmail from Horde application framework
You can find the project page here : http://www.horde.org
*/
package org.esupportail.portal.channels.CAnnuaire.config.table;

import java.util.Hashtable;
import java.util.Iterator;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.esupportail.portal.channels.CAnnuaire.CAnnuaire;
import org.esupportail.portal.channels.CAnnuaire.config.itemTable;

public abstract class ATable {

    static protected final Log log = LogFactory.getLog(CAnnuaire.class);
    
    static protected final String tableFilePath = "/properties/channels/org_esup/CAnnuaire/xmlTables/";
	/**
	 * Represente le nom de la table
	 */
    protected String name;
	
	/**
	 * Represente le type de la table (LDAP, XML, statique)
	 */
	protected String type;
	
	
	protected String fieldLink;
	
	protected String tableLink;

	/**
	 * Represente la liste des items, indxe par le code
	 */
	private Hashtable listeItems;

	public ATable() {
		listeItems = new Hashtable();
	}

	/**
	 * Permet d'ajouter un lment  la table
	 * si on connait son code, sa valeur et son ordre
	 * si on ne connait son code, il est valu automatiquement
	 * 
	 * @param String code
	 * @param String value
	 * @param String ordreValue
	 */
	public void addItem(String code, String value) {
		addItem(code,value,null,null);
	}
	public void addItem(String code, String value, String ordreValue) {
		addItem(code,value,ordreValue,null);
	}
	public void addItem(String code, String value, String ordreValue, String linkedValue) {
		itemTable iT = new itemTable();
		
		if (code == null)
			code = "code" + listeItems.size();		
		iT.setCode(code);
		
		iT.setValue(value);
		
		if (ordreValue==null)
			ordreValue = "order"+listeItems.size();
		iT.setOrderValue(ordreValue);
		
		if (linkedValue!=null)
			iT.setLinkedValue(linkedValue);
		
		
		
		listeItems.put(code, iT);
	}

	/**
	 * Retourne les lments de la table
	 * 
	 * @return une Hashtable indxe sur le code des lments
	 */
	public Hashtable getItems() {
		return listeItems;
	}
	
	/**
	 * Retourne les lments de la table
	 * 
	 * @return une Hashtable indxe sur le code des lments
	 */
	public Hashtable getItems(String linkedValue) {
		Hashtable result = new Hashtable();
		Iterator liste = getItems().keySet().iterator();
		itemTable temp=null;
		while (liste.hasNext()) {
			temp = (itemTable)getItems().get((String)liste.next());
			if (temp.getLinkedValue().equalsIgnoreCase(linkedValue)){
				result.put(temp.getCode(),temp);
			}
		}
		
		return result;
	}

	/**
	 * Retourne l'lment de la table dont le code est pass en paramtre
	 * 
	 * @param code
	 * @return un itemTable
	 */
	public itemTable getItem(String code) {
		return (itemTable) listeItems.get(code);
	}

	

	/**
	 * Retourne le nom de la table
	 * 
	 * @return Le nom de la table
	 */
	public String getName() {
		return name;
	}

	/**
	 * Retourne le type le la table
	 * 
	 * @return Xml, Ldap, statique
	 */
	public String getType() {
		return type;
	}


	/**
	 * Dfinit le nom de la table
	 * 
	 * @param string
	 */
	public void setName(String string) {
		name = string;
	}


	/**
	 * Dfnit le type de la table (Xml, Ldap, statique)
	 * 
	 * @param string
	 */
	public void setType(String string) {
		type = string;
	}




	/**
	 * Lance la fonction de chargement des lments
	 * suivant le type de la table
	 *  
	 */
	 public abstract void loadItems();
	 

	
	/**
	 * Rcupre les codes des entres dont les valeurs correspondent  une saisie utilisateur
	 *  
	 */
	 public abstract Hashtable getValues(String searchValue, String[] saisie);

	 
	public String getFieldLink() {
		return fieldLink;
	}

	public void setFieldLink(String fieldLink) {
		this.fieldLink = fieldLink;
	}

	public String getTableLink(){
		return tableLink;
	}
	public void setTableLink(String mT){
		tableLink = mT;
	}
}
	
