/*

ESUP-portail is a french academic project developed under the GPL (General Public License)
augmented according to the following :

A binary or source file developped by ESUP-portail can be used or compiled with products under Apache license.

The official english text of the GPL can be found here : http://www.gnu.org/licenses/gpl.html .

A non official french translation can be found here : http://www.linux-France.org/article/these/gpl.html .

The different kinds of licenses governing the products developed by the Apache
foundation can be found here : http://www.apache.org/licenses .

It follows that you can as well as use download contents as well modify and redistribute
them provided you respect the GPL terms.

Downloading and using such contents do not provide any guaranty.

Be sure that you have well understood the terms of the license before using the contents it covers.

The ESUP-portail distribution includes the following distributions :

* UPortal :
software developed by JA-SIG (Java Architecture - Special Interest Group)
You can find the license page here : http://mis105.udel.edu/ja-sig/uportal/license.html

* CAS :
SSO solution developed by Yale University
You can find the project page here : http://www.yale.edu/tp/auth

* Cocoon :
XML framework distributed by the Apache foundation under Apache license;
Please find the full text here : http://cocoon.apache.org/2.1/license.html

* Mod_dav:
A DAV module for Apache web server
You can find the project page here : http://www.webdav.org/mod_dav

* IMP :
webmail from Horde application framework
You can find the project page here : http://www.horde.org
*/
package org.esupportail.portal.channels.CAnnuaire.config.table;

import java.io.IOException;
import java.net.URL;
import java.util.Hashtable;
import java.util.Iterator;

import org.apache.commons.digester.Digester;
import org.esupportail.portal.channels.CAnnuaire.config.itemTable;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class TableXML extends ATable {


	/**
	 * Si la table est du type XML : 
	 * indique le chemin vers le fichier qui contient la table
	 */
	private String file;


	/**
	 * Le nom du fichier utilis (dans le cas d'une table XML)
	 * 
	 * @return le nom du fichier
	 */
	public String getFile() {
		return file;
	}
	/**
	 * dans le cas d'une table XML
	 * Dfinit le fichier  utiliser pour charger les lments
	 * 
	 * @param string
	 */
	public void setFile(String string) {
		file = string;
	}
	
	/**
	 * fonction de chargement des lments pour une table de type xml
	 * 
	 */
	public void loadItems() {
		Digester digester = new Digester();
		digester.setValidating(false);
		digester.push(this);

		/*MONTAGE DES TABLES*/
		digester.addCallMethod("list/item", "addItem", 3);
		digester.addCallParam("list/item", 0, "code");
		digester.addCallParam("list/item", 1, "value");
		digester.addCallParam("list/item", 2, "fieldOrder");
		
		Class requestingClass = this.getClass();
		//Emplacement du fichier de config  parser  partir du rpertoire classes
		URL resourceURL = requestingClass.getResource(tableFilePath + file);
		
		if (resourceURL != null) {
		      
			//InputSource inSource = new InputSource(resourceURL.toExternalForm());
		
			try {
				digester.parse(new InputSource(resourceURL.toExternalForm()));
	
			} catch (IOException e) {
			    log.error("Table::loadItem() : ERREUR : Impossible d'ouvrir le fichier de config : "
			            + file
						+ "\n"
						+ e.toString());
			} catch (SAXException e) {
			    log.error("Table::loadItem() : ERREUR : SAXException :\n"
						+ e.toString());		   
			} catch (Exception e) {
			    log.error("Table::loadItem() : ERREUR : \n" + e.toString());
			}
		} else {
           log.error("Table::loadItemXml() : ERREUR : "
                   + file
                   + " n'existe pas.\n");
       }
	}
	

	public Hashtable getValues(String searchValue, String[] saisie) {
		Hashtable codes = new Hashtable();
		
		String search = searchValue.toLowerCase().replaceAll("%s", saisie[0]);
		search  = search.replaceAll("\\*", ".*");
		Iterator i = getItems().keySet().iterator();
		while (i.hasNext()){
			String key = (String) i.next();
			itemTable item = getItem(key);
			if (item.getValue().toLowerCase().matches(search)){
				codes.put(key,item.getValue());
			}
		}
		
		if (codes.size()==0)return null;
		
		return codes;
	}
}
