/*
    
 ESUP-portail is a french academic project developed under the GPL (General Public License)
 augmented according to the following :
 
 A binary or source file developped by ESUP-portail can be used or compiled with products under Apache license.
 
 The official english text of the GPL can be found here : http://www.gnu.org/licenses/gpl.html .
  
 A non official french translation can be found here : http://www.linux-France.org/article/these/gpl.html .
 
 The different kinds of licenses governing the products developed by the Apache
 foundation can be found here : http://www.apache.org/licenses .
 
 It follows that you can as well as use download contents as well modify and redistribute
 them provided you respect the GPL terms.
  
 Downloading and using such contents do not provide any guaranty.
 
 Be sure that you have well understood the terms of the license before using the contents it covers.
 
 The ESUP-portail distribution includes the following distributions :
 
 * UPortal :
 software developed by JA-SIG (Java Architecture - Special Interest Group)
 You can find the license page here : http://mis105.udel.edu/ja-sig/uportal/license.html
 
 * CAS :
 SSO solution developed by Yale University
 You can find the project page here : http://www.yale.edu/tp/auth
 
 * Cocoon :
 XML framework distributed by the Apache foundation under Apache license;
 Please find the full text here : http://cocoon.apache.org/2.1/license.html
 
 * Mod_dav:
 A DAV module for Apache web server
 You can find the project page here : http://www.webdav.org/mod_dav
 
 * IMP :
 webmail from Horde application framework
 You can find the project page here : http://www.horde.org
 */
package org.esupportail.portal.channels.CAnnuaire;


import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.Vector;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.esupportail.portal.channels.CAnnuaire.config.Line;
import org.esupportail.portal.channels.CAnnuaire.config.config;
import org.jasig.portal.ChannelCacheKey;
import org.jasig.portal.ChannelRuntimeData;
import org.jasig.portal.ChannelRuntimeProperties;
import org.jasig.portal.ChannelStaticData;
import org.jasig.portal.ICacheable;
import org.jasig.portal.IChannel;
import org.jasig.portal.IMimeResponse;
import org.jasig.portal.IServant;
import org.jasig.portal.PortalEvent;
import org.jasig.portal.PortalException;
import org.jasig.portal.UPFileSpec;
import org.jasig.portal.utils.XSLT;
import org.xml.sax.ContentHandler;

public class CAnnuaire implements IChannel, ICacheable, IMimeResponse {
	
	private static final Log log = LogFactory.getLog(CAnnuaire.class);
	
	
	/*************************/
	/*configuration variables*/
	/*************************/
	
	/*configuration file*/
	private final static String configFilePath =
		"/properties/channels/org_esup/CAnnuaire/CAnnuaire.xml";
	
	/*ssl*/
	private final static String xslLocation = "CAnnuaire.ssl";
	
	/*channel cache*/
	private int cacheTimeOut = 86400;//24 heures
	
	/*mailto channel class*/
	public final static String mailToClass =
		"org.esupportail.portal.channels.CMailTo.CMailToServant";

	/********************/
	/*programm variables*/
	/********************/
	
	/*channel's states*/
	private final String STATE_FORM = "Formulaire";
	private final String STATE_RESULT = "afficheResult";
	private final String STATE_DETAIL = "Detail";
	private final String MAIL_STATE = "sendMail";
	
	private String state = null;
	private boolean arrivedByTab = false;
	private boolean connectionError = false;
	private Locale lang = null;
	private Locale lastLang = null;
	private ResourceBundle languageFile=null;
	
	/*interface utilisateur*/
	protected userInterface UI;
	
	protected ChannelStaticData staticData = null;
	protected ChannelRuntimeData runtimeData = null;
	private boolean formWellFilled = true;
	
	
	/*Servant MailTo*/
	private IServant servant;
	
	private final static String toField ="to";//Mail.TO : pour viter la dpendence on n'utilise pas la constante
	
	/*Direct call*/
	private String detailPers = null;
	private String detailAnnuary = null;
	
	//Constructeur
	public CAnnuaire() {
		state = STATE_FORM;
		
		config.getInstance(configFilePath);
		
		UI = new userInterface();
	}
	
	
	
	public ChannelRuntimeProperties getRuntimeProperties() {
		return new ChannelRuntimeProperties();
	}
	
	/** Processes layout-level events coming from the portal
	 * @param ev a portal layout event
	 */
	public void receiveEvent(PortalEvent ev) {
	}
	
	/** Receive static channel data from the portal
	 * @param sd static channel data
	 */
	public void setStaticData(ChannelStaticData sd) {
		this.staticData = sd;
		
		/*Instanciation parameters*/
		String serveurAuthorise = sd.getParameter("serverView");
		if ((serveurAuthorise == null) || (serveurAuthorise == ""))
			serveurAuthorise = "*";

		connectionError = !UI.setServerView(serveurAuthorise);
		
		UI.setGuestMode(staticData.getPerson().isGuest());
		UI.setServantActive((staticData.getParameter("CAnnuaireServantMode")!=null));
		lastLang = Locale.getDefault();
	}
	
	
	
	/** Receives channel runtime data from the portal and processes actions
	 * passed to it.  The names of these parameters are entirely up to the channel.
	 * @param rd handle to channel runtime data
	 * @throws PortalException
	 */
	public void setRuntimeData(ChannelRuntimeData rd) throws PortalException {
		this.runtimeData = rd;
		
		/*get the language*/
		try {
			Locale[] langs = runtimeData.getLocales();			
			if (langs!=null){
				lang = langs[0];
			}
			languageFile = ResourceBundle.getBundle("/org/esupportail/portal/channels/CAnnuaire/languages/CAnnuaire",lang);
			lastLang = lang;			
			
		} catch (Exception e) {
			lang = lastLang;
			languageFile = ResourceBundle.getBundle("/org/esupportail/portal/channels/CAnnuaire/languages/CAnnuaire",lang);
		}
		
		UI.setLang(lang.toString());
		
		
		if (rd.getParameter("state")!=null)
			state = rd.getParameter("state"); 

		String mailAddress = "";
		
		if (!connectionError){
			if ( ( (state.equals(STATE_RESULT)) || (state.equals(STATE_DETAIL) ) )
				&&(runtimeData.getParameter("action")!=null)
				&&(runtimeData.getParameter("action").equals("sendMail"))
				){
				
				if (log.isDebugEnabled()){
					log.debug("CAnnuaire::setRuntimeData : prepare envoi de mail ... ");
				}

				String id = rd.getParameter("id");
				Personne p = UI.getResult(id);
				if (p!=null){
					mailAddress = new String();
					String attrib = rd.getParameter("attrib");
					Line line = config.getLineContainsAttribute(UI.getServerWork(),attrib);
					if (line!=null){
						if (line.getLinkType().equals(Line.LINE_LINK_TYPE_MAIL)){
							state = MAIL_STATE;
							Vector values = (Vector)p.getAttribute(attrib);
							mailAddress = (String)values.get(0);
							if (log.isDebugEnabled()){
								log.debug("CAnnuaire::setRuntimeData : adresse="+mailAddress);
							}
						}
						else{
							log.error("CAnnuaire::setRuntimeData : l'attribut "+attrib+", n'est pas un champ mail. Il est donc impossible d'envoyer un mail.");
						}
					}
					else{
						log.error("CAnnuaire::setRuntimeData : '"+id+"' n'a pas d'attribut "+attrib+", il est donc impossible de lui envoyer un mail.");
					}
				}
				else{
					log.error("CAnnuaire::setRuntimeData : impossible de trouver '"+id+"' dans les rsultats de la recherche pour lui envoyer un mail.");
				}
			} 
			
			if (state.equals(MAIL_STATE)){	

				String[] att = new String[3];
		        att[0] = mailAddress;
		        att[1] = "false";
		        att[2] = "true";
		        runtimeData.setParameterValues(toField,att);
			    
			    
			    try {
	
					if (log.isDebugEnabled()){
						log.debug("CAnnuaire::setRuntimeData : appel du servant");
					}
	                Class servantClass = Class.forName(mailToClass);
	                // Instanciation du servant
	                Object servantObj = servantClass.newInstance();
	                servant = (IServant)servantObj;
	            } catch (ClassNotFoundException e) {
	                log.error("CAnnuaire::setRuntimeData:ClassNotFoundException : ",e);
	                state=STATE_RESULT;//servantAvailable = false;
	            } catch (InstantiationException e) {
	            	log.error("CAnnuaire::setRuntimeData:InstantiationException : ",e);
	            	state=STATE_RESULT;//servantAvailable = false;
	            } catch (IllegalAccessException e) {
	            	log.error("CAnnuaire::setRuntimeData:IllegalAccessException : ",e);
	            	state=STATE_RESULT;//servantAvailable = false;
	            } catch (Exception e) {
	            	log.error("CAnnuaire::setRuntimeData:Exception : "+e.getMessage());
	            	state=STATE_RESULT;//servantAvailable = false;
	            }
	
	            //Passage des paramtres
	            servant.setStaticData(staticData);
	            servant.setRuntimeData(runtimeData);
	            
	            if (servant.isFinished()) {
	            	state=STATE_RESULT;//
	    			rd.setParameter("backToList","true");
	                mailAddress = "";
	            }		    
			}
			else{
				boolean isAction = false;
				
				if (runtimeData.getParameter("updateQuery")!=null){
					state = STATE_FORM;
					isAction = true;
					arrivedByTab = false;
				}
				else if (runtimeData.getParameter("backToList")!=null){
					state=STATE_RESULT;
					UI.addIdToFilter("");
					isAction = true;
				}
				else if (runtimeData.getParameter("id")!=null) {
					state=STATE_DETAIL;
					UI.addIdToFilter(runtimeData.getParameter("id"));
					isAction = true;
				}
				else if ((runtimeData.getParameter("lanceRecherche")!=null)&&(!runtimeData.getParameter("lanceRecherche").equals(""))) {
					state=STATE_RESULT;
					isAction = true;
				}
				else if (runtimeData.getParameter("action")!=null){
					if (runtimeData.getParameter("action").equals("exportList")){
						isAction = true;
					}
				}
						
				/*Appel en mode fiche*/
				if (rd.getParameter("uP_fname")!=null){
					detailPers = runtimeData.getParameter("id");
					detailAnnuary = runtimeData.getParameter("annuaire");	
					connectionError = !UI.setServerWork(detailAnnuary);	
				}
				
				if (!isAction){
					state = STATE_FORM;
					UI.cleanCritere();
					arrivedByTab = false;
					if (runtimeData.getParameter("annuaire")!=null)
						connectionError = !UI.setServerWork(runtimeData.getParameter("annuaire"));
				}
			}
	
			
			if (log.isDebugEnabled()){
				log.debug("CAnnuaire::setRuntimeData : state="+state);
			}
		}
	}
	
	/** Output channel content to the portal
	 * @param out a sax document handler
	 */
	public void renderXML(ContentHandler out) throws PortalException {
		
		
		if (state.equals(MAIL_STATE)) {
			servant.renderXML(out);
		}
        else{
        	myRenderXML(out);
        }
	}
		
	private  void myRenderXML(ContentHandler out) throws PortalException {	
		int nbRes = 0;
		
		StringBuffer xml = new StringBuffer();
		xml.append("<?xml version=\"1.0\" encoding=\"UTF-8\" ?>\n<RACINE>\n");
		
		if (UI.getServerWork()==null) {
			xml.append("<ALERT>ERROR_FORM_NONE_SERVER_FOUND</ALERT>\n");
			connectionError = true;
		}
		
		if (!connectionError) {
			if (state.equals(STATE_FORM)) {
				xml.append(UI.getForm()); 
			} else {
						
				if ( (state.equals(STATE_RESULT)) 
					&& (runtimeData.getParameter("backToList")==null)
					){
					formWellFilled = UI.updateFilter(runtimeData);
				}
				
				if (!formWellFilled) {
					xml.append("<ALERT>WARN_FORM_NOT_FILLED</ALERT>\n");
					state = STATE_FORM;
					xml.append(UI.getForm());
				} else {
					xml.append(UI.getResultXml());
					if (log.isDebugEnabled()){
						log.debug("CAnnuaire::myRenderXML : filtre de recherche ="+UI.getFiltreComplet());
					}
				}
			}
		} else {
			xml.append("<ALERT>WARN_SERVER_NOT_FOUND</ALERT>\n");
			state = STATE_FORM;
		}
		xml.append("</RACINE>\n");
		
		/*traitement de la chaine XML*/
		XSLT xslt = new XSLT(this);
		xslt.setXML(xml.toString());

		
		/*Affectation de la feuille XSL en fonction du nombre de rsultat*/
		String feuille = new String();
		if (state.equals(STATE_FORM)) {
			feuille = "form";
		} else {
			xslt.setStylesheetParameter("sortOrder",config.getServer(UI.getServerWork()).getDisplay().getSortOrder());
			nbRes = UI.getNbReponse();
			
			if (nbRes == 0) {
				feuille = "vide";
			} else if ((nbRes > 0)&& (nbRes<= config.getServer(UI.getServerWork()).getDisplay().getMaxCard())) {
				feuille = "fiche";
				state=STATE_DETAIL;
			} else if ((nbRes > config.getServer(UI.getServerWork()).getDisplay().getMaxCard())) {
				feuille = "tabRes";
				arrivedByTab = true;
			}
			
		}
		if (log.isDebugEnabled()){
			log.debug("CAnnuaire::myRenderXML : Nombre de rsultat ="+nbRes);
			log.debug("CAnnuaire::myRenderXML : feuille xsl ="+feuille);
		}
		
		
		try {
			xslt.setXSL(xslLocation, feuille, runtimeData.getBrowserInfo());
		} catch (PortalException e) {
			log.error("CAnnuaire::renderXml() : " + e.toString());
		}
		
		//on prfixe avec pref pour tre sr que l'id ne commence pas par un chiffre et que a ne fasse pas planter le javascript
		String nameForm = "annuary"+staticData.getChannelSubscribeId();
		// pour viter les erreurs javascript lorsque l'utilisation des fragments donne des channelSubscribeId avec des "-"
		nameForm = nameForm.replaceAll("-","_");
		/*Envoie des paramtres au fichierXSL*/
		xslt.setStylesheetParameter("nameForm",nameForm);	
		xslt.setStylesheetParameter("baseActionURL",runtimeData.getBaseActionURL());		
		xslt.setStylesheetParameter("baseDownloadURL",runtimeData.getBaseWorkerURL(UPFileSpec.FILE_DOWNLOAD_WORKER, true).replaceAll("%2F", "/"));
		
		if (UI.getServerWork()!=null){
			xslt.setStylesheetParameter("annuSelect", UI.getServerWork());
			if (config.getServer(UI.getServerWork()).isAllowExport())
				xslt.setStylesheetParameter("allowExport","true");
		}
		
		String rtt = new String();
		if ( (arrivedByTab) && (state.equals(STATE_DETAIL)) )rtt="true"; else rtt="false";
		xslt.setStylesheetParameter("returnToTab", rtt);
		
		String displayHeader = new String();
		if ( detailPers!=null )displayHeader="false"; else displayHeader="true";
		xslt.setStylesheetParameter("displayHeader", displayHeader);
		
		
		if (this.staticData.getParameter("CAnnuaireServantMode") != null) {
			if (this.staticData.getParameter("returnServant")==null)
					this.staticData.put("returnServant","single");
			if (this.staticData.getParameter("returnServant").equals("single"))
				xslt.setStylesheetParameter("modeServant", "single");
			else
				xslt.setStylesheetParameter("modeServant", "multiple");
		}

		xslt.setResourceBundle(languageFile);
		
		
		
		xslt.setTarget(out);
		try {
			xslt.transform();
		} catch (PortalException e) {
			log.error("CAnnuaire::myRenderXML() : Une erreur est survenue lors du parsing XML/XSL : ",e);
			XSLT xsltError = new XSLT(this);
			xml.delete(0,xml.toString().length());
			xml.append("<?xml version=\"1.0\" encoding=\"UTF-8\" ?>\n<RACINE>\n");
			xml.append("<ALERT>ERROR_WHILE_PARSING</ALERT>\n");
			xml.append("</RACINE>\n");
			xsltError.setXML(xml.toString());
			xsltError.setResourceBundle(languageFile);
			xsltError.setTarget(out);
			try {
				xsltError.setXSL(xslLocation, "form", runtimeData.getBrowserInfo());
			} catch (PortalException f) {
				log.error("CAnnuaire::renderXml() : " + f.toString());
			}
			try {
				xsltError.transform();
			} catch (PortalException f) {
				log.error("CAnnuaire::myRenderXML() : L'affichage de l'erreur a chou : ",f);
			}
		}
		
	}
	
	/******************************************************************************/
	/**
     * Requests the channel to generate a key uniqly describing it's current state,
     * and a description of key usage.
     */
    public ChannelCacheKey generateKey() {
		
		if (!state.equals(STATE_FORM))  return null;
		
		if (!formWellFilled)  return null;
		
		if (runtimeData.getParameter("updateQuery")!=null)return null;
		
		StringBuffer sbKey = new StringBuffer(1024);
		sbKey.append(this.getClass().getName() + " : ");
		sbKey.append("language:").append(lang).append(", ");
		sbKey.append("serverview:").append(UI.getServerView()).append(", ");
		sbKey.append("serverwork:").append(UI.getServerWork());
		
		ChannelCacheKey k = new ChannelCacheKey();
		
		k.setKeyScope(ChannelCacheKey.INSTANCE_KEY_SCOPE);

		if (log.isDebugEnabled()){
			log.debug("CAnnuaire::generateKey : sbKey="+sbKey);
		}
		
		k.setKey(sbKey.toString());
		k.setKeyValidity(new Long(System.currentTimeMillis()));
		return k;
	}
	
    /**
     * Requests the channel to verify validity of the retreived cache based on the validator object.
     */
    public boolean isCacheValid(Object validity) {
		
		if (!state.equals(STATE_FORM)) return false;
		
		if (runtimeData.getParameter("updateQuery")!=null)return false;
			
		boolean cacheValid = false;
		
		if (validity instanceof Long) {
			Long oldtime = (Long) validity;
			// Si validity  moins de cacheTimeOut secondes le cache est valide
			if (System.currentTimeMillis() - oldtime.longValue()
					< cacheTimeOut * 1000) {
				cacheValid = true;
			}
		}
		if (log.isDebugEnabled()){
			log.debug("CAnnuaire::isCacheValid : "+cacheValid);
		}
		return cacheValid;
	}
	/********************************************************/

	
    /**
     * Returns the MIME type of the content.
     */
    public String getContentType() {
		return "application/octet-stream";
	}

    /**
     * Returns the MIME content in the form of an input stream.
     * Returns null if the code needs the OutputStream object
     */
    public InputStream getInputStream() throws IOException {
		return null; 
	}

    /**
     * Pass the OutputStream object to the download code if it needs special handling
     * (like outputting a Zip file).
     */
    public void downloadData(OutputStream out) throws IOException {
		StringBuffer csv = new StringBuffer();
		csv.append(UI.getResultCsv());
		out.write(csv.toString().getBytes());
		out.close();
	}
	
    /**
     * Returns the name of the MIME file.
     */
    public String getName() {
		return "export_"+UI.getServerWork()+".csv"; 
	}

    /**
     * Returns a list of header values that can be set in the HttpResponse.
     * Returns null if no headers need to be set.
     */
    public Map getHeaders() {
			HashMap map = new HashMap(); 
          map.put("Content-disposition", "attachment; filename=" + getName()); 
          return map;

	}

    /**
     * Let the channel know that there were problems with the download
     *
     * @param e
     */
    public void reportDownloadError(Exception e) {
		log.error("ListeCSV::reportingDownloadError() : " + e);
		
	}
}
