package org.esupportail.portal.channels.CAnnuaire.LDAP.Exceptions;
 
/** 
 * <p>Titre : FrameWorkException</p>
 * <p>Description : Classe de gestion des erreurs du framework</p>
 * <p>Copyright : Copyright (c) <a href="www.esup-portail.org">ESup-Portail 2004</a></p>
 * <p>Socit : N2</p>
 * @author <a href="mailto:cedric.champmartin@univ-nancy2.fr">Cdric Champmartin</a>
 * @version 1.0
 */
public class LDAPException extends Exception {

	/**
	 * 
	 */
	private static final long serialVersionUID = 3814875924497144559L;
	// message d'erreur affich dans la channel ( destination de l'utilisateur)	
	private String displayMessage;
	// message d'erreur insr dans le mail ( destination du dveloppeur)
	private String message;
	// message par dfaut fourni  l'utilisateur
	private String msgDefault = "Une erreur est survenue dans l'excution du canal. Veuillez ressayer ultrieurement.";
	
	

	/**
	* Constructeur 
	* 
	*/
	public LDAPException (String displayMessage) {
		setDisplayMessage(displayMessage);
	}

	/**
	* Constructeur 
	* 
	*/
	public LDAPException () {
		setDisplayMessage(msgDefault);
	}		
		
	/**
	 * @return
	 */
	public String getDisplayMessage() {
		return displayMessage;
	}

	/**
	 * @param string
	 */
	public void setDisplayMessage(String string) {
		displayMessage = string;
	}

	/**
	 * @return
	 */
	public String getMessage() {
		return message;
	}

	/**
	 * @param string
	 */
	public void setMessage(String string) {
		message = string;
	}

	/**
	 * @return
	 */
	public String getMsgDefault() {
		return msgDefault;
	}

	/**
	 * @param string
	 */
	public void setMsgDefault(String string) {
		msgDefault = string;
	}

}
