/*

ESUP-portail is a french academic project developed under the GPL (General Public License)
augmented according to the following :

A binary or source file developped by ESUP-portail can be used or compiled with products under Apache license.

The official english text of the GPL can be found here : http://www.gnu.org/licenses/gpl.html .

A non official french translation can be found here : http://www.linux-France.org/article/these/gpl.html .

The different kinds of licenses governing the products developed by the Apache
foundation can be found here : http://www.apache.org/licenses .

It follows that you can as well as use download contents as well modify and redistribute
them provided you respect the GPL terms.

Downloading and using such contents do not provide any guaranty.

Be sure that you have well understood the terms of the license before using the contents it covers.

The ESUP-portail distribution includes the following distributions :

* UPortal :
software developed by JA-SIG (Java Architecture - Special Interest Group)
You can find the license page here : http://mis105.udel.edu/ja-sig/uportal/license.html

* CAS :
SSO solution developed by Yale University
You can find the project page here : http://www.yale.edu/tp/auth

* Cocoon :
XML framework distributed by the Apache foundation under Apache license;
Please find the full text here : http://cocoon.apache.org/2.1/license.html

* Mod_dav:
A DAV module for Apache web server
You can find the project page here : http://www.webdav.org/mod_dav

* IMP :
webmail from Horde application framework
You can find the project page here : http://www.horde.org
*/
package org.esupportail.portal.channels.CAnnuaire.config;

import java.util.Vector;

import javax.naming.NamingEnumeration;

public class AttributeLine  implements Cloneable{
	
	public static final String ATTRIBUTE_LINE_TYPE_DIRECT = "direct";
	public static final String ATTRIBUTE_LINE_TYPE_TABLE = "table";
	
	/**
	 * Represente le nom de la variable de texte pr l'internationnalisation
	 */
	private String varI18n;

	/**
	 * Represente le type de donne  afficher (rsultat d'une liste, champ direct, ...)
	 */
	private String type;

	/**
	 * Represente le nom de l'attribut ldap a afficher
	 */
	private String attribute;


	/**
	 * Represente le nom de la table monte en config si la valeur doit prevenir d'une table
	 */
	private String linktable;

	/**
	 * Represente les valeurs  afficher pour cet attribut
	 */
	private Vector values;
	/**
	 * Represente les valeurs rcupres pour cet attribut
	 */
	private Vector realValues;
	
	
	public AttributeLine copy() throws CloneNotSupportedException{
		return (AttributeLine)super.clone ();
	}
	
	


	/**
	 * @return l'attribut ldap correspondant  l'objet
	 */
	public String getAttribute() {
		return attribute;
	} // end getAttribute

	/**
	 * @param string
	 */
	public void setAttribute(String string) {
		attribute = string;
	} // end setAttribute

	/**
	 * Retourne le type de donne  afficher (rsultat d'une liste, champ direct, ...)
	 *
	 * @return le type
	 */
	public String getType() {
		return type;
	} // end getType

	/**
	 * Dfinit le type de donne  afficher (rsultat d'une liste, champ direct, ...)
	 *
	 * @param le type
	 */
	public void setType(String value) {
		type = value;
	} // end setType

	/**
	 * Retourne le nom de la table lie	 *
	 *
	 *
	 * @return le nom de la table 
	 */
	public String getLinktable() {
		return linktable;
	} // end getLinktable

	/**
	 * Dfinit le nom de la table lie	 *
	 *
	 * @param le nom de la table
	 */
	public void setLinktable(String __linktable) {
		linktable = __linktable;
	} // end setLinktable

	/** 
	 * @return toutes les valeurs de cet attribut
	 */
	public Vector getValues() {
		return values;
	}

	/**
	 * @param value
	 */
	public void setValues(NamingEnumeration value) {
		if (value != null) {
			if (values == null)
				values = new Vector();
			while (value.hasMoreElements()) {
				values.add(value.nextElement());
			}
		}
	}



	/**
	 * @return Renvoie var18In.
	 */
	public String getVarI18n() {
		return varI18n;
	}
	/**
	 * @param var18In var18In  dfinir.
	 */
	public void setVarI18n(String var18In) {
		this.varI18n = var18In;
	}





	public Vector getRealValues() {
		return realValues;
	}




	public void setRealValues(NamingEnumeration savValues) {
		if (savValues != null) {
			if (realValues == null)
				realValues = new Vector();
			while (savValues.hasMoreElements()) {
				realValues.add(savValues.nextElement());
			}
		}
	}
} // end Line
