/*

ESUP-portail is a french academic project developed under the GPL (General Public License)
augmented according to the following :

A binary or source file developped by ESUP-portail can be used or compiled with products under Apache license.

The official english text of the GPL can be found here : http://www.gnu.org/licenses/gpl.html .

A non official french translation can be found here : http://www.linux-France.org/article/these/gpl.html .

The different kinds of licenses governing the products developed by the Apache
foundation can be found here : http://www.apache.org/licenses .

It follows that you can as well as use download contents as well modify and redistribute
them provided you respect the GPL terms.

Downloading and using such contents do not provide any guaranty.

Be sure that you have well understood the terms of the license before using the contents it covers.

The ESUP-portail distribution includes the following distributions :

* UPortal :
software developed by JA-SIG (Java Architecture - Special Interest Group)
You can find the license page here : http://mis105.udel.edu/ja-sig/uportal/license.html

* CAS :
SSO solution developed by Yale University
You can find the project page here : http://www.yale.edu/tp/auth

* Cocoon :
XML framework distributed by the Apache foundation under Apache license;
Please find the full text here : http://cocoon.apache.org/2.1/license.html

* Mod_dav:
A DAV module for Apache web server
You can find the project page here : http://www.webdav.org/mod_dav

* IMP :
webmail from Horde application framework
You can find the project page here : http://www.horde.org
*/
package org.esupportail.portal.channels.CAnnuaire.config;


import java.util.Hashtable;

import org.apache.commons.digester.AbstractObjectCreationFactory;
import org.esupportail.portal.channels.CAnnuaire.config.table.TableLDAP;
import org.esupportail.portal.channels.CAnnuaire.config.table.TableLocal;
import org.esupportail.portal.channels.CAnnuaire.config.table.TableSQL;
import org.esupportail.portal.channels.CAnnuaire.config.table.TableXML;
import org.xml.sax.Attributes;

public class FTable extends AbstractObjectCreationFactory {

	private Hashtable argsList = null;
	
	/**
	 * Cr une liste qui associe un nom d'attribut avec la place qu'il a dans la liste des arguments en paramtre
	 * @param arg0
	 */
	private void initListArg(Attributes arg0){
		argsList = new Hashtable();
		for (int i=0;i<arg0.getLength();i++){
			argsList.put(arg0.getQName(i).toLowerCase(), new Integer(i));
		}
	}
	
	/**
	 * Retourne la valeur de l'attribut pass en paramtre (si le paramtre n'existe pas, "" est renvoy)
	 * @param arg0
	 * @param nameArg
	 * @return
	 */
	private String getValueArg(Attributes arg0,String nameArg){
		String value = "";
		if (argsList.get(nameArg)!=null){
			value = arg0.getValue(((Integer)argsList.get(nameArg)).intValue());
		}
		return value;
	}
	
	public Object createObject(Attributes arg0) throws Exception {
		initListArg(arg0);
		
		
		if (getValueArg(arg0,"type").equals("ldap")){
			TableLDAP t = new TableLDAP();
			t.setName(getValueArg(arg0,"name"));
			t.setBase(getValueArg(arg0,"base"));
			t.setBinddn(getValueArg(arg0,"binddn"));
			t.setBindpass(getValueArg(arg0,"bindpass"));
			t.setScope(getValueArg(arg0,"scope"));
			t.setUrl(getValueArg(arg0,"url"));
			t.setFilter(getValueArg(arg0,"filter"));
			t.setType(getValueArg(arg0,"type"));
			t.setAttrCode(getValueArg(arg0,"attrcode"));
			t.setAttrValue(getValueArg(arg0,"attrvalue"));
			t.setFieldOrder(getValueArg(arg0,"fieldorder"));
			return t;
		}
		else if (getValueArg(arg0,"type").equals("local")){
			TableLocal t = new TableLocal();
			t.setName(getValueArg(arg0,"name"));
			t.setType(getValueArg(arg0,"type"));
			return t;
		}
		else if (getValueArg(arg0,"type").equals("xml")){
			TableXML t = new TableXML();
			t.setName(getValueArg(arg0,"name"));
			t.setType(getValueArg(arg0,"type"));
			t.setFile(getValueArg(arg0,"file"));
			return t;
		}
		else if (getValueArg(arg0,"type").equals("sql")){
			TableSQL t = new TableSQL();
			t.setName(getValueArg(arg0,"name"));
			t.setBinddn(getValueArg(arg0,"binddn"));
			t.setBindpass(getValueArg(arg0,"bindpass"));
			t.setUrl(getValueArg(arg0,"url"));
			t.setDriverClassName(getValueArg(arg0,"driverClassName"));
			t.setBddType(getValueArg(arg0,"bddType"));
			t.setAttrcode(getValueArg(arg0,"attrcode"));
			t.setAttrvalue(getValueArg(arg0,"attrvalue"));
			t.setFieldorder(getValueArg(arg0,"fieldorder"));
			t.setTableName(getValueArg(arg0,"tableName"));
			t.setFilter(getValueArg(arg0,"filter"));
			return t;
		}
		
		return null;
	}

	
	
	
}
