/*

ESUP-portail is a french academic project developed under the GPL (General Public License)
augmented according to the following :

A binary or source file developped by ESUP-portail can be used or compiled with products under Apache license.

The official english text of the GPL can be found here : http://www.gnu.org/licenses/gpl.html .

A non official french translation can be found here : http://www.linux-France.org/article/these/gpl.html .

The different kinds of licenses governing the products developed by the Apache
foundation can be found here : http://www.apache.org/licenses .

It follows that you can as well as use download contents as well modify and redistribute
them provided you respect the GPL terms.

Downloading and using such contents do not provide any guaranty.

Be sure that you have well understood the terms of the license before using the contents it covers.

The ESUP-portail distribution includes the following distributions :

* UPortal :
software developed by JA-SIG (Java Architecture - Special Interest Group)
You can find the license page here : http://mis105.udel.edu/ja-sig/uportal/license.html

* CAS :
SSO solution developed by Yale University
You can find the project page here : http://www.yale.edu/tp/auth

* Cocoon :
XML framework distributed by the Apache foundation under Apache license;
Please find the full text here : http://cocoon.apache.org/2.1/license.html

* Mod_dav:
A DAV module for Apache web server
You can find the project page here : http://www.webdav.org/mod_dav

* IMP :
webmail from Horde application framework
You can find the project page here : http://www.horde.org
*/
package org.esupportail.portal.channels.CAnnuaire.config;

import org.esupportail.portal.channels.CAnnuaire.userInterface;

public class Server {

	/**
	* Represente le nom du seveur
	*/
	private String name;

	/**
	* Represente le label du serveur
	*/
	private String title;

	/**
	* Represente l'adresse d'une application extrieure
	*/
	private String link;

	/**
	 * Represente l'adresse du serveur LDAP
	 */
	private String url;

	/**
	 * Represente le Dn de la connection
	 */
	private String bindDn;

	/**
	 * Represente le mot de passe de la connection de la connection
	 */
	private String bindPass;

	/**
	 * Represente le mot de passe de la connection de la connection
	 */
	private String intro;

	/**
	 * Represente la requete  executer
	 */
	private Query query;

	/**
	 * Represente les champs  rcuprer et  afficher
	 */
	private Display display;

	/**
	 * Represente les champs  rcuprer et  afficher
	 */
	private boolean allowExport;
	

	/**
	 * Retourne le nom du serveur
	 *
	 *
	 * @return Le nom (la cl) du serveur
	 */
	public String getName() {
		return name;
	} 

	/**
	 * Dfinit le nom du serveur
	 *
	 *
	 * @param  _name
	 */
	public void setName(String _name) {
		name = _name;
	} // end setBndDn

	/**
	 * Retourne si on autorise l'exportation de donnes
	 *
	 *
	 * @return true si l'export est autoris
	 */
	public boolean isAllowExport() {
		return allowExport;
	} 
	/**
	 * Dfinit si on autorise l'exportation de donnes
	 *
	 *
	 * @param  bool*/
	public void setAllowExport(boolean bool) {
		 allowExport=bool;
	} 

	/**
	 *
	 * @return le libell du serveur
	 */
	public String getTitle() {
		return title;
	} 

	/**
	 * Dfinit le titre du serveur
	 *
	 *
	 * @param _title
	 */
	public void setTitle(String _title) {
		title = _title;
	} 

	/**
	 * @return le lien vers une application externe
	 */
	public String getLink() {
		return link;
	} 

	/**
	 * Dfinit le lien vers une application externe
	 *
	 * @param _link
	 */
	public void setLink(String _link) {
		link = _link;
	} 

	/**
	 *
	 * @return l'url du serveur
	 */
	public String getUrl() {
		return url;
	} 

	/**
	 * Dfinit l'url du serveur
	 *
	 *
	 * @param _url
	 */
	public void setUrl(String _url) {
		url = _url;
	} 


	/**
	 * Dfinit le dn pour la connection au serveur
	 *
	 *
	 * @param _bindDn
	 */
	public void setBinddn(String _bindDn) {
		bindDn = _bindDn;
	} //end setBindPass
	/**
	 * Dfinit le mot de passe pour la connection au serveur
	 *
	 *
	 * @param _bindPass
	 */
	public void setBindpass(String _bindPass) {
		bindPass = _bindPass;
	} //end setBindPass
	/**
	 *
	 * @return le dn pour la connection au serveur
	 */
	public String getBinddn() {
		return bindDn ;
	} //end setBindPass
	/**
	 *
	 * @return le mot de passe pour la connection au serveur
	 */
	public String getBindpass() {
		return bindPass;
	} //end setBindPass


	/**
	 * 
	 * @return l'objet Display, qui contient tous les lments  afficher dans le rsultat de la recherche
	 */
	public Display getDisplay() {
		return display;
	} // end getDisplay

	/**
	 * Sauvegarde l'objet Display, qui contient tous les lments  afficher 
	 * dans le rsultat de la recherche
	 *
	 * @param _display
	 */
	public void setDisplay(Display _display) {
		display = _display;
	} // end setDisplay

	/**
	 * Retourne l'objet Query, qui contient tous les lments  afficher dans le formulaire de recherche
	 *
	 *
	 * @return un Query 
	 */
	public Query getQuery() {
		return query;
	} // end getQuery

	/**
	 * Sauvegarde l'objet Query, qui contient tous les lments  afficher 
	 * dans le formulaire de recherche
	 *
	 *
	 * @param _query
	 */
	public void setQuery(Query _query) {
		query = _query;
	} // end set

	/**
	 * Retourne la phrase d'introduction sur le formulaire
	 * 
	 * @return la phrase 
	 */
	public String getIntro() {
		return intro;
	}

	/**
	 * Dfinit la phrase d'introduction sur le formulaire
	 * 
	 * @param string
	 */
	public void setIntro(String string) {
		intro = string;
	}

	
	
	public String toXml(String lang){
		StringBuffer xml = new StringBuffer("");
		xml.append("<SERVER ");
		xml.append("name=\"" + userInterface.valueToXml(getName()) + "\" ");
		xml.append("intro=\"" + userInterface.valueToXml(getIntro(),lang) + "\" ");
		xml.append("label=\"" + userInterface.valueToXml(getTitle(),lang) + "\" ");
		xml.append("/>\n");
		return (xml.toString());
	}
	
	
} // end Server
