package org.esupportail.portal.channels.CAnnuaire.config.custom;

import org.esupportail.portal.channels.CAnnuaire.config.Line;

public abstract class ACustomMail {
	
	protected Line line = null;
	
	protected static final int LINK_MAIL_TO = 0;
	protected static final int CHANNEL_MAIL_TO = 1;
	
	protected static boolean mailToChannelIsDeployed=true;
	

	public ACustomMail(){
		
	}
	
	public void setLine(Line l){
		line = l;
	}
	
	public void setMailToChannelIsDeployed(boolean deployed){
		mailToChannelIsDeployed = deployed;
	}
	
	public String getUrl(boolean servantActive, boolean guestMode, String attributeName, String idPeople, String mailAddress){
		String link = null;
		if (!mailToChannelIsDeployed){
			link = getUrlMailToLink(servantActive,guestMode,mailAddress);
		}
		else{
			int linkType = getUrlChoose(servantActive,guestMode,attributeName,idPeople,mailAddress);
			if (linkType==CHANNEL_MAIL_TO){
				link = getUrlMailToChannel(servantActive,guestMode,attributeName,idPeople);
			}
			else{
				link = getUrlMailToLink(servantActive,guestMode,mailAddress);
			}
		}
		if ( (link==null) || (link.equals("")) ){
			line.setLinkType(Line.LINE_LINK_TYPE_NONE);
			link="";
		}
		
		return link;
	}
	
	protected abstract int getUrlChoose(boolean servantActive, boolean guestMode, String attributeName, String idPeople, String mailAddress);
		
	protected abstract String getUrlMailToLink(boolean servantActive, boolean guestMode, String mailAddress);
	
	protected abstract String getUrlMailToChannel(boolean servantActive, boolean guestMode, String attributeName, String idPeople);
	
}
