/*

 ESUP-portail is a french academic project developed under the GPL (General Public License)
 augmented according to the following :

 A binary or source file developped by ESUP-portail can be used or compiled with products under Apache license.

 The official english text of the GPL can be found here : http://www.gnu.org/licenses/gpl.html .

 A non official french translation can be found here : http://www.linux-France.org/article/these/gpl.html .

 The different kinds of licenses governing the products developed by the Apache
 foundation can be found here : http://www.apache.org/licenses .

 It follows that you can as well as use download contents as well modify and redistribute
 them provided you respect the GPL terms.

 Downloading and using such contents do not provide any guaranty.

 Be sure that you have well understood the terms of the license before using the contents it covers.

 The ESUP-portail distribution includes the following distributions :

 * UPortal :
 software developed by JA-SIG (Java Architecture - Special Interest Group)
 You can find the license page here : http://mis105.udel.edu/ja-sig/uportal/license.html

 * CAS :
 SSO solution developed by Yale University
 You can find the project page here : http://www.yale.edu/tp/auth

 * Cocoon :
 XML framework distributed by the Apache foundation under Apache license;
 Please find the full text here : http://cocoon.apache.org/2.1/license.html

 * Mod_dav:
 A DAV module for Apache web server
 You can find the project page here : http://www.webdav.org/mod_dav

 * IMP :
 webmail from Horde application framework
 You can find the project page here : http://www.horde.org
 */

package org.esupportail.portal.channels.CAnnuaire.config.elemOfQuery;

import java.util.Hashtable;
import java.util.Iterator;
import java.util.Vector;

import org.esupportail.portal.channels.CAnnuaire.userInterface;
import org.esupportail.portal.channels.CAnnuaire.config.config;
import org.esupportail.portal.channels.CAnnuaire.config.table.ATable;

public class ElmOfQueryTextTable extends AElmOfQuery {

	public boolean writable() {
		return true;
	}

	public boolean canHaveValues() {
		return true;
	}

	public Hashtable getCritere(String[] values) {

		if ((values == null) || (values.equals(""))) return null;

		ATable T = (ATable) config.getTable(getTable());
		
		Hashtable nouvCritere = new Hashtable();
		nouvCritere.put("label",getVarI18n());


		Hashtable listeRep = T.getValues(searchValue, values);
		
		if (listeRep!= null) {
			String[] display = new String[listeRep.size()];
			Iterator i = listeRep.keySet().iterator();
			int compteur = 0;			
			while (i.hasNext()) {
				String code = (String) i.next();
				display[compteur] = (String)listeRep.get(code);
				compteur++;
			}
			nouvCritere.put("displayValues",display);
		}
		else{
			nouvCritere.put("displayValues",values);
		}

		nouvCritere.put("searchValues",values);

		return nouvCritere;
	}

	public String updateFilter(String[] _value, String urlServeur) {
		ATable T = (ATable) config.getTable(getTable());
		String filtreLocal = new String();
		Hashtable listeRep = T.getValues(searchValue, _value);
		filtreLocal += "(|";
		if (listeRep != null) {
			Iterator i = listeRep.keySet().iterator();
			while (i.hasNext()) {
				String code;
				code = (String) i.next();
				filtreLocal += "("+ getFilter().replaceAll("%c",code + ")");
			}
		}
		filtreLocal += ")";
		return filtreLocal;
	}


	public StringBuffer valuesToXml(Vector selectedValues) {
		StringBuffer xml = new StringBuffer();
		
		if ( (selectedValues!=null) && (selectedValues.size()>0) ){
			xml.append("<FIELDVALUE code=\"").append(getNameHtml()).append("\" ");
			xml.append("value=\"").append(userInterface.valueToXml((String)selectedValues.get(0))).append("\" ");
			xml.append("selected=\"").append("true").append("\" ");
			xml.append("/>\n");
		}
		return xml;
	}
} // end ElmOfQuery
