/*

ESUP-portail is a french academic project developed under the GPL (General Public License)
augmented according to the following :

A binary or source file developped by ESUP-portail can be used or compiled with products under Apache license.

The official english text of the GPL can be found here : http://www.gnu.org/licenses/gpl.html .

A non official french translation can be found here : http://www.linux-France.org/article/these/gpl.html .

The different kinds of licenses governing the products developed by the Apache
foundation can be found here : http://www.apache.org/licenses .

It follows that you can as well as use download contents as well modify and redistribute
them provided you respect the GPL terms.

Downloading and using such contents do not provide any guaranty.

Be sure that you have well understood the terms of the license before using the contents it covers.

The ESUP-portail distribution includes the following distributions :

* UPortal :
software developed by JA-SIG (Java Architecture - Special Interest Group)
You can find the license page here : http://mis105.udel.edu/ja-sig/uportal/license.html

* CAS :
SSO solution developed by Yale University
You can find the project page here : http://www.yale.edu/tp/auth

* Cocoon :
XML framework distributed by the Apache foundation under Apache license;
Please find the full text here : http://cocoon.apache.org/2.1/license.html

* Mod_dav:
A DAV module for Apache web server
You can find the project page here : http://www.webdav.org/mod_dav

* IMP :
webmail from Horde application framework
You can find the project page here : http://www.horde.org
*/
package org.esupportail.portal.channels.CAnnuaire.config.table;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Hashtable;
import java.util.Iterator;

import org.esupportail.portal.channels.CAnnuaire.DB.Database;
import org.esupportail.portal.channels.CAnnuaire.DB.Query;
import org.esupportail.portal.channels.CAnnuaire.config.itemTable;

public class TableSQL extends ATable {

	private String driverClassName;
	private String bddType;
	private String binddn;
	private String bindpass;
	private String url;
	private String attrcode;
	private String attrvalue;
	private String fieldorder;
	private String tableName;
	private String filter;

	public String getAttrcode() {
		return attrcode;
	}


	public void setAttrcode(String attrcode) {
		this.attrcode = attrcode;
	}


	public String getAttrvalue() {
		return attrvalue;
	}


	public void setAttrvalue(String attrvalue) {
		this.attrvalue = attrvalue;
	}


	public String getFieldorder() {
		return fieldorder;
	}


	public void setFieldorder(String fieldorder) {
		this.fieldorder = fieldorder;
	}


	/**
	 * fonction de chargement des lments pour une table de type xml
	 * 
	 */
	public void loadItems() {
		Query query =null;
		Database db = new Database();
		db.setDriverClassName(driverClassName);
		db.setName(getName());
		db.setType(bddType);
		db.setUsername(binddn);
		db.setPassword(bindpass);
		db.setUrl(url);
		try {
			query = new Query(db);
		} catch (SQLException e) {
			log.error("TableSQL::loadItems() : ",e);
		}
		
		if (query!=null){
			try {
				String sql = "SELECT "+attrcode+", "+attrvalue+" ";
				if ( (fieldLink!=null) && (!fieldLink.equals("")) ){
					sql += ", "+fieldLink+" ";
				}
				sql += "FROM "+tableName+" ";
				 
				if ( (filter!=null) && (!filter.equals("")) ){
					sql += "WHERE "+filter+" ";
				}
				if ( (fieldorder!=null) && (!fieldorder.equals("")) ){
					sql += "ORDER BY "+fieldorder;
				}		
				query.setSql(sql);
				query.select();
				ResultSet result = query.getRs();
				
				String order = null;
				String link = null;
				while(result.next()) {
					
					if (fieldorder!=null)
						order = result.getString(fieldorder).trim();
					if (fieldLink!=null)
						link = result.getString(fieldLink).trim();
					
					
					addItem(
							result.getString(attrcode).trim(),
							result.getString(attrvalue).trim(),
							order,
							link);
				}
				if (log.isDebugEnabled()){
					log.debug("TableSQL::loadItems() : sql : "+sql);				
				}
			}
			catch(SQLException e) {
				log.error("TableSQL::loadItems() : ",e);
			}
			catch(Exception e) {
				log.error("TableSQL::loadItems() : ",e);
			}
		}
	}
	

	public Hashtable getValues(String searchValue, String[] saisie) {
		Hashtable codes = new Hashtable();
		
		String search = searchValue.toLowerCase().replaceAll("%s", saisie[0]);
		search  = search.replaceAll("\\*", ".*");
		if (getItems()!=null){
			Iterator i = getItems().keySet().iterator();
			while (i.hasNext()){
				String key = (String) i.next();
				itemTable item = getItem(key);
				if (item.getValue().toLowerCase().matches(search)){
					codes.put(key,item.getValue());
				}
			}
		}
		
		if (codes.size()==0)return null;
		
		return codes;
	}


	public String getBddType() {
		return bddType;
	}


	public void setBddType(String bddType) {
		this.bddType = bddType;
	}


	public String getBinddn() {
		return binddn;
	}


	public void setBinddn(String bindDn) {
		this.binddn = bindDn;
	}


	public String getBindpass() {
		return bindpass;
	}


	public void setBindpass(String bindPass) {
		this.bindpass = bindPass;
	}


	public String getDriverClassName() {
		return driverClassName;
	}


	public void setDriverClassName(String driverName) {
		this.driverClassName = driverName;
	}


	public String getUrl() {
		return url;
	}


	public void setUrl(String url) {
		this.url = url;
	}


	public String getTableName() {
		return tableName;
	}


	public void setTableName(String tableName) {
		this.tableName = tableName;
	}


	public String getFilter() {
		return filter;
	}


	public void setFilter(String filter) {
		this.filter = filter;
	}
}
