/*

ESUP-portail is a french academic project developed under the GPL (General Public License)
augmented according to the following :

A binary or source file developped by ESUP-portail can be used or compiled with products under Apache license.

The official english text of the GPL can be found here : http://www.gnu.org/licenses/gpl.html .

A non official french translation can be found here : http://www.linux-France.org/article/these/gpl.html .

The different kinds of licenses governing the products developed by the Apache
foundation can be found here : http://www.apache.org/licenses .

It follows that you can as well as use download contents as well modify and redistribute
them provided you respect the GPL terms.

Downloading and using such contents do not provide any guaranty.

Be sure that you have well understood the terms of the license before using the contents it covers.

The ESUP-portail distribution includes the following distributions :

* UPortal :
software developed by JA-SIG (Java Architecture - Special Interest Group)
You can find the license page here : http://mis105.udel.edu/ja-sig/uportal/license.html

* CAS :
SSO solution developed by Yale University
You can find the project page here : http://www.yale.edu/tp/auth

* Cocoon :
XML framework distributed by the Apache foundation under Apache license;
Please find the full text here : http://cocoon.apache.org/2.1/license.html

* Mod_dav:
A DAV module for Apache web server
You can find the project page here : http://www.webdav.org/mod_dav

* IMP :
webmail from Horde application framework
You can find the project page here : http://www.horde.org
*/
package org.esupportail.portal.channels.CAnnuaire;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.TreeMap;
import java.util.Vector;

import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.directory.Attribute;
import javax.naming.directory.SearchResult;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.esupportail.portal.channels.CAnnuaire.LDAP.LDAPHandler;
import org.esupportail.portal.channels.CAnnuaire.LDAP.Exceptions.LDAPException;
import org.esupportail.portal.channels.CAnnuaire.config.AttributeLine;
import org.esupportail.portal.channels.CAnnuaire.config.Line;
import org.esupportail.portal.channels.CAnnuaire.config.Server;
import org.esupportail.portal.channels.CAnnuaire.config.config;
import org.esupportail.portal.channels.CAnnuaire.config.itemTable;
import org.esupportail.portal.channels.CAnnuaire.config.elemOfQuery.AElmOfQuery;
import org.esupportail.portal.channels.CAnnuaire.config.elemOfQuery.ElmOfQueryDirect;
import org.esupportail.portal.channels.CAnnuaire.config.elemOfQuery.ElmOfQuerySubTable;
import org.esupportail.portal.channels.CAnnuaire.config.table.ATable;
import org.jasig.portal.ChannelRuntimeData;
import org.jasig.portal.utils.XMLEscaper;


public class userInterface {

    private static final Log log = LogFactory.getLog(CAnnuaire.class);

	/**
	 * Represente l'objet de config (singleton)
	 */
	//private config myConfig;
	
	/**
	 * Represente le serveur visible (si plusieurs, spars par une virgule)
	 */
	private String serverView;
	
	/**
	 * Represente le serveur actif
	 */
	private String serverWork;
	
	/**
	 * Represente le serveur actif
	 */
	private Server myServer;
	
	/**
	 * Represente la liste des rsultats
	 */
	private TreeMap orderedResult;
	private Hashtable result = new Hashtable();
	
	/**
	 * 
	 */
	private static String lang;
	
	
	
	private Hashtable criteres = new Hashtable();
	
	//
	public userInterface() {
	}

	
	/*******************************************************************************************/
	/****FORMULAIRE****/
	/*******************************************************************************************/

	/**
	 * 
	 * Transforme les caractres non affichable dans un fichier XML
	 * 
	 * @param entree : texte  formater en XML correcte
	 * @return une chaine xml formate
	 */
	public static String valueToXml(String input) {
		String output = "";

		if (input != null) {
			output = XMLEscaper.escape(input);
			
		}

		return output;
	}
	public static String valueToXml(String input,String language) {
		String output = "";
		if (input != null) {
			output = config.getI18nText(language,input);
			output = XMLEscaper.escape(output);			
		}

		return output;
	}
	
	
	
	static String valueToAscii(String entree) {
		String sortie = "";

		if (entree != null) {
			sortie = sortie.replaceAll("", "a");
			sortie = sortie.replaceAll("", "a");
			sortie = sortie.replaceAll("", "a");
			sortie = entree.replaceAll("", "e");
			sortie = sortie.replaceAll("", "e");
			sortie = sortie.replaceAll("", "e");
			sortie = sortie.replaceAll("", "e");
			sortie = sortie.replaceAll("", "i");
			sortie = sortie.replaceAll("", "i");
			sortie = sortie.replaceAll("", "o");
			sortie = sortie.replaceAll("", "o");
			sortie = sortie.replaceAll("", "u");
			sortie = sortie.replaceAll("", "u");
			sortie = sortie.replaceAll("", "u");
		}

		return sortie;
		
	}
	
	
	private boolean servantActive = false;
	private boolean guestMode = false;
	
	public void setServantActive(boolean value){
		servantActive = value;
	}
	public void setGuestMode(boolean value){
		guestMode = value;
	}
	
	/**
	 * 
	 * Permet de crer le formulaire de recherche en se basant sur un annuaire
	 * 
	 * @param serveurKey : serveur sur lequel se basera la requete
	 * @return la chaine XML formant le formulaire
	 */
	public StringBuffer getForm() {
		cleanResult();
		/*INITIALISATION DES VALEURS*/
		StringBuffer formXml = new StringBuffer();
		
		if (serverWork == null)
			return (formXml.append(""));
		formXml.append("<FORM>\n");
		

		//formXml.append("<INTRO>" + myConfig.get18InText(lang,myServer.getIntro()) + "</INTRO>");

		/*ECRITURE DU/DES SERVEUR(S) POTENTIEL(S)*/
		if ((serverView.equals("*")) || (serverView.equals(""))) {
			//rcupration des serveurs lus en config
			Vector listeServer = config.getAllServers();
			Iterator i = listeServer.iterator();
			while (i.hasNext()) {
				Server s = config.getServer((String) i.next());
				formXml.append(addServerToForm(s));
			}
		} else {
				
			if (serverView.indexOf(",") == -1) {
				//s'il n'y a qu'un serveur
				//_serverView.matches(","); ne fonctionne pas	
				formXml.append(addServerToForm(config.getServer(serverView)));
			} else {
				//s'il y a plusieurs serveurs
				try {
					String[] tabView = serverView.split(",");
					for (int i = 0; i < tabView.length; i++) {
						formXml.append(addServerToForm(config.getServer(tabView[i])));
					}
				} catch (NullPointerException e) {
						log.error(
						"userInterface::getForm():erreur dans la recherche des annuaires");
				}

			}
		}

		/*ECRITURE DES CHAMPS ACCESSIBLES POUR LA REQUETE*/
		if (myServer != null) {
			Vector listeElt = myServer.getQuery().getElements();
			if (listeElt != null) {
				Iterator j = listeElt.iterator();
				while (j.hasNext()) {
					String key = (String) j.next();
					AElmOfQuery e = myServer.getQuery().getElement(key);
					formXml.append(addFieldToForm(e));
				}
			}
		} else {
				log.error(
				"userInterface::getForm():" + serverWork + " non trouve");
			return new StringBuffer("<ALERT>WARN_SERVER_NOT_FOUND</ALERT>\n");

		}

		formXml.append("</FORM>\n");

		return (formXml);
	}

	/**
	 * @param s : le serveur (Server) que l'on doit ajouter  la liste des serveurs disponibles
	 * @return le code xml pour prendre en compte ce nouveau serveur
	 */
	private StringBuffer addServerToForm(Server s) {
		StringBuffer xml = new StringBuffer("");
		if (s != null) {
			xml.append(s.toXml(lang));
		}
		return (xml);
	}

	
	/**
	 * @param e : lment (ElmOfQuery) de formulaire  ajouter.
	 * @return le code xml pour ajouter ce nouvel lment au formulaire
	 */
	private StringBuffer addFieldToForm(AElmOfQuery e) {
		Hashtable critere = (Hashtable)criteres.get(e.getNameHtml());
		if (critere==null){
			String[] chaineVide = new String[1];
			chaineVide[0]="";
			critere = new Hashtable();
			critere.put("label","");
			critere.put("searchValues",chaineVide);
			critere.put("displayValues",chaineVide);
		}
		return e.toXml(critere);
		
	}

	/*******************************************************************************************/
	/****EXECUTION REQUETE****/
	/*******************************************************************************************/

	/**
	 * @param value : filtre  costruire 
	 * @return true ou false selon que le filtre est bien mis  jour
	 *
	 */
	public boolean addIdToFilter(String value) {

		if ((value != null) && (value != "")) {
			//String id = myServer.getQuery().getIdentifiant();
			Hashtable nouvCritere = new Hashtable();
			String[] tmp = new String[1];
			tmp[0]=value;
			nouvCritere.put("label","id");
			nouvCritere.put("searchValues",tmp);
			nouvCritere.put("displayValues",tmp);
			criteres.put("id", nouvCritere);
			return true;
		} else {
			criteres.remove("id");
			return false;
		}
	}

	/**
	 * 
	 * Met les paramtres reus comme critre de recherche
	 * 
	 * @param listeParametres : parametres recus du formulaire
	 */

	public boolean updateFilter(ChannelRuntimeData runtime) {
		criteres.remove("id");
		
		boolean champTextMisAJour = false;	
		boolean erreurDeSaisie = false;	
		
		Vector eltDeFiltre = myServer.getQuery().getElements();		
		Iterator j = eltDeFiltre.iterator();
		while (j.hasNext()) {
			String key = (String) j.next();
			AElmOfQuery e = config.getServer(serverWork).getQuery().getElement(key);
			
			if (e instanceof ElmOfQueryDirect) {
				criteres.put(e.getNameHtml(), e.getCritere(new String[1]));				
			}
			else{
				String[] values = null;
				values = runtime.getParameterValues(e.getNameHtml());	
				if ( (values!=null ) && (!values[0].equals("")) ){
					
					if (e instanceof ElmOfQuerySubTable) {
						String[] valuesMaster = runtime.getParameterValues(e.getNameHtml()+"_master");
						String[] valuesChild = runtime.getParameterValues(e.getNameHtml());
						values = new String[2];
						values[0] = valuesMaster[0];
						values[1] = valuesChild[0];
					}
					
					
					for (int i=0;i<values.length;i++){
						if (e.getWrapToAsciiBool()) values[i] = userInterface.valueToAscii(values[i]);
						
						if (e.getDelStarBool()) values[i] = values[i].replaceAll("\\*", "");
						
						if (values[i].length() < e.getMinChar()) erreurDeSaisie = true;
					}
					
					
					Hashtable nouvCritere = e.getCritere(values);
					if (nouvCritere!=null){
						champTextMisAJour = true;
						criteres.put(e.getNameHtml(), nouvCritere);
					}
					
				}
				else{
					criteres.remove(e.getNameHtml());
				}
			}
		}	
		
		if ((champTextMisAJour) && (!erreurDeSaisie)) {
			return true;
		} else {
			return false;
		}
	}
	/**
	 * 
	 * Execute la requete
	 * 
	 * @return L'ensemble des personnes rusltat sous forme de Vector
	 */
	public boolean executeQuery() {
		result = new Hashtable();
		orderedResult = new TreeMap(); 
		String filtre = getFiltreComplet();
		if (filtre != "") {
			/*Prpare les attributs LDAP  rcuperer*/
			Vector attrIDs = new Vector();
			attrIDs.addElement(config.getServer(serverWork).getQuery().getIdentifier());
			attrIDs.addAll(config.getDisplay(serverWork).getSort());
			Line ligneEnCours = null;
			AttributeLine elmEnCours = null;
			Iterator iterat = config.getLines(serverWork).iterator();
			while (iterat.hasNext()){
				ligneEnCours = (Line)iterat.next();
				Iterator iterat2 = ligneEnCours.getAttributes().iterator();
				while (iterat2.hasNext()){
					attrIDs.addElement(iterat2.next());
				}
			}
			
			/*Cr et value l'objet LDAP*/
			LDAPHandler LDAP = new LDAPHandler();
			LDAP.setUrl(config.getServer(serverWork).getUrl());
			LDAP.setAttributes((String[])attrIDs.toArray(new String[attrIDs.size()]));
			LDAP.setMaxEntries(config.getServer(serverWork).getQuery().getMaxEntries());
			LDAP.setBase(config.getServer(serverWork).getQuery().getBase());
			LDAP.setBindDn(config.getServer(serverWork).getBinddn());
			LDAP.setBindPass(config.getServer(serverWork).getBindpass());
			LDAP.setFilter(filtre);
			LDAP.setScope(config.getServer(serverWork).getQuery().getScope());
			
			if (log.isDebugEnabled()){
			    log.debug("userInterface::executeQuery() : getFiltreComplet "+getFiltreComplet());
			}
			
			
			/*Lance la recherche*/
			NamingEnumeration answer = null;
			try {
			    answer = LDAP.search();
			} catch (LDAPException e1) {
				log.error("userInterface::executeQuery() : LDAPException : "+e1);
				
			}

			int nbRep = 0;
			if (answer != null) {

				try {
					/*Parcours les rponses*/
					while (answer.hasMore()) {
						Personne p = new Personne();
						p.setLink(config.getServer(serverWork).getDisplay().getLink());
						SearchResult sr;
						try {
							sr = (SearchResult) answer.next();
							nbRep++;
						} catch (NamingException e) {
								log.error(
								"userInterface:executeQuery() : "
									+ e.toString());
							return (false);
						}
						int numAttributCourant = 0;

						/*Ajoute l'attribut identifiant pour la personne*/
						Attribute attrib = sr.getAttributes().get((String)attrIDs.get(0));
						try {
							p.setIdentifier((String) attrib.get());
							numAttributCourant++;
						} catch (NamingException f) {
								log.error(
								"userInterface:executeQuery() : Impossible d'ajouter l'attribut identifiant dans la rponse");
							return (false);
						}

						/*Ajoute l'attribut de tri pour la personne*/
						String sortValue="";
						for (int i = 0; i < config.getServer(serverWork).getDisplay().getSort().size(); i++) {
							attrib = sr.getAttributes().get((String)attrIDs.get(i+1));
							try {
								sortValue+=(String) attrib.get();
								numAttributCourant++;
							} catch (NullPointerException f) {
									log.error(
									"userInterface:executeQuery() : L'attribut de tri est nul");
								return (false);
							} catch (NamingException f) {
									log.error(
									"userInterface:executeQuery() : Impossible d'ajouter l'attribut de tri dans la rponse");
								return (false);
							}
						}
						p.setSort(sortValue);

						
						/*Parcours des lignes*/
						iterat = config.getLines(serverWork).iterator();
						while (iterat.hasNext()){
							ligneEnCours = (Line)iterat.next();
							
							/*Parcours les autres de la ligne et les ajoute pour la personne*/
							Iterator iterat2 = ligneEnCours.getAttributes().iterator();
							while (iterat2.hasNext()){
								String nameAttrib = (String)iterat2.next();
								attrib = sr.getAttributes().get(nameAttrib);
								elmEnCours = ligneEnCours.getAttribute(nameAttrib).copy();
	
								try {
									if (attrib != null) {
										/*Sauvegarde des codes rcuprs qui vont tres transforms en cas de lien avec une table*/
										elmEnCours.setRealValues(attrib.getAll());

										if (elmEnCours.getType().equals(AttributeLine.ATTRIBUTE_LINE_TYPE_TABLE)) {
											/*Rcupration dans la table lie de la valeur de cet attribut*/
											ATable T = config.getTable(elmEnCours.getLinktable());
											String value = null;
											itemTable test;
											for (int k = 0;k < attrib.size();k++) {
												test = T.getItem(attrib.get(k).toString());
												if (test != null){
													value = test.getValue();
													//vrifie si l'lment dans la table existe car lorsqu'il n'existait pas, le chanel faisait un JavaNullException
													if (value != null) {
														attrib.set(k, value);
													}
												} 
											}
										}
										
										elmEnCours.setValues(attrib.getAll());
									} else {
										elmEnCours.setRealValues(null);
										elmEnCours.setValues(null);
									}
								} catch (NamingException f) {
										log.error(
										"userInterface:executeQuery() : ",f);
									return (false);
								}
								p.addAttributes(elmEnCours);
							}
						}
						orderedResult.put(p.getSort()+nbRep,p.getIdentifier());
						result.put(p.getIdentifier(),p);
					}
				} catch (javax.naming.SizeLimitExceededException h) {
					log.warn("userInterface:executeQuery() : Nombre maximum de rponses atteind");
					//Il ne faut pas de return car une fois cette exception dclenche,
					//c'est que le nombre maximum de rponses a t atteind
				} catch (NamingException e) {
						log.error(
						"userInterface:executeQuery() : ",e);
						result = null;
						nbRep = 0;
					return (false);
				}catch (Exception e) {
					log.error(
							"userInterface:executeQuery() : ",e);
					result = null;
					nbRep = 0;
						return (false);
					} 
				finally {
					LDAP.close();
				}
			}

			if (log.isDebugEnabled()){
			    log.debug("userInterface::executeQuery() : nb de rponses trouve : "
						+ nbRep);
			}

			return (true);
		} else {

			if (log.isDebugEnabled()){
			    log.debug("userInterface:executeQuery() : Filtre vide");
			}
			return (false);
		}
	}

	/*******************************************************************************************/
	/****AFFICHAGE RESULTAT****/
	/*******************************************************************************************/

	/**
	 * @return le code xml complet pour afficher le rsultat
	 */
	public StringBuffer getResultXml() {
		StringBuffer xml = new StringBuffer("<tagEnglobant >\n");

		xml.append(this.getCriteresXml());

		xml.append(this.getEnteteXml());

		xml.append(this.getReponseXml());

		xml.append("</tagEnglobant>\n");

		if (this.getNbReponse()
			== config.getServer(serverWork).getQuery().getMaxEntries()) {
			xml.append("<ALERT>WARN_MAX_ENTRIES</ALERT>\n");
		}

		return xml;
	}

	/**
	 * @return le code xml des critres slectionns
	 */
	private StringBuffer getCriteresXml() {
		StringBuffer xml = new StringBuffer();
		for (java.util.Iterator j = criteres.keySet().iterator();
			j.hasNext();
			) {
			String cle = (String) j.next();
			if (!cle.equals("id")){
				Hashtable c = (Hashtable) criteres.get(cle);
				if (c.get("label")!=null){
					xml.append("<critere ");
					xml.append("label=\"").append(userInterface.valueToXml((String)c.get("label"),lang));
					xml.append("\">");
					String[] v = (String[])c.get("displayValues");
					for (int i=0;i<v.length;i++){
						xml.append("<value>").append(userInterface.valueToXml(v[i])).append("</value>");
					}
					
					xml.append("</critere> \n");
				}
			}
		} 
		return xml;
	}

	/**
	 * @return le code xml des entetes de colonnes
	 */
	private StringBuffer getEnteteXml() {
		StringBuffer xml = new StringBuffer();
		/*Rpertorie les attributs*/

		if ( (config.getServer(serverWork).getDisplay().getLink()!=null)
			&& (!config.getServer(serverWork).getDisplay().getLink().equals("")) 
			){
			xml.append("<attributEntete ");
			xml.append("display=\"&#160;\" ");
			xml.append("list=\"1\" ");
			xml.append("/>\n");
		}
		
		int nbLines = config.getServer(serverWork).getDisplay().getLines().size();
		for (int i=0;i<nbLines;i++) {
			Line l = (Line) config.getLines(serverWork).get(i);
			xml.append("<attributEntete ");
			xml.append("display=\""+valueToXml(l.getVarI18n(),lang)+"\" ");
			xml.append("visibility=\""+l.getVisibility()+"\" ");
			//xml.append("nbFields=\""+l.getAttributes().size()+"\" ");
			xml.append("/>\n");
		}

		return xml;
	}

	/**
	 * @return le code xml des rponses
	 */
	private StringBuffer getReponseXml() {

		boolean hasResult = this.executeQuery();

		StringBuffer xml = new StringBuffer();

		if (hasResult) {
			/*rpertorie les rsultats*/
			for (java.util.Iterator j = orderedResult.keySet().iterator(); j.hasNext();) {
				String triId = (String) j.next();
				String id = (String) orderedResult.get(triId);
				Personne p = (Personne) result.get(id);
				xml.append(p.toXml(config.getLines(serverWork),servantActive,guestMode));
			}
		}
		xml.append("<NBREPONSES>" + this.getNbReponse() + "</NBREPONSES>\n");

		return xml;
	}

	/**
	 * @return le code xml complet pour afficher le rsultat
	 */
	public StringBuffer getResultCsv() {
		StringBuffer csv = new StringBuffer();

		csv.append(this.getEnteteCsv());

		csv.append(this.getReponseCsv());

		return csv;
	}
	/**
	 * @return le code csv des entetes de colonnes
	 */
	private StringBuffer getEnteteCsv() {
		StringBuffer csv = new StringBuffer();
		/*Rpertorie les attributs*/
		int nbLines = config.getServer(serverWork).getDisplay().getLines().size();
		for (int i=0;i<nbLines;i++) {
			Line l = (Line) config.getLines(serverWork).get(i);
			String label = config.getI18nText(lang,l.getVarI18n());
			csv.append("\""+label+"\";");
		}
		csv.append("\n");
		return csv;
	}
	
	/**
	 * @return le code csv des rponses
	 */
	private StringBuffer getReponseCsv() {

		boolean hasResult = this.executeQuery();

		StringBuffer csv = new StringBuffer();
		if (hasResult) {
			/*rpertorie les rsultats*/
			//int i = 0;
			for (java.util.Iterator j = orderedResult.keySet().iterator(); j.hasNext();) {
				String  triId= (String) j.next(); 
				String id = (String) orderedResult.get(triId);
				Personne p = (Personne) result.get(id);
				csv.append(p.toCsv(config.getDisplay(serverWork).getLines()));
			}
		}
		
		csv.append("\n");
		return csv;
	}	
	
	/**
	 * @return le nombre de rsultat trouvs
	 */
	public int getNbReponse() {
		if (result != null)
			return result.size();
		else
			return (0);
	}

	/*******************************************************************************************/
	/****GETTER ET SETTER****/
	/*******************************************************************************************/

	/**
	 * @return Returns le filtre compltement gnr
	 */
	public String getFiltreComplet() {
	    String filtre = "";
		filtre = "(&";
		
		Iterator i = criteres.keySet().iterator();
		while (i.hasNext()){
			String key = (String)i.next();
			Hashtable critere = (Hashtable)criteres.get(key);
		
			String[] values = (String[])critere.get("searchValues");
			
			if (key.equals("id")){
				filtre +="("+config.getServer(serverWork).getQuery().getIdentifier()+"="+values[0]+")";
			}
			else{			
				AElmOfQuery e = config.getServer(serverWork).getQuery().getElement(key); 	
				filtre += e.updateFilter(values,config.getServer(serverWork).getUrl());				
			} 
		}
	
		filtre += ")";		
	
		return filtre;
	}

	/**
	 * @return Returns the _serverView.
	 */
	public Vector getEltDeFiltre() {
		return null;
	}

	/**
	 * @return Returns the _serverView.
	 */
	public String getServerView() {
		return serverView;
	}

	/**
	 * @param view The _serverView to set.
	 */
	public boolean setServerView(String view) {
		serverView = view;

		boolean setOk = false;
		String work = "";

		/*ECRITURE DU/DES SERVEUR(S) POTENTIEL(S)*/
		if ((serverView.equals("*")) || (serverView.equals(""))) {
			//rcupration des serveurs lus en config
			setOk = this.setServerWork(config.getDefaultServeurKey());
			work = config.getDefaultServeurKey();

		} else {
			//_serverView.matches(","); ne fonctionne pas
			if (serverView.indexOf(',') == -1) {
				setOk = this.setServerWork(serverView);
				work = serverView;
			} else {
				String[] tabView = serverView.split(",");
				setOk = this.setServerWork(tabView[0]);
				work = tabView[0];
			}
		}

		if (!setOk)
				log.error(
				"userInterface::setServerView():Un serveur pass en paramtre d'instanciation n'est pas correct : "
					+ work);

		return setOk;
	}

	/**
	 * @return Returns the _serverWork.
	 */
	public String getServerWork() {
		return serverWork;
	}

	/**
	 * Dfinit le "serveur de travail" c'est--dire le serveur actif 
	 * 
	 * @param le nom d'un serveur (prsent en config)
	 * @return true si le serveur a t trouv, false sinon
	 */
	public boolean setServerWork(String value) {

		serverWork = null;	
		if (value==null){
			/*Si la valeur est null, le canal prend le premier annuaire dclar*/
			if (serverView==null)
				return false;
			
			if (serverView.indexOf(',') == -1) {
				serverWork = serverView;
			} else {
				String[] tabView = serverView.split(",");
				serverWork = tabView[0];
			}
			myServer = config.getServer(serverWork);
			return true;
		}
		
		if (config.getServer(value) != null) {
			if ( (serverView.matches(".*"+value+".*")) || (serverView.matches("\\*"))|| (serverView.equals("")) ){
				serverWork = value;
				myServer = config.getServer(serverWork);
				return true;
			}
			else{
				return false;
			}
		} else {	
				log.error(
				"userInterface::setServerWork():serveur "
					+ value
					+ " introuvable en config.");
			return false;
		}
	}

	/**
	 * Retourne la liste des rsultats
	 * 
	 * @return la liste des rsultats
	 */
	public Hashtable getResults() {
		return result;
	}
	
	public Personne getResult(String key) {
		Object res = result.get(key);
		if (res!=null){
			return (Personne) res;
		}
		return null;
	}
	
	public void cleanResult(){
		result.clear();
	}
	
	
	public void cleanCritere(){
		criteres.clear();
		//eltDeFiltre.clear();
	}
	/**
	 * @return Renvoie lang.
	 */
	public static String getLang() {
		return lang;
	}
	/**
	 * @param lang lang  dfinir.
	 */
	public void setLang(String _lang) {
		lang = _lang;
	}
}
