<?xml version="1.0" encoding="ISO-8859-1" ?>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">
  	
	<xsl:include href = "${stylesheets.fullpath}/alerts.xsl" />
	<xsl:include href = "${stylesheets.fullpath}/Fields.xsl" />

 	<xsl:output method="html" encoding="UTF-8" />
   <xsl:param name="baseActionURL">donne par le code</xsl:param>
   <xsl:param name="annuSelect">donne par le code</xsl:param>
   <xsl:param name="numCanal"/> 
   <xsl:param name="modeServant">none</xsl:param>
   <xsl:param name="nameForm" />
 
 
   <xsl:template match="RACINE">
   <xsl:apply-templates select="ALERT" /> 
   

   <xsl:apply-templates select="FORM" />
 
   </xsl:template>
 
 
   <xsl:template match="FORM">
			  <!-- JAVASCRIPT -->
				<script language="javascript">
				function MajListe_<xsl:value-of select="$nameForm"/>(nomDuChamp,code,allAlloawed){
				
					var field = eval("document.myForm_<xsl:value-of select="$nameForm"/>."+nomDuChamp);
					
					var tabValues = eval("subValues_"+nomDuChamp+"_<xsl:value-of select="$nameForm"/>");
					
					if (tabValues[code]!=null){
					var i =0;
					if (allAlloawed=="true"){
						field.options[i]=new Option("<xsl:value-of select="$TXT_ALL_SUB_VALUES" />","*",false,true);
						i++;
					}
					
						for (var c in tabValues[code]){
							field.options[i]=tabValues[code][c];
							i++;
						}
						field.options.length=i;
					}
					else{
						field.options.length=0;
					}
				
				}
				
				function selectMaster_<xsl:value-of select="$nameForm"/>(nomDuChamp,code){
					var field = eval("document.myForm_<xsl:value-of select="$nameForm"/>."+nomDuChamp+"_master");
					var cherche = true;
					var i =1;
					while (cherche){
						if (field.options[i].value==code){
							field.options[i].selected = true;
							cherche = false;
						}						
						i++;
						if (i>field.options.length)cherche = false;
					}
					
				}
				
				function startSearch_<xsl:value-of select="$nameForm"/>(e){
					if (e==13){
						document.myForm_<xsl:value-of select="$nameForm"/>.lanceRecherche.click();
					}
				}
				
				
				</script>
   
         <form action="{$baseActionURL}" method="POST" name="myForm_{$nameForm}" >
            <input type="hidden" value="" name="action" />
            <input type="hidden" value="1" name="lanceRecherche" />

            

               <xsl:choose>
                  <xsl:when test="count(SERVER)&gt;1">
                     <font class="uportal-channel-text"><xsl:value-of select="$TXT_FORM_CHOOSE_ANNUARY" disable-output-escaping="yes" /></font>&#160;

                           <select name="annuaire" onchange="document.myForm_{$nameForm}.lanceRecherche.value='';document.myForm_{$nameForm}.submit()" class="uportal-input-text">
                              <xsl:for-each select="SERVER">
                                 <xsl:choose>
                                    <xsl:when test="$annuSelect=@name">
                                       <option value="{@name}" selected="true">
                                          <xsl:value-of select="@label" />
                                       </option>
                                    </xsl:when>

                                    <xsl:otherwise>
                                       <option value="{@name}">
                                          <xsl:value-of select="@label" />
                                       </option>
                                    </xsl:otherwise>
                                 </xsl:choose>
                              </xsl:for-each>
                           </select>
                  </xsl:when>

                  <xsl:when test="count(SERVER)=1">
                     <font class="uportal-channel-text"><xsl:value-of select="$TXT_HEADER_SEARCH_ON" disable-output-escaping="yes" /></font>&#160;<xsl:value-of select="SERVER/@label" />
                  </xsl:when>
               </xsl:choose>    

				<br/>
				 <xsl:if test="SERVER/@intro!='null'">
					 <font class="uportal-channel-warning"><xsl:value-of select="SERVER/@intro" /></font> 
				 </xsl:if>  
				<br/><br/>
                     <xsl:call-template name="FIELDS" />
				<br/><br/>
				<input type="submit" class="uportal-button" value="{$TXT_FORM_LUNCH_SEARCH}" name="btnSearch" />&#160;
				<xsl:if test="$modeServant!='none'">
					<input type="button" name="CAnnuaireServantFinished" value="Retour" class="uportal-button" onclick="document.form_retour_{$nameForm}.submit()"/>
				</xsl:if>

         </form>
         <form action="{$baseActionURL}" method="post" name="form_retour_{$nameForm}">
         	<input type="hidden" name="CAnnuaireServantFinished" value="1"/>		   	   
         </form>
   </xsl:template>

<!--TEMPLATE DE L'AFFICHAGE DES CHAMPS-->
   <xsl:template name="FIELDS">
	 <table border="0" class="uportal-background-content">
	 <xsl:apply-templates select="FIELD" mode="FORM"/>
	</table>
   </xsl:template>


   
</xsl:stylesheet>

