/*

ESUP-portail is a french academic project developed under the GPL (General Public License)
augmented according to the following :

A binary or source file developped by ESUP-portail can be used or compiled with products under Apache license.

The official english text of the GPL can be found here : http://www.gnu.org/licenses/gpl.html .

A non official french translation can be found here : http://www.linux-France.org/article/these/gpl.html .

The different kinds of licenses governing the products developed by the Apache
foundation can be found here : http://www.apache.org/licenses .

It follows that you can as well as use download contents as well modify and redistribute
them provided you respect the GPL terms.

Downloading and using such contents do not provide any guaranty.

Be sure that you have well understood the terms of the license before using the contents it covers.

The ESUP-portail distribution includes the following distributions :

* UPortal :
software developed by JA-SIG (Java Architecture - Special Interest Group)
You can find the license page here : http://mis105.udel.edu/ja-sig/uportal/license.html

* CAS :
SSO solution developed by Yale University
You can find the project page here : http://www.yale.edu/tp/auth

* Cocoon :
XML framework distributed by the Apache foundation under Apache license;
Please find the full text here : http://cocoon.apache.org/2.1/license.html

* Mod_dav:
A DAV module for Apache web server
You can find the project page here : http://www.webdav.org/mod_dav

* IMP :
webmail from Horde application framework
You can find the project page here : http://www.horde.org
*/
package org.esupportail.portal.channels.CAnnuaire.config;

import java.util.Hashtable;
import java.util.Vector;

import org.esupportail.portal.channels.CAnnuaire.CAnnuaire;
import org.esupportail.portal.channels.CAnnuaire.config.custom.ACustomMail;

public class Line{


	public static final String LINE_LINK_TYPE_NONE = "none";
	public static final String LINE_LINK_TYPE_TO_CARD = "toCard";
	public static final String LINE_LINK_TYPE_EXTERNAL = "external";
	public static final String LINE_LINK_TYPE_MAIL = "mail";
	public static final String LINE_LINK_TYPE_ATTRIBUTE = "attribute";
	
	/**
	 * Represente le nom de la variable de texte pr l'internationnalisation
	 */
	private String varI18n;

	private Hashtable attributes = new Hashtable();
	private Vector attributesOrder = new Vector();


	private String linkType;
	
	private String externalLink = "";
	
	private String fieldConnection = "";
	
	private String mailClass = "";
	
	private ACustomMail customMail = null;
	
	/**
	 * Prcise la visibilit de cet attribut
	 * 		- list : visible dans la liste et dans la fiche
	 * 		- card : visible dans la fiche uniquement
	 * 		- none : non visible mais accessible dans les objets rsultats
	 */
	private String visibility;

	/**
	 * @return Renvoie var18In.
	 */
	public String getVarI18n() {
		return varI18n;
	}
	/**
	 * @param var18In var18In  dfinir.
	 */
	public void setVarI18n(String var18In) {
		this.varI18n = var18In;
	}

	public void addAttribute(AttributeLine attr){
		attributes.put(attr.getAttribute(),attr);
		attributesOrder.add(attr.getAttribute());
	}
	public AttributeLine getAttribute(String key){
		return (AttributeLine)attributes.get(key);
	}
	
	public Vector getAttributes() {
		return attributesOrder;
	}

	public void setAttributes(Hashtable attributes) {
		this.attributes = attributes;
	}

	/**
	 * @return le type de lien sur cet attribut :
	 * (none toCard external mail attribute)
	 */
	public String getLinkType() {
		return linkType;
	}
	/**
	 * @param value
	 */
	public void setLinkType(String _link) {
		linkType = _link;
	}
	
	public void verifyLine(){
	
		if (linkType.equals(LINE_LINK_TYPE_EXTERNAL)){
			if ( (getExternalLink()==null) || (getExternalLink().equals(""))){
				setLinkType(LINE_LINK_TYPE_NONE);
			}
		}
	
		if (getLinkType().equals(LINE_LINK_TYPE_MAIL)){
			if ( (getMailClass()==null) || (getMailClass().equals(""))){
				setLinkType(LINE_LINK_TYPE_NONE);
			}
			else{
				try {
	                Class tmpClass = Class.forName(getMailClass());
	                customMail = (ACustomMail)tmpClass.newInstance();
	            } catch (ClassNotFoundException e) {
	                //log.error("userInterface:executeQuery():ClassNotFoundException : ",e);
	                setExternalLink(null);
	                setLinkType(LINE_LINK_TYPE_NONE);
	            } catch (InstantiationException e) {
	            	//log.error("userInterface:executeQuery():InstantiationException : ",e);
	            	setExternalLink("");
	            	setLinkType(LINE_LINK_TYPE_NONE);
	            } catch (IllegalAccessException e) {
	            	//log.error("userInterface:executeQuery():IllegalAccessException : ",e);
	            	setExternalLink("");
	            	setLinkType(LINE_LINK_TYPE_NONE);
	            } catch (Exception e) {
	            	//log.error("userInterface:executeQuery():Exception : "+e.getMessage());
	            	setExternalLink("");
	            	setLinkType(LINE_LINK_TYPE_NONE);
	            }
	            
	            if (customMail!=null){
	            	Class servantClass =null;
		    		try {
		    			servantClass = Class.forName(CAnnuaire.mailToClass);
		                servantClass.newInstance();  
		                customMail.setMailToChannelIsDeployed(true);
		            } catch (Exception e) {
		            	customMail.setMailToChannelIsDeployed(false);
		            }
		            finally{
		            	servantClass = null;
		            }
	            }
			}
		}
	}
	
	public ACustomMail getCustomMailClass(){
		return customMail;
	}
	
	
	/**
	 * Dfinit si l'attribut est visible dans la liste rsultat sous forme de tableau
	 *
	 * @return true / false
	 */
	public String getVisibility() {
		return visibility;
	} // end getList

	/**
	 *Dfinit la liste de valeurs pour cette ligne
	 *
	 * @param value
	 */
	public void setVisibility(String value) {
		visibility = value;
	} // end setList


	public String getExternalLink() {
		return externalLink;
	}

	public String getRealExternalLink(String code, String value){
		String link = "";
		if (externalLink!=null){
			link = externalLink.replaceAll("%c",code);
			link = link.replaceAll("%v",value);
		}
		return link;
	}
	
	public void setExternalLink(String externalLink) {
		this.externalLink = externalLink;
	}
	
	public String getFieldConnection() {
		return fieldConnection;
	}
	public void setFieldConnection(String fieldConnection) {
		this.fieldConnection = fieldConnection;
	}
	public String getMailClass() {
		return mailClass;
	}
	public void setMailClass(String mailClass) {
		this.mailClass = mailClass;
	}

} // end Line
