/*

ESUP-portail is a french academic project developed under the GPL (General Public License)
augmented according to the following :

A binary or source file developped by ESUP-portail can be used or compiled with products under Apache license.

The official english text of the GPL can be found here : http://www.gnu.org/licenses/gpl.html .

A non official french translation can be found here : http://www.linux-France.org/article/these/gpl.html .

The different kinds of licenses governing the products developed by the Apache
foundation can be found here : http://www.apache.org/licenses .

It follows that you can as well as use download contents as well modify and redistribute
them provided you respect the GPL terms.

Downloading and using such contents do not provide any guaranty.

Be sure that you have well understood the terms of the license before using the contents it covers.

The ESUP-portail distribution includes the following distributions :

* UPortal :
software developed by JA-SIG (Java Architecture - Special Interest Group)
You can find the license page here : http://mis105.udel.edu/ja-sig/uportal/license.html

* CAS :
SSO solution developed by Yale University
You can find the project page here : http://www.yale.edu/tp/auth

* Cocoon :
XML framework distributed by the Apache foundation under Apache license;
Please find the full text here : http://cocoon.apache.org/2.1/license.html

* Mod_dav:
A DAV module for Apache web server
You can find the project page here : http://www.webdav.org/mod_dav

* IMP :
webmail from Horde application framework
You can find the project page here : http://www.horde.org
*/
package org.esupportail.portal.channels.CAnnuaire.config;


import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import java.util.Vector;

import org.apache.commons.digester.Digester;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.esupportail.portal.channels.CAnnuaire.CAnnuaire;
import org.esupportail.portal.channels.CAnnuaire.config.table.ATable;


public class config {

    private static final Log log = LogFactory.getLog(CAnnuaire.class);
	/*tableau des serveurs LDAP trouvs en config*/
	private static Hashtable tabServer;
	private static Vector ordreServer;
	private static Hashtable tabTable;
	private static Hashtable languages=new Hashtable();
	private static Language defaultLanguage = null;
	private static List varTexts = new Vector();

	private static config singleton = null;

	/**
	 * @param ConfigFileName
	 */
	private config(String ConfigFileName) {
		tabServer = new Hashtable();
		tabTable = new Hashtable();
		ordreServer = new Vector();

		Digester digester = new Digester();
		digester.setValidating(false);
		digester.push(this);

		/*MONTAGE DES LANGUES*/
		digester.addCallMethod("directories/languages/varsOfText/varOfText", "addVarText", 1);
		digester.addCallParam("directories/languages/varsOfText/varOfText", 0, "name");
		
		digester.addObjectCreate("directories/languages/language", Language.class);
		digester.addSetProperties("directories/languages/language");
		digester.addSetNext("directories/languages/language", "addLanguage");

		/*MONTAGE DES TABLES*/
		digester.addFactoryCreate("directories/tables/table", new FTable());
		digester.addSetProperties("directories/tables/table");
		digester.addCallMethod("directories/tables/table/item", "addItem", 4);
		digester.addCallParam("directories/tables/table/item", 0, "code");
		digester.addCallParam("directories/tables/table/item", 1, "value");
		digester.addCallParam("directories/tables/table/item", 2, "fieldOrder");
		digester.addCallParam("directories/tables/table/item", 3, "linkedValue");
		digester.addSetNext("directories/tables/table", "addTable");

		

		/*MONTAGE DES SERVEUR*/
		// pour chaque directories/directory on cree un objet directory sur lequel on va travailler tant que
		// la mthode addSetNext n'est pas appelle sur directories/directory
		digester.addObjectCreate("directories/directory", Server.class);
		//ajout des proprits du directory
		digester.addSetProperties("directories/directory");
		//ajout des proprits du server
		digester.addSetProperties("directories/directory/server");

		// pour chaque directories/directory/request on cree un objet Query
		digester.addObjectCreate("directories/directory/request", Query.class);
		//ajout des proprits du request
		digester.addSetProperties("directories/directory/request");
		digester.addCallMethod("directories/directory/request", "setScope", 1);
		digester.addCallParam("directories/directory/request", 0, "scope");

		// pour chaque directories/directory/request/elemOfRequest on cree un objet ElmOfQuery
		digester.addFactoryCreate("directories/directory/request/elemOfRequest",new FElmOfQuery());
		//ajout des proprits de l'elmofquery
		digester.addSetProperties("directories/directory/request/elemOfRequest");

		// une fois l'objet request cree on appel Query.addElement qui ajoute un lement de requete
		digester.addSetNext("directories/directory/request/elemOfRequest","addElement");

		// une fois l'objet request cree on appel Server.setQuery qui met  jour son objet Query
		digester.addSetNext("directories/directory/request", "setQuery");

		// pour chaque directories/directory/card on cree un objet Display
		digester.addObjectCreate("directories/directory/card", Display.class);
		//ajout des proprits du display
		digester.addSetProperties("directories/directory/card");
		digester.addCallMethod("directories/directory/card/sort","setSortOrder",1);
		digester.addCallParam("directories/directory/card/sort", 0, "order");
		digester.addCallMethod("directories/directory/card/sort/sortOn","addSortAttribute",1);
		digester.addCallParam("directories/directory/card/sort/sortOn", 0, "attribute");

		// pour chaque directories/directory/request on cree un objet Line
		digester.addObjectCreate("directories/directory/card/line", Line.class);
		//ajout des proprits de la line
		digester.addSetProperties("directories/directory/card/line");
		
		digester.addObjectCreate("directories/directory/card/line/attributeLine", AttributeLine.class);
		digester.addSetProperties("directories/directory/card/line/attributeLine");
		digester.addCallMethod("directories/directory/card/line/attributeLine","setLinktable",1);
		digester.addCallParam("directories/directory/card/line/attributeLine", 0, "table");
		digester.addSetNext("directories/directory/card/line/attributeLine", "addAttribute");

		// une fois l'objet request cree on appel Display.addLine qui ajoute une ligne d'afcichage au display
		digester.addSetNext("directories/directory/card/line", "addLine");

		// une fois l'objet request cree on appel Server.setDisplay qui met  jour objet Display
		digester.addSetNext("directories/directory/card", "setDisplay");

		// une fois l'objet directory cree on appel this.addDirectory qui stocke l'annuaire dans un tableau
		digester.addSetNext("directories/directory", "addServer");
		URL url = config.class.getResource(ConfigFileName);

		if (url != null) {

			InputSource inSource = new InputSource(url.toExternalForm());

			try {
				//parcours du fichier de config
				digester.parse(inSource);
			} catch (IOException e) {
			    log.error("CAnnuaireConfig::config() : ERREUR : Impossible d'ouvrir le fichier de config :"
						+ ConfigFileName
						+ "\n",
						e);
			} catch (SAXException e) {
			    log.error("CAnnuaireConfig::config() : ERREUR : SAXException :\n",
						e);
			} catch (Exception e) {
			    log.error("CAnnuaireConfig::config() : ERREUR : de lecture du fichier de config\n",
						e);
			}
		} else { 
		    log.error("CAnnuaireConfig::config() : ERREUR : "
					+ ConfigFileName
					+ " n'existe pas.\n");
		}
		
	}
	
	
	
	/*public void addDefaultText(String key,String display) {
		//defaultTexts.put(key,display);
		defaultTexts.put(key,"");
	}*/
	public static void addVarText(String key) {
		//defaultTexts.put(key,display);
		varTexts.add(key);
	}
	
	public static void addLanguage(Language l) {
		InputStream ins = null;
		
		if (defaultLanguage==null)defaultLanguage=l; 
		
		String fileLang = "/properties/channels/org_esup/CAnnuaire/languages/config_"+l.getLangId()+".properties";
		   try {
		        /*Lecture du fichier de proprietes*/
		        ins = Language.class.getResourceAsStream(fileLang);
		        Properties confFile = new Properties ();
		        confFile.load (ins);
		        Iterator i = varTexts.iterator();
		        while (i.hasNext()){
		        	String k = (String)i.next();
		        	if (confFile.getProperty(k)!=null){
		        		l.addText(k,confFile.getProperty(k));
		        	}
		        }
		        
		    }
		    catch (Exception e) {
		        log.error("Language::setLangId : Impossible de lire le fichier de langue de la configuration "+fileLang,e);
		    } finally {
		        try {
		            if(ins != null)        
		                ins.close();
		        }catch(Exception ioe) {//IO
			        log.error("Language::setLangId : Impossible de fermer l'InputStream : ",ioe);
		        }
		    }
		languages.put(l.getLangId(),l);
	}

	public static Language getLanguage(String l) {
		return (Language)languages.get(l);
	}
	
	
	
	public static String getI18nText(String lang,String varName){
		String txt="";
		if ((varName!=null) && (lang!=null)){
			if (getLanguage(lang)!=null){
				if ( (getLanguage(lang).getTexts(varName)!=null )&& (!getLanguage(lang).getTexts(varName).equals("") )){
					txt=getLanguage(lang).getTexts(varName);
				}
				else{
					txt=getLanguage(defaultLanguage.getLangId()).getTexts(varName);
				}
			}
			else{
				txt=getLanguage(defaultLanguage.getLangId()).getTexts(varName);
			}
		}
		else{
			txt="";
		}
		return txt;
	}

	public static void addServer(Server s) {
		tabServer.put(s.getName(), s);
		ordreServer.add(s.getName()); 
	}

	
	public static void addTable(ATable t) {
		t.loadItems();
		tabTable.put(t.getName(), t);
	}
	

	public static String getDefaultServeurKey() {
		return (String)ordreServer.get(0);
	}

	public static Vector getAllServers() {
		return (ordreServer);
	}

	public static Server getServer(String key) {
		if (key != null)
			return ((Server) tabServer.get(key));
		else
			return (null);
	}
	
	public static Vector getLines(String serverKey){
		return getServer(serverKey).getDisplay().getLines();
	}
	
	public static AttributeLine getAttributeLine(String serverKey,String nameAttribute){
		Vector vect = getServer(serverKey).getDisplay().getLines();
		
		Iterator i = vect.iterator();
		while (i.hasNext()){
			Line line = (Line)i.next();
			AttributeLine att = line.getAttribute(nameAttribute);
			if (att!=null){
				return att;
			}
		}
		return null;
	}
	
	public static Line getLineContainsAttribute(String serverKey,String nameAttribute){
		Vector vect = getServer(serverKey).getDisplay().getLines();
		
		Iterator i = vect.iterator();
		while (i.hasNext()){
			Line line = (Line)i.next();
			AttributeLine att = line.getAttribute(nameAttribute);
			if (att!=null){
				return line;
			}
		}
		return null;
	}
	
	public static Display getDisplay(String serverKey){
		return getServer(serverKey).getDisplay();
	}

	public static Hashtable getAllTables() {
		return (tabTable);
	}

	public static ATable getTable(String key) {
		if (key==null)return null;
		else return ((ATable) tabTable.get(key));
	}

	public static config getInstance(String configFilePath) {
		
		//return new config(configFilePath);
		
		if (singleton == null) {

			singleton = new config(configFilePath);

		}
		return singleton;

	}
}
