/*

 ESUP-portail is a french academic project developed under the GPL (General Public License)
 augmented according to the following :

 A binary or source file developped by ESUP-portail can be used or compiled with products under Apache license.

 The official english text of the GPL can be found here : http://www.gnu.org/licenses/gpl.html .

 A non official french translation can be found here : http://www.linux-France.org/article/these/gpl.html .

 The different kinds of licenses governing the products developed by the Apache
 foundation can be found here : http://www.apache.org/licenses .

 It follows that you can as well as use download contents as well modify and redistribute
 them provided you respect the GPL terms.

 Downloading and using such contents do not provide any guaranty.

 Be sure that you have well understood the terms of the license before using the contents it covers.

 The ESUP-portail distribution includes the following distributions :

 * UPortal :
 software developed by JA-SIG (Java Architecture - Special Interest Group)
 You can find the license page here : http://mis105.udel.edu/ja-sig/uportal/license.html

 * CAS :
 SSO solution developed by Yale University
 You can find the project page here : http://www.yale.edu/tp/auth

 * Cocoon :
 XML framework distributed by the Apache foundation under Apache license;
 Please find the full text here : http://cocoon.apache.org/2.1/license.html

 * Mod_dav:
 A DAV module for Apache web server
 You can find the project page here : http://www.webdav.org/mod_dav

 * IMP :
 webmail from Horde application framework
 You can find the project page here : http://www.horde.org
 */

package org.esupportail.portal.channels.CAnnuaire.config.elemOfQuery;

import java.util.Hashtable;
import java.util.Vector;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.esupportail.portal.channels.CAnnuaire.CAnnuaire;
import org.esupportail.portal.channels.CAnnuaire.userInterface;

public abstract class AElmOfQuery {

	static protected final Log log = LogFactory.getLog(CAnnuaire.class);

	/**
	 * Represente le type de donne (direct, listTable, ... )
	 */
	private String type;

	/**
	 * Represente le filtre li  cet attribut
	 */
	protected String filter;

	/**
	 * Represente le label  afficher dans le formulaire
	 */
	private String label;

	/**
	 * Represente le nom de la variable de texte pr l'internationnalisation
	 */
	private String varI18n;

	/**
	 * Represente la table lie  cet attribut dans le cas ou la valeur provient
	 * d'un table
	 */
	private String table;

	/**
	 * Represente le nombre minimum de caractre  saisir
	 */
	private int minChar = 0;

	/**
	 * Represente la valeur dans le cas d'une zone de texte
	 */
	protected String searchValue = "";

	/**
	 * Represente le nombre maximum de rsultat que LDAP va renvoyer
	 */
	private int maxEntries = 0;

	/**
	 * Represente si les "*" saisies par l'utilisateur seront supprimes
	 */
	private String delStar = "true";

	/**
	 * Represente le nom html du champ (pas dans la config, ce nom est donn
	 * automatiquement)
	 */
	private String nameHtml;

	/**
	 * Represente si on enlve les caractres non ascii
	 */
	private String wrapToAscii="false";
	
	private String allowAllSubValues="false";

	/**
	 * Retourne le label  afficher dans le formulaire
	 * 
	 * 
	 * @return le label
	 */
	public String getLabel() {
		return label;
	} // end getLabel

	/**
	 * Dfinit le label  afficher dans le formulaire
	 * 
	 * 
	 * @param le
	 *            label
	 */
	public void setLabel(String _label) {
		label = _label;
	} // end setLabel

	/**
	 * Dans le cas ou la valeur provient d'un table retourne la table lie  cet
	 * attribut
	 * 
	 * 
	 * @return le nom de la table
	 */
	public String getTable() {
		return table;
	} // end getTable

	
	/**
	 * Dans le cas ou la valeur provient d'un table dfinit la table lie  cet
	 * attribut
	 * 
	 * @param le
	 *            nom de la table
	 */
	public void setTable(String _table) {
		table = _table;
	} // end setTable

	/**
	 * retourne le type d'lment
	 * 
	 * @return le nom de la table
	 */
	public String getType() {
		return type;
	} // end getType

	/**
	 * Dfinit le type d'lment
	 * 
	 * @param type
	 */
	public void setType(String _type) {
		type = _type;
	} // end setType

	/**
	 * Retourne le filtre engendr par cet lment pour la requete LDAP
	 * 
	 * 
	 * @return le filtre
	 */
	public String getFilter() {
		return filter;
	} // end getFilter

	/**
	 * Dfinit le filtre engendr par cet lment pour la requete LDAP
	 * 
	 * @param le
	 *            filter
	 */
	public void setFilter(String _filter) {
		filter = "";
		if (_filter!=""){
			filter = "("+_filter+")";
		}
	} // end setFilter

	public abstract String updateFilter(String[] _value, String urlServeur);
	
	/**
	 * Retourne le nom de html de l'lment du formulaire
	 * 
	 * @return le nom html
	 */
	public String getNameHtml() {
		return nameHtml;
	}

	/**
	 * Dfinit le nom de html de l'lment du formulaire ce nom n'est pas dans
	 * la config mais il est donn automatiquement
	 * 
	 * @param le
	 *            nom de html
	 */
	public void setNameHtml(String _nameHtml) {
		nameHtml = _nameHtml;
	}

	/**
	 * Dans le cas d'une zone de type text Retourne le nombre minimum de
	 * caractres  saisir
	 * 
	 * @return le nombre minimum de caractres
	 */
	public int getMinChar() {
		return minChar;
	}

	/**
	 * Dans le cas d'une zone de type text Dfinit le nombre minimum de
	 * caractres  saisir
	 * 
	 * @param le
	 *            nombre minimum de caractres
	 */
	public void setMinChar(int _minChar) {
		minChar = _minChar;
	}

	/**
	 * Dans le cas d'une zone de type textTable retourne le masque de saisie (ex :
	 * *%s*)
	 * 
	 * @return le masque
	 */
	public String getSearchValue() {
		return searchValue;
	}

	/**
	 * Dans le cas d'une zone de type textTable Dfinit le masque de saisie (ex :
	 * *%s*)
	 * 
	 * @param le
	 *            masque
	 */
	public void setSearchValue(String _searchValue) {
		searchValue = _searchValue;
	}

	/**
	 * Dans le cas d'une zone de type textTable ou listTable retourne le nombre
	 * maximum de rsultats  rcuprer
	 * 
	 * @return le nombre maximum de rsultats
	 */
	public int getMaxEntries() {
		return maxEntries;
	}

	/**
	 * Dans le cas d'une zone de type textTable ou listTable dfnit le nombre
	 * maximum de rsultat  rcuprer
	 * 
	 * @param le
	 *            nombre maximum de rsultats
	 */
	public void setMaxEntries(int i) {
		maxEntries = i;
	}

	/**
	 * Retourne si oui ou non, les '*' saisies par l'utilisateur sera supprime
	 * 
	 * @return true / false
	 */
	public boolean getDelStarBool() {
		if (delStar.equals("true"))
			return true;
		else
			return false;
	}

	/**
	 * Dfinit si oui ou non, les '*' saisies par l'utilisateur sera supprime
	 * 
	 * @param "true" /
	 *            "false" 
	 */
	public void setDelStar(String string) {
		delStar = string;
	}

	/**
	 * @return Renvoie varI18n.
	 */
	public String getVarI18n() {
		return varI18n;
	}

	/**
	 * @param varI18n
	 */
	public void setVarI18n(String var18In) {
		this.varI18n = var18In;
	}

	/**
	 * @param wrapNonAscii
	 *            wrapNonAscii  dfinir.
	 */
	public void setWrapToAscii(String wrapToAscii) {
		this.wrapToAscii = wrapToAscii;
	}

	/**
	 * @param wrapNonAscii
	 *            wrapNonAscii  dfinir.
	 */
	public String getWrapToAscii() {
		return this.wrapToAscii;
	}

	/**
	 * @param wrapNonAscii
	 *            wrapNonAscii  dfinir.
	 */
	public boolean getWrapToAsciiBool() {
		return this.wrapToAscii.equals("true");
	}
	
	/**
	 * @param wrapNonAscii
	 *            wrapNonAscii  dfinir.
	 */
	public void setAllowAllSubValues(String allowAllSubValues) {
		this.allowAllSubValues = allowAllSubValues;
	}

	/**
	 * @param wrapNonAscii
	 *            wrapNonAscii  dfinir.
	 */
	public String getAllowAllSubValues() {
		return this.allowAllSubValues;
	}

	/**
	 * @param wrapNonAscii
	 *            wrapNonAscii  dfinir.
	 */
	public boolean getAllowAllSubValuesBool() {
		return this.allowAllSubValues.equals("true");
	}

	public abstract boolean writable();

	public abstract StringBuffer valuesToXml(Vector selectedValues);
	
	
	public StringBuffer toXml(Hashtable critere) {
		StringBuffer xml = new StringBuffer();

		xml.append("<FIELD name=\"" + getNameHtml() + "\" ");
		xml.append("type=\"").append(getType()).append("\" ");
		xml.append("label=\"").append(userInterface.valueToXml(getVarI18n(), userInterface.getLang())).append("\" ");
		xml.append("saisie=\"").append(writable()).append("\" ");
		xml.append("allowAllSubValues=\"").append(getAllowAllSubValuesBool()).append("\" ");

		if (getMinChar() > 1) {
			xml.append("minChar=\"").append(getMinChar()).append("\" ");
		}
		xml.append(">\n");
		
		
		String[] v = (String[])critere.get("searchValues");
		Vector vals = null;
		if (v.length>0){
			vals = new Vector();
			for (int i=0;i<v.length;i++){
				if (!v[i].equals("")){
					vals.add(v[i]);
				}
			}
		}
		
		/*XML pour les listes*/
		try {
			xml.append(valuesToXml(vals));
		}
		catch (NullPointerException e){
			// pas de valeurs
		}
		
		xml.append("</FIELD>\n");
		return (xml);
	}

	/**
	 * Un critre est compos de 3 parties : 
	 * critere[label] : le label  afficher 
	 * critere[searchValues] : la valeur  tester 
	 * critere[displayValues] : la valeur  afficher 
	 * */
	public abstract Hashtable getCritere(String[] values);
	
	
	
} // end ElmOfQuery
