/*

ESUP-portail is a french academic project developed under the GPL (General Public License)
augmented according to the following :

A binary or source file developped by ESUP-portail can be used or compiled with products under Apache license.

The official english text of the GPL can be found here : http://www.gnu.org/licenses/gpl.html .

A non official french translation can be found here : http://www.linux-France.org/article/these/gpl.html .

The different kinds of licenses governing the products developed by the Apache
foundation can be found here : http://www.apache.org/licenses .

It follows that you can as well as use download contents as well modify and redistribute
them provided you respect the GPL terms.

Downloading and using such contents do not provide any guaranty.

Be sure that you have well understood the terms of the license before using the contents it covers.

The ESUP-portail distribution includes the following distributions :

* UPortal :
software developed by JA-SIG (Java Architecture - Special Interest Group)
You can find the license page here : http://mis105.udel.edu/ja-sig/uportal/license.html

* CAS :
SSO solution developed by Yale University
You can find the project page here : http://www.yale.edu/tp/auth

* Cocoon :
XML framework distributed by the Apache foundation under Apache license;
Please find the full text here : http://cocoon.apache.org/2.1/license.html

* Mod_dav:
A DAV module for Apache web server
You can find the project page here : http://www.webdav.org/mod_dav

* IMP :
webmail from Horde application framework
You can find the project page here : http://www.horde.org
*/
package org.esupportail.portal.channels.CAnnuaire.config.table;

import java.util.Hashtable;

import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.directory.SearchControls;
import javax.naming.directory.SearchResult;

import org.esupportail.portal.channels.CAnnuaire.LDAP.LDAPHandler;
import org.esupportail.portal.channels.CAnnuaire.LDAP.Exceptions.LDAPException;

public class TableLDAP extends ATable {

	/**
	 * Si la table est du type LDAP : 
	 * indique le mode de recherche dans LDAP
	 */
	private String scope;
	
	/**
	 * Si la table est du type LDAP : 
	 * indique la base de recherche dans LDAP
	 */
	private String base;
	
	/**
	 * Si la table est du type LDAP : 
	 * indique le nom de l'attribut "code"
	 */
	private String attrCode;
	
	/**
	 * Si la table est du type LDAP : 
	 * indique le nom de l'attribut "value"
	 */
	private String attrValue;

	/**
	 * Si la table est du type LDAP : 
	 * indique le filtre appliqu pour slectionner les lmnts
	 */
	private String filter;
	
	/**
	 * Si la table est du type LDAP : 
	 * indique l'attribut servant  ordonner les rsultats
	 */
	private String fieldOrder;

	/**
	 * Si la table est du type LDAP : 
	 * indique l'adresse du serveur LDAP
	 */
	private String url;

	/**
	 * Si la table est du type LDAP : 
	 * indique le Dn de la connection
	 */
	private String bindDn;

	/**
	 * Si la table est du type LDAP : 
	 * indique le mot de passe de la connection de la connection
	 */
	private String bindPass;
	
	/**
	 * dans le cas d'une table LDAP	
	 * dfinit le mode de recherche dans LDAP 
	 * 	
	 * @param string
	 */
	public void setScope(String string) {
		scope = string;
	}

	/**
	 * dans le cas d'une table LDAP
	 * Retrourne le mode de recherche dans LDAP 
	 *  
	 * @return le scope
	 */
	public String getScope() {
		return scope;
	}


	/**
	 * Dans le cas d'une table LDAP	
	 * retourne le filtre LDAP des lments de la table
	 * 
	 * @return le filtre LDAP
	 */
	public String getFilter() {
		return filter;
	}

	/**
	 * Dans le cas d'une table LDAP	
	 * dfinit le filtre LDAP des lments de la table
	 * 
	 * @param _filter
	 */
	public void setFilter(String _filter) {
		if (_filter!=""){
			_filter = "("+_filter+")";
		}
		filter = _filter;
	}
	

	/**
	 * Dans le cas d'une table LDAP	
	 * retourne la base de recherche dans LDAP
	 * 
	 * @return la base de recherche dans LDAP
	 */
	public String getBase() {
		return base;
	}

	/**
	 * Dans le cas d'une table LDAP	
	 * dfinit la base de recherche dans LDAP
	 * 
	 * @param string
	 */
	public void setBase(String string) {
		base = string;
	}
	

	/**
	 * Dans le cas d'une table LDAP
	 * retourne le Dn de la connection
	 * 
	 * @return le Dn de la connection
	 */
	public String getBindDn() {
		return bindDn;
	}

	/**
	 * Dans le cas d'une table LDAP	
	 * retourne l'url du serveur LDAP
	 * 
	 * @return l'url
	 */
	public String getUrl() {
		return url;
	}

	/**
	 * Dans le cas d'une table LDAP	
	 * dfinit l'url du serveur LDAP
	 * 
	 * @param string
	 */
	public void setUrl(String string) {
		url = string;
	}
	

	/**
	 * Dans le cas d'une table LDAP	
	 * dfinit le Dn de connection
	 * 
	 * @param string
	 */
	public void setBinddn(String _bindDn) {
		bindDn = _bindDn;
	} //end setBindPass
	/**
	 * Dans le cas d'une table LDAP	
	 * dfinit le mot de passe de connection
	 * 
	 * @param string
	 */
	public void setBindpass(String _bindPass) {
		bindPass = _bindPass;
	} //end setBindPass
	
	public String getBinddn() {
		return bindDn ;
	} //end setBindPass

	public String getBindpass() {
		return bindPass;
	} //end setBindPass

	
	/**
	 * dans le cas d'une table LDAP
	 * Retrourne le mode de recherche dans LDAP sous forme numrique
	 * 
	 * @return SearchControls.SUBTREE_SCOPE ou SearchControls.ONELEVEL_SCOPE
	 */
	public int getScopeNum() {
		int a;
		if (scope.equalsIgnoreCase("sub")) {
			a = SearchControls.SUBTREE_SCOPE;
		} else {
			a = SearchControls.ONELEVEL_SCOPE;
		}
		return a;
	}

	/**
	 * Dans le cas d'une table LDAP	
	 * retourne le nom de l'attribut "code"
	 * 
	 * @return le nom de l'attribut LDAP 
	 */
	public String getAttrCode() {
		return attrCode;
	}

	/**
	 * Dans le cas d'une table LDAP	
	 * retourne le nom de l'attribut "value"
	 * 
	 * @return le nom de l'attribut LDAP 
	 */
	public String getAttrValue() {
		return attrValue;
	}

	/**
	 * Dans le cas d'une table LDAP	
	 * 
	 * @param string
	 */
	public void setAttrCode(String string) {
		attrCode = string;
	}

	/**
	 * Dans le cas d'une table LDAP	
	 * 
	 * @param string
	 */
	public void setAttrValue(String string) {
		attrValue = string;
	}
	


	/**
	 * Dans le cas d'une table LDAP	
	 * retourne le nom de l'attribut LDAP qui sert de tri
	 * 
	 * @return le nom de l'attribut
	 */
	public String getFieldOrder() {
		return fieldOrder;
	}

	/**
	 * Dans le cas d'une table LDAP	
	 * dfinit le nom de l'attribut LDAP qui sert de tri
	 * 
	 * @param string
	 */
	public void setFieldOrder(String string) {
		fieldOrder = string;
	}
	
	/**
	 * fonction de chargement des lments pour une table de type ldap
	 * 
	 
	public void loadItems(String code) {
		loadItems("");
	}*/
	public void loadItems() {

		/*Met les attributs LDAP  rcuprer dans un tableau de chaines*/
		int NbChamp = 2;
		if (fieldOrder != null) NbChamp++;
		if (fieldLink != null) NbChamp++;
		String[] attrIDs = new String[NbChamp];
		attrIDs[0] = attrCode;
		attrIDs[1] = attrValue;
		if (fieldOrder != null)
			attrIDs[2] = fieldOrder;
		if (fieldLink != null)
			attrIDs[3] = fieldLink;
		
		/*Instanciation de l'objet de recherche LDAP*/
		LDAPHandler LDAP = new LDAPHandler();
		LDAP.setUrl(url);
		LDAP.setBindDn(bindDn);
		LDAP.setBindPass(bindPass);
		LDAP.setAttributes(attrIDs);
		LDAP.setMaxEntries(0);
		LDAP.setBase(base);
		String filterTmp = filter;
		/*if (!code.equals("")){
			filterTmp = "(&("+getAttrCode()+"="+code+")"+filter+")";
		}*/
		LDAP.setFilter(filterTmp);
		LDAP.setScope(this.getScopeNum());
		NamingEnumeration answer = null; 
		try {
			answer = LDAP.search();
		} catch (LDAPException e1) {
			log.error("UpdateAction:visualisation() : LDAPException : "+e1);
		}
		/*Parcours les rponses*/
		if (answer != null) {
			try {
				while (answer.hasMore()) {

					SearchResult sr;
					try {
						sr = (SearchResult) answer.next();

					} catch (NamingException e) {
					    log.error("Table::loadItemLdap() : Parcours les rponses NullPointerException : "
								+ e.toString());	
						LDAP.close();
						break;
					}

					// F. Jammes
					// Si le code de la table est un DN
					// on considre que attrCode n'est pas renseign
					String itemCode;
					if (attrCode != null && !attrCode.equals("dn")) {
						itemCode = (String) sr.getAttributes().get(attrIDs[0]).get(0);
					}
					else {
						itemCode = sr.getName()+","+base;
					}
					
					String value = "NOT FOUND";
					if (sr.getAttributes().get(attrIDs[1])!=null)value = (String) sr.getAttributes().get(attrIDs[1]).get(0);
					String order = "NOT FOUND";
					if (  (NbChamp>=3) && (sr.getAttributes().get(attrIDs[2])!=null) )order = (String) sr.getAttributes().get(attrIDs[2]).get(0);
					String link = "NOT FOUND";
					if (  (NbChamp==4) && (sr.getAttributes().get(attrIDs[3])!=null) )link = (String) sr.getAttributes().get(attrIDs[3]).get(0);
					
					
					
					if (NbChamp==2) {
						addItem(
								itemCode,
								value,
								null);
					}
					else if (NbChamp==3) {
						addItem(
							itemCode,
							value,
							order);
					}
					else if (NbChamp==4) {
						addItem(
							itemCode,
							value,
							order,
							link);
					}
				}
			} catch (NullPointerException e) {
			    log.error("Table::loadItemLdap() : aucune rponse pour la table "+this.name+" : ",e);
			    LDAP.close();
			} catch (NamingException e) {
			    log.error("Table::loadItemLdap() : search : " + e.getMessage());
			    LDAP.close();
			}
		}
	}

	public Hashtable getValues(String searchValue, String[] saisie) {
		
		Hashtable codes = null;
		String[] attrIDs = new String[2];
		attrIDs[0] = getAttrCode();
		attrIDs[1] = getAttrValue();
		LDAPHandler LDAP = new LDAPHandler();
		LDAP.setUrl(getUrl());
		LDAP.setAttributes(attrIDs);
		LDAP.setMaxEntries(0);
		LDAP.setBase(getBase());
		String filtreTmp = "(&" + getFilter() + "("
				+ getAttrValue() + "="
				+ searchValue.replaceAll("%s", saisie[0]) + "))";
		LDAP.setFilter(filtreTmp);

		LDAP.setScope(getScopeNum());
		NamingEnumeration answer = null;
		try {
			answer = LDAP.search();
		} catch (LDAPException e1) {
			log.error("ElmOfQuery:updateFilter() : LDAPException : "
					+ e1);
		} finally {
			LDAP.close();
		}
		
		if (answer != null) {
			try {
				codes = new Hashtable();
				while (answer.hasMore()) {
					SearchResult sr;
					try {
						sr = (SearchResult) answer.next();
						codes.put((String) sr.getAttributes().get(attrIDs[0]).get(0),(String) sr.getAttributes().get(attrIDs[1]).get(0));

					} catch (NamingException f) {
						log.error("ElmOfQuery::updateFilter() : Parcours les rponses NullPointerException : "
										+ f.toString());
						break;
					}
				}
			} catch (NullPointerException f) {
				log.error("ElmOfQuery::updateFilter() : aucune rponse : "
								+ f.toString());
			} catch (NamingException f) {
				log.error("ElmOfQuery::updateFilter() : "
						+ f.toString());
			} finally {
				LDAP.close();
			}
		}
		
		return codes;
	}
	
}
