<?xml version="1.0" encoding="ISO-8859-1" ?>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">

   <xsl:param name="nameForm" />
   
<xsl:template match="line">
   	<xsl:param name="modeListe">false</xsl:param>
	
   	<xsl:choose>
		  <xsl:when test="count(value)=0">&#160;<!-- espace --></xsl:when>
		  
		  <!-- Champ avec un lien vers la feuille detaillee -->
		  <xsl:when test = "(@linkType='toCard') and ($modeListe='true')">
			<xsl:variable name="title">
				<xsl:value-of select="substring-before($TXT_INFO_DETAIL,'%s')" disable-output-escaping="yes" />
				<xsl:value-of select="../attributId/@value" />
				<xsl:value-of select="substring-after($TXT_INFO_DETAIL,'%s')" disable-output-escaping="yes" />
			</xsl:variable>
			<a href="{$baseActionURL}?id={../attributId/@value}" title="{$title}">
				<xsl:for-each select = "value">
					<xsl:value-of select="current()" />
					<xsl:call-template name="fieldConnection"/>
				</xsl:for-each>	
			</a>
		  </xsl:when>
		  
		  <!--  Champ avec un lien externe -->
		  <xsl:when test = "@linkType='external'">	   
				<xsl:for-each select = "value">
					<a href="{@externalLink}" title="lien sur {@externalLink}" target="_blank">
						<xsl:value-of select="current()" />
					</a><xsl:call-template name="fieldConnection"/>
				</xsl:for-each>	
		  </xsl:when>
		  
		  
		  <!--  Champ avec un lien sur le mail -->
			<xsl:when test = "@linkType='mail'">
			<xsl:for-each select = "value">
				<xsl:variable name="title">
					<xsl:value-of select="substring-before($TXT_INFO_SEND_MAIL,'%s')" disable-output-escaping="yes" />
					<xsl:value-of select="current()" />
					<xsl:value-of select="substring-after($TXT_INFO_SEND_MAIL,'%s')" disable-output-escaping="yes" />
				</xsl:variable>			   
				<a href="{@externalLink}" title="{$title}">
					<xsl:value-of select="current()" />
				</a><xsl:call-template name="fieldConnection"/>
			</xsl:for-each>		
		  </xsl:when>
		  
		  <!--  Champ avec un lien dont l'adresse est la valeur de l'attribut -->
		  <xsl:when test = "@linkType='attribute'">
				<xsl:for-each select = "value">
					<xsl:variable name="title">lien sur <xsl:value-of select="current()" /></xsl:variable>
					<a href="{current()}" title="{$title}" target="_blank">
						<xsl:value-of select="current()" />
					</a><xsl:call-template name="fieldConnection"/>
				</xsl:for-each>
		  </xsl:when>
		  
		  <!-- texte normal -->
		  <xsl:otherwise>
				<xsl:for-each select = "value">
					<xsl:value-of select="current()" />
					<xsl:call-template name="fieldConnection"/>
				</xsl:for-each>
		  </xsl:otherwise> 
	  </xsl:choose>

   </xsl:template>   
   
   <xsl:template name="fieldConnection">
	<xsl:if test="position()!=last()">
		<xsl:choose>	
			<xsl:when test="../@fieldConnection!=''"><xsl:value-of select="../@fieldConnection" /></xsl:when>
			<xsl:otherwise><br /></xsl:otherwise> 
		</xsl:choose>	
	</xsl:if>
   </xsl:template> 
   
   
   
   
<!--TEMPLATE D'UN CHAMP-->
<xsl:template match="FIELD" mode="FORM">

      <xsl:choose>
         <xsl:when test="@saisie='true'">
            <tr valign="top">
               <td class="uportal-channel-label" nowrap="true">
				   <xsl:value-of select="@label" />
               </td>

               <td valign="top">
                  <xsl:choose>
                     
					<!-- zone de texte -->
                     
                     <xsl:when test="@type='text' or @type='textTable'">
                        <input type="text" name="{@name}" value="{FIELDVALUE/@value}" class="uportal-input-text"/>                       
                        
                        <xsl:if test="@minChar!=''">&#160;
                        	<font class="uportal-channel-text">
   								<xsl:value-of select="substring-before($TXT_FORM_AT_LEAST_N_CHARACTERS,'%d')" disable-output-escaping="yes" />
								<xsl:value-of select="@minChar" />
								<xsl:value-of select="substring-after($TXT_FORM_AT_LEAST_N_CHARACTERS,'%d')" disable-output-escaping="yes" />
							</font>
                        </xsl:if>
                     </xsl:when>
                     
                     <!-- liste  droulante -->
                     
                     <xsl:when test="@type='listTable'">
                        <select name="{@name}" class="uportal-input-text">
	                       <option value="">&#160;</option>
                           <xsl:for-each select="FIELDVALUE">
                              <xsl:sort select="@order" />
                              <xsl:variable name="code"><xsl:value-of select="@code" /></xsl:variable>
                  			<xsl:choose>
                     			<xsl:when test="@selected='true'">
	                              <option value="{@code}" selected="true">
	                                 <xsl:value-of select="@value" />
	                              </option>
								</xsl:when>
                     			<xsl:otherwise>
	                              <option value="{@code}">
	                                 <xsl:value-of select="@value" />
	                              </option>
                     			</xsl:otherwise>
                  			</xsl:choose>
                           </xsl:for-each>
                        </select>
                     </xsl:when>

					<!-- liste multi slection -->
	
                     <xsl:when test="@type='multiListTable'">
                     <xsl:value-of select="$TXT_MULTI_SELECTION" /><br/>
                        <select name="{@name}" class="uportal-input-text" multiple="true" size="10">
	                       <option value="">&#160;</option>
                           <xsl:for-each select="FIELDVALUE">
                              <xsl:sort select="@order" />
                              <xsl:variable name="code"><xsl:value-of select="@code" /></xsl:variable>
                  			<xsl:choose>
                     			<xsl:when test="@selected='true'">
	                              <option value="{@code}" selected="true">
	                                 <xsl:value-of select="@value" />
	                              </option>
								</xsl:when>
                     			
                     			<xsl:otherwise>
	                              <option value="{@code}">
	                                 <xsl:value-of select="@value" />
	                              </option>
                     			</xsl:otherwise>
                  			</xsl:choose>
                           </xsl:for-each>
                        </select>
                     </xsl:when>
                     

					<!-- bouton radio -->

                     <xsl:when test="@type='radioTable'">
                  			<xsl:choose>
                     			<xsl:when test="count(../FIELDVALUE[@selected=true])=0">
	                              <input type="radio" name="{@name}" value="" class="uportal-channel-text" checked="true" /><i>Aucun</i><br/>
								</xsl:when>
                     			
                     			<xsl:otherwise>
	                              <input type="radio" name="{@name}" value="" class="uportal-channel-text" /><i>Aucun</i><br/>
                     			</xsl:otherwise>
                  			</xsl:choose>
							
                           <xsl:for-each select="FIELDVALUE">
                              <xsl:sort select="@order" />
                              <xsl:variable name="code"><xsl:value-of select="@code" /></xsl:variable>
                  			<xsl:choose>
                     			<xsl:when test="@selected='true'">
	                              <input type="radio" name="{../@name}" value="{@code}" checked="true" class="uportal-channel-text" /><xsl:value-of select="@value" /><br/>
								</xsl:when>
                     			
                     			<xsl:otherwise>
	                              <input type="radio" name="{../@name}" value="{@code}" class="uportal-channel-text" /><xsl:value-of select="@value" /><br/>
                     			</xsl:otherwise>
                  			</xsl:choose>
                           </xsl:for-each>
                     </xsl:when>
                     
                     <!-- case  cocher -->

                     <xsl:when test="@type='checkboxTable'">
                           <xsl:for-each select="FIELDVALUE">
                              <xsl:sort select="@order" />
                              <xsl:variable name="code"><xsl:value-of select="@code" /></xsl:variable>
                  			<xsl:choose>
                     			<xsl:when test="@selected='true'">
	                              <input type="CHECKBOX" name="{../@name}" value="{@code}" checked="true"/><xsl:value-of select="@value" /><br/>
								</xsl:when>
                     			
                     			<xsl:otherwise>
	                              <input type="CHECKBOX" name="{../@name}" value="{@code}"/><xsl:value-of select="@value" /><br/>
                     			</xsl:otherwise>
                  			</xsl:choose>
                           </xsl:for-each>
                     </xsl:when>
                     
                     
                     
                     
                     <!-- Double liste -->
                     
                     <xsl:when test="@type='subTable'">
                     
                     
                        <script language="javascript">
                        var  subValues_<xsl:value-of select="@name" />_<xsl:value-of select="$nameForm"/> = new Array();
                        var selectedCodeMaster<xsl:value-of select="@name" />_<xsl:value-of select="$nameForm"/> = "";
                           <xsl:for-each select="MASTERFIELDVALUE">
									subValues_<xsl:value-of select="../@name" />_<xsl:value-of select="$nameForm"/>["<xsl:value-of select="@code" />"] = new Array();									
							<xsl:if test="@selected='true'">
							  selectedCodeMaster<xsl:value-of select="../@name" />_<xsl:value-of select="$nameForm"/> = "<xsl:value-of select="@code" />";
							</xsl:if>									
							  <xsl:for-each select="FIELDVALUE">
								  <xsl:sort select="@order" />
								  <xsl:variable name="code"><xsl:value-of select="@code" /></xsl:variable>
								  subValues_<xsl:value-of select="../../@name" />_<xsl:value-of select="$nameForm"/>["<xsl:value-of select="../@code" />"]["<xsl:value-of select="@code" />"] = new Option("<xsl:value-of select="@value" />","<xsl:value-of select="@code" />",false,<xsl:value-of select="@selected"/>);		
							   </xsl:for-each>
                           </xsl:for-each>
                        
                         </script>
                     
                        <select name="{@name}_master" class="uportal-input-text" onchange="MajListe_{$nameForm}('{@name}',this.options[this.selectedIndex].value,'{@allowAllSubValues}')">
	                       <option value=""></option>
                           <xsl:for-each select="MASTERFIELDVALUE">
                              <xsl:sort select="@order" />
                              <xsl:if test="count(FIELDVALUE)>0">
									 <option value="{@code}">
											 <xsl:value-of select="@value" />
									 </option>
                  			</xsl:if>
                           </xsl:for-each>
                        </select><br/>
                        
                        <select name="{@name}" class="uportal-input-text">
                           
                        </select>
                        
                        
                     <!-- JAVASCRIPT -->
                        <script language="javascript">
                        if (selectedCodeMaster<xsl:value-of select="@name" />_<xsl:value-of select="$nameForm"/>!=""){
							selectMaster_<xsl:value-of select="$nameForm"/>("<xsl:value-of select="@name" />",selectedCodeMaster<xsl:value-of select="@name" />_<xsl:value-of select="$nameForm"/>);							
							MajListe_<xsl:value-of select="$nameForm"/>('<xsl:value-of select="@name" />',selectedCodeMaster<xsl:value-of select="@name" />_<xsl:value-of select="$nameForm"/>,"<xsl:value-of select="@allowAllSubValues"/>")
                        }
                         </script>
                     </xsl:when>
                     
                     
                  </xsl:choose>
                  
               </td>
            </tr>
         </xsl:when>
      </xsl:choose>
   </xsl:template>
   
   
</xsl:stylesheet>
