<?xml version="1.0" encoding="ISO-8859-1" ?>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">
   
	<xsl:include href = "${stylesheets.fullpath}/header.xsl" />
	<xsl:include href = "${stylesheets.fullpath}/Fields.xsl" />
	
	<xsl:param name="modeServant">none</xsl:param>
	
	<xsl:param name="displayHeader">none</xsl:param>

   <xsl:param name="sortOrder">acending</xsl:param>

   <xsl:param name="mediaPath">media/org/esupportail/portal/channels/CAnnuaire</xsl:param>
	
   <xsl:template match="tagEnglobant">
	<form action="{$baseActionURL}" method="post">
	   <table align="center" width="100%">  	
			
		<xsl:if test="$displayHeader='true'">
			<tr><td>
			<xsl:call-template name = "entete" />
			</td></tr>
		</xsl:if>
		
	   
	   <xsl:if test="$modeServant!='none'">
	   <tr><td align="center">
		   <xsl:choose>
		   <xsl:when test="/RACINE/tagEnglobant/NBREPONSES > 1"> 
			  <input type="hidden" value="root" name="uP_root" />
			  <input type="submit" name="CAnnuaireServantFinished" value="{$TXT_SERVANT_VALID}" class="uportal-button" /> 
		   </xsl:when>
		   <xsl:otherwise>
				<input type="hidden" value="root" name="uP_root" />
			   <input type="submit" name="CAnnuaireServantFinished" value="{$TXT_SERVANT_SELECT}" class="uportal-button" /> 
		   </xsl:otherwise>    
		   </xsl:choose>
	   </td></tr>
	   </xsl:if>
	   
		<tr>
		<td align="center" >   
			<table>   
			<tr>
				<td>
				<xsl:for-each select = "resultat" >   
					<xsl:sort select="attributTri/@value" order="{$sortOrder}"/>
					<xsl:apply-templates select="current()"/>
				</xsl:for-each>
			</td>
			</tr>
			</table>
		</td>
		</tr>
		
		<xsl:if test="$displayHeader='false'">
			<tr><td>
				<input type="hidden" name="uP_root" value="root"/>
				<input type="submit" name="CAnnuaireReturnToChannel" value="{$TXT_SERVANT_BACK}"  class="uportal-button"/>
			</td></tr>
		</xsl:if>
		
	   </table>
	   
	   <xsl:if test="$modeServant!='none'">
	   <center>
	   <br/>
	   <xsl:choose>
	   <xsl:when test="/RACINE/tagEnglobant/NBREPONSES > 1"> 
		  <input type="hidden" value="root" name="uP_root" />
		  <input type="submit" name="CAnnuaireServantFinished" value="{$TXT_SERVANT_VALID}" class="uportal-button" /> 
	   </xsl:when>
	   <xsl:otherwise>
			<input type="hidden" value="root" name="uP_root" />
		   <input type="submit" name="CAnnuaireServantFinished" value="{$TXT_SERVANT_SELECT}" class="uportal-button" /> 
	   </xsl:otherwise>    
	   </xsl:choose>
	   </center>	
	   </xsl:if>
	</form>
   </xsl:template>
   
   

   
<!--AFFICHAGE DES LIGNES RESULTAT-->
   <xsl:template match="resultat">   	
   	
   	<table border="4" cellpadding="0" cellspacing="0" align="center" width="100%" border-style="outset" >
   	<tr>
   		<td>
   			<table border="0" cellpadding="2" cellspacing="2" align="center" width="100%">   
			 
			<xsl:if test="/RACINE/tagEnglobant/NBREPONSES > 1"> 
			<tr valign="top">
					<td align="left" colspan="2">
				<xsl:choose>
					<xsl:when test="$modeServant='multiple'">
						<input type="checkbox" name="pers_id[]" value="{attributId/@value}" />
						<font class="uportal-channel-text">Slectionner la fiche</font>
					</xsl:when>
					<xsl:when test="$modeServant='single'">
						<input type="radio" name="pers_id" value="{attributId/@value}" />
						<font class="uportal-channel-text">Slectionner la fiche</font>
					</xsl:when>
				</xsl:choose>    
					</td>
				</tr>
				</xsl:if>
			
			<xsl:for-each select="line[((@visibility='list') or (@visibility='card')) and (count(value)>0)]">
				<tr valign="top">
	   			<td class="uportal-label" align="left" nowrap="true" width="10">
				  <xsl:value-of select="@display" />&#160;: 
			   </td>
			   <td class="uportal-channel-text">
					<xsl:apply-templates select="current()"/>
			   </td>
			   </tr>
			</xsl:for-each>
	      
			 <xsl:if test="attributLink/@value!=''">
				<tr valign="top">
					<td align="left" colspan="2">
						<a href="{attributLink/@value}" target="_blank" >
							<img src="{$mediaPath}/info.gif" title="{$TXT_INFO_EXTERN_ANNUARY}" border="0"/>
							<xsl:value-of select="$TXT_INFO_EXTERN_ANNUARY" />
						</a>
					</td>
				</tr>
			 </xsl:if>

			</table>
   		</td>
   	</tr>
   	</table>
			<br/>
   </xsl:template>
   
   
</xsl:stylesheet>
