<?xml version="1.0" encoding="ISO-8859-1" ?>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">

    <xsl:param name="baseActionURL">donne par le code</xsl:param>
    <xsl:param name="baseDownloadURL">donne par le code</xsl:param>
    <xsl:param name="returnToTab">donne par le code</xsl:param>
    <xsl:param name="mediaPath">media/org/esupportail/portal/channels/CAnnuaire</xsl:param>
	<xsl:param name="allowExport">false</xsl:param>

   <xsl:param name="sortOrder">acending</xsl:param>
   
   <xsl:template name="entete">
   <table align="center" width="100%" border="0">
   <tr>
   		<th class="uportal-channel-subtitle" colspan="2">
   			<xsl:if test="$returnToTab='true'">
   				<a href="{$baseActionURL}?backToList=true"><img src="{$mediaPath}/back.gif" title="{$TXT_HEADER_BACK_TO_LIST_OF_RESULT}" border="0"/>&#160;<xsl:value-of select="$TXT_HEADER_BACK_TO_LIST_OF_RESULT" disable-output-escaping="yes" /></a>  
				&#160;&#160;&#160;
   			</xsl:if>   

   			<a href="{$baseActionURL}?updateQuery=true"><img src="{$mediaPath}/modify.gif" title="{$TXT_HEADER_MODIFY_QUERY}" border="0"/>&#160;<xsl:value-of select="$TXT_HEADER_MODIFY_QUERY" disable-output-escaping="yes" /></a> 
   			
   			&#160;&#160;&#160; 
   			<a href="{$baseActionURL}?newQuery=true"><img src="{$mediaPath}/newfile.gif" title="{$TXT_HEADER_NEW_QUERY}" border="0"/>&#160;<xsl:value-of select="$TXT_HEADER_NEW_QUERY" disable-output-escaping="yes" /></a> 
			
			<xsl:if test="$allowExport='true'">
				&#160;&#160;&#160; 
				<a href="{$baseDownloadURL}?action=exportList"><img src="{$mediaPath}/save.gif" title="{$TXT_HEADER_EXPORT}" border="0"/>&#160;<xsl:value-of select="$TXT_HEADER_EXPORT" disable-output-escaping="yes" /></a> 
   			</xsl:if>   
   			<hr/>
   		</th>
   	</tr>
   	
   	<xsl-if test="$TXT_HEADER_COMMENT!=''">
   	<tr>
   		<td class="uportal-channel-text" colspan="2">
   		<xsl:value-of select="$TXT_HEADER_COMMENT" disable-output-escaping="yes" />
		</td>
	</tr>
	</xsl-if>
   	<tr>
   		<td class="uportal-channel-strong" align="right">
   		
   		<xsl:choose>
   			<xsl:when test="NBREPONSES=0">
   				<xsl:value-of select="$TXT_HEADER_NO_RESULT" disable-output-escaping="yes" />
   			</xsl:when>
   			
   			<xsl:when test="NBREPONSES=1">
   				<xsl:value-of select="$TXT_HEADER_ONE_RESULT" disable-output-escaping="yes" />
   			</xsl:when>
   		  
   			<xsl:otherwise>
   				<xsl:value-of select="substring-before($TXT_HEADER_SOME_RESULT,'%d')" disable-output-escaping="yes" />
   				<xsl:value-of select="NBREPONSES" />
   				<xsl:value-of select="substring-after($TXT_HEADER_SOME_RESULT,'%d')" disable-output-escaping="yes" />
   			</xsl:otherwise>
   		</xsl:choose>
   		</td>
   		<td class="uportal-channel-subtitle" align="left"> - <xsl:value-of select="$TXT_HEADER_SEARCH_ON" disable-output-escaping="yes"/></td>
   		
   	</tr>
   	
	<tr>
	<td colspan="2" align="center">
		<table border="0">
   		<xsl:for-each select = "critere">
			<xsl:if test="(@label!='') and (@label!='null')">
				<tr><td><li><font  class="uportal-channel-label"><xsl:value-of select="@label" /></font></li>
					<xsl:if test="count(value)>0"> : 
						<font class="uportal-channel-text">
							<xsl:for-each select = "value">
								<xsl:choose>
									<xsl:when test="current()='ALL_SUB_VALUES'">
										<xsl:value-of select="$TXT_ALL_SUB_VALUES" />
									</xsl:when>	
									<xsl:otherwise>	
										<xsl:value-of select="current()" />
									</xsl:otherwise>
								</xsl:choose>
								<xsl:if test="position()!=last()">, </xsl:if> 
							</xsl:for-each>
						</font>
					</xsl:if>   
				</td></tr>	
			</xsl:if>
		</xsl:for-each>
		</table>
	</td>
	</tr>
	
   	</table>
   			
   </xsl:template>
   
</xsl:stylesheet>
