<?xml version="1.0" encoding="ISO-8859-1" ?>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">

	<xsl:include href = "${stylesheets.fullpath}/alerts.xsl" />
	<xsl:include href = "${stylesheets.fullpath}/header.xsl" />
	<xsl:include href = "${stylesheets.fullpath}/Fields.xsl" />
   <xsl:param name="baseActionURL">donne par le code</xsl:param>
   <xsl:param name="mediaPath">media/org/esupportail/portal/channels/CAnnuaire</xsl:param>
   <xsl:param name="modeServant">none</xsl:param>
   <xsl:param name="sortOrder">acending</xsl:param>
   <xsl:param name="nameForm" />


   <xsl:template match="RACINE">
   
   <xsl:apply-templates select = "ALERT" />  
   
   <xsl:apply-templates select = "tagEnglobant" />  
 
   </xsl:template>
   
   <xsl:template match="tagEnglobant">
   	  <form action="{$baseActionURL}" name="formAnnuary_{$nameForm}" method="post">	
   	
   	  	
   	<table align="center" width="100%">
   	
   	<tr><td>
   	<xsl:call-template name = "entete" />
   	</td></tr>
   
   	
   	<tr>
   	<td align="center">

      <xsl:if test="$modeServant!='none'">
         <center>
               <input type="submit" name="CAnnuaireServantFinished" value="{$TXT_SERVANT_SELECT}" class="uportal-button" />
         		<br/>
         </center>
      </xsl:if>
   	
   	<table border="1" cellpadding="2" cellspacing="3"> 
   	
   	<tr class="uportal-background-med">   
		<xsl:if test="$modeServant!='none'">
			<th class="uportal-channel-table-header">&#160;</th>
		</xsl:if>	
		
		<xsl:apply-templates select = "attributEntete" />
   	</tr> 
   	  	
   	
   	<xsl:apply-templates select = "resultat" >   	
		<xsl:sort select="attributTri/@value" order="{$sortOrder}"/>
   	</xsl:apply-templates>
   	
   	</table>
   	
   	</td>
   	</tr>
   	
   </table>

      <xsl:if test="$modeServant!='none'">
         <center>
         		<br/>
               <input type="submit" name="CAnnuaireServantFinished" value="{$TXT_SERVANT_SELECT}" class="uportal-button" />
         </center>
      </xsl:if>
      </form>
   	
   </xsl:template>
   
   

   
   
<!--AFFICHAGE DES ENTETES EN FONCTION DES ATTRIBUTS RECHERCHES-->
   <xsl:template match="attributEntete">   
   <xsl:if test = "@visibility='list'"><!--  colspan="{@nbFields}" -->
   	<th class="uportal-channel-table-caption"><xsl:value-of select="@display" /></th>
   </xsl:if>
   </xsl:template>
   
<!--AFFICHAGE DES LIGNES RESULTAT-->
   <xsl:template match="resultat">
		<xsl:param name="background">
			<xsl:choose>
				<xsl:when test="(position() mod 2) = 0">uportal-background-light</xsl:when>
				<xsl:otherwise>uportal-background-content</xsl:otherwise>
			</xsl:choose>
		</xsl:param>

		<tr class="{$background}" onmouseover="this.className='uportal-background-highlight';" onmouseout="this.className='{$background}';">
	      	 
	      	 <xsl:if test="$modeServant!='none'">
	            <td align="right">
	            <xsl:choose>
	         		<xsl:when test="$modeServant='multiple'">
	                <input type="checkbox" name="pers_id[]" value="{attributId/@value}" />
	                </xsl:when>
	                <xsl:when test="$modeServant='single'">
	                <input type="radio" name="pers_id" value="{attributId/@value}" />
	                </xsl:when>
	            </xsl:choose>    
	            </td>
	         </xsl:if>
	         
	         <xsl:if test="attributLink/@value!=''">
	            <td>
	            	<a href="{attributLink/@value}" target="_blank" >
						<img src="{$mediaPath}/info.gif" title="{$TXT_INFO_EXTERN_ANNUARY}" border="0"/>
	            	</a>
	            </td>
	         </xsl:if>
				<xsl:for-each select="line[@visibility='list']">
					<td class="uportal-channel-text">
						<xsl:apply-templates select="current()" >
							<xsl:with-param name="modeListe">true</xsl:with-param>					
						</xsl:apply-templates>
				   </td>
				</xsl:for-each>
		</tr>
   </xsl:template>
   
   
</xsl:stylesheet>

