<?php
/***************************************************************************
 *                                login.php
 *                            -------------------
 *   begin                : Saturday, Feb 13, 2001
 *   copyright            : (C) 2001 The phpBB Group
 *   email                : support@phpbb.com
 *
 *   $Id: login.php,v 1.3 2004/12/14 14:25:43 patureau Exp $
 *
 *
 ***************************************************************************/

/***************************************************************************
 *
 *   This program is free software; you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation; either version 2 of the License, or
 *   (at your option) any later version.
 *
 ***************************************************************************/

include_once('CAS/CAS.php');

//
// Allow people to reach login page if
// board is shut down
//
define("IN_LOGIN", true);

define('IN_PHPBB', true);
$phpbb_root_path = './';
include($phpbb_root_path . 'extension.inc');
include($phpbb_root_path . 'common.'.$phpEx);

// TODO: put cas related in a file functions_cas.php
define('CAS_USE', true);
define('CAS_OK', true);
define('CAS_NOK', false);


//
// Set page ID for session management
//
$userdata = session_pagestart($user_ip, PAGE_LOGIN);
init_userprefs($userdata);
//
// End session management
//

// SSO (CAS) management
$cas_status=CAS_NOK;
if ($board_config['cas_use'])
{
       $CAS =  phpCAS::Client(CAS_VERSION_2_0,$board_config['cas_hostname'],(int) $board_config['cas_port'],$board_config['cas_uri']);
       phpCAS::setLang ($board_config['cas_lang']);
       //Uncomment this line if you want debug log
       //phpCAS::setDebug ("/tmp/php_cas.log");
    
       phpCAS::authenticateIfNeeded();

       if (phpCAS::isAuthenticated ())
        {
                $cas_status=CAS_OK;
                $cas_user=phpCAS::getUser();
        }
        else
        {
                $cas_status=CAS_NOK;
        }
}
else
{
        $cas_satus=CAS_NOK;
}

// session id check
if (!empty($HTTP_POST_VARS['sid']) || !empty($HTTP_GET_VARS['sid']))
{
	$sid = (!empty($HTTP_POST_VARS['sid'])) ? $HTTP_POST_VARS['sid'] : $HTTP_GET_VARS['sid'];
}
else
{
	$sid = '';
}

if( isset($HTTP_POST_VARS['login']) || isset($HTTP_GET_VARS['login']) || isset($HTTP_POST_VARS['logout']) || isset($HTTP_GET_VARS['logout']) || ntlm_check() || ($cas_status == CAS_OK))
{
	if( ( isset($HTTP_POST_VARS['login']) || isset($HTTP_GET_VARS['login']) || ntlm_check() ) && !$userdata['session_logged_in'] || ($cas_status == CAS_OK) && !$userdata['session_logged_in'])
	{
	        if ($cas_status == CAS_OK)
                {
                        $username = phpbb_clean_username ($cas_user);
                }
                else
                {     
		   if (ntlm_check())
		  {
		    // Esup Add phpbb_clean_username
			$username = phpbb_clean_username (ntlm_get_user());
		  }
	        else 
		        $username = isset($HTTP_POST_VARS['username']) ? phpbb_clean_username($HTTP_POST_VARS['username']) : '';
		}
		$password = isset($HTTP_POST_VARS['password']) ? $HTTP_POST_VARS['password'] : '';

		$sql = "SELECT user_id, username, user_password, user_active, user_level, user_type  			   FROM " . USERS_TABLE . "
			WHERE username = '" . str_replace("\\'", "''", $username) . "'";
		if ( !($result = $db->sql_query($sql)) )
		{
			message_die(GENERAL_ERROR, 'Error in obtaining userdata', '', __LINE__, __FILE__, $sql);
		}

		$row = $db->sql_fetchrow($result);
		if ( $board_config['auth_mode'] == 'ldap' && $row['user_type'] !== User_Type_phpBB) {
			if ($cas_status != CAS_OK)
                                $ldap_auth_result = ldap_auth($username, $password);
                        else
                                $ldap_auth_result = LDAP_AUTH_OK;			
		}
		else {
			$ldap_auth_result = false;
		}

		if ( $row == false && $board_config['auth_mode'] == 'ldap' && $ldap_auth_result == LDAP_AUTH_OK ) {
				add_ldap_user($username);
				if ( !($result = $db->sql_query($sql)) )
				{
					message_die(GENERAL_ERROR, 'Error in obtaining userdata', '', __LINE__, __FILE__, $sql);
				}
				$row = $db->sql_fetchrow($result);
		}

		if( $row )
		{
			if( $row['user_level'] != ADMIN && $board_config['board_disable'] )
			{
				redirect(append_sid("index.$phpEx", true));
			}
			else
			{
				if(( (($row['user_type'] == User_Type_Both || $row['user_type'] == User_Type_LDAP) && ($ldap_auth_result == LDAP_AUTH_OK || ($ldap_auth_result == LDAP_INVALID_USERNAME && md5($password) == $row['user_password']))) 
					|| (md5($password) == $row['user_password'] && (($board_config['auth_mode'] == 'phpbb' && $row['user_type'] == User_Type_Both) || $row['user_type'] == User_Type_phpBB))) && $row['user_active'] ) //**
				{
					if ($board_config['auth_mode'] == 'ldap' && $ldap_auth_result == LDAP_AUTH_OK && $board_config['ldap_group_sync'] == 1) {
						ldapUpdateGroups($username);
					}
					$autologin = ( isset($HTTP_POST_VARS['autologin']) ) ? TRUE : 0;

					$session_id = session_begin($row['user_id'], $user_ip, PAGE_INDEX, FALSE, $autologin);

					if( $session_id )
					{
						$url = ( !empty($HTTP_POST_VARS['redirect']) ) ? str_replace('&amp;', '&', htmlspecialchars($HTTP_POST_VARS['redirect'])) : "index.$phpEx";
						redirect(append_sid($url, true));
					}
					else
					{
						message_die(CRITICAL_ERROR, "Couldn't start session : login", "", __LINE__, __FILE__);
					}
				}
				else
				{
					$redirect = ( !empty($HTTP_POST_VARS['redirect']) ) ? str_replace('&amp;', '&', htmlspecialchars($HTTP_POST_VARS['redirect'])) : '';
					$redirect = str_replace('?', '&', $redirect);

					if (strstr(urldecode($redirect), "\n") || strstr(urldecode($redirect), "\r"))
					{
						message_die(GENERAL_ERROR, 'Tried to redirect to potentially insecure url.');
					}

					$template->assign_vars(array(
						'META' => "<meta http-equiv=\"refresh\" content=\"3;url=login.$phpEx?redirect=$redirect\">")
					);

					$message = $lang['Error_login'] . '<br /><br />' . sprintf($lang['Click_return_login'], "<a href=\"login.$phpEx?redirect=$redirect\">", '</a>') . '<br /><br />' .  sprintf($lang['Click_return_index'], '<a href="' . append_sid("index.$phpEx") . '">', '</a>');

					message_die(GENERAL_MESSAGE, $message);
				}
			}
		}
		else
		{
			$redirect = ( !empty($HTTP_POST_VARS['redirect']) ) ? str_replace('&amp;', '&', htmlspecialchars($HTTP_POST_VARS['redirect'])) : "";
			$redirect = str_replace("?", "&", $redirect);

			if (strstr(urldecode($redirect), "\n") || strstr(urldecode($redirect), "\r"))
			{
				message_die(GENERAL_ERROR, 'Tried to redirect to potentially insecure url.');
			}

			$template->assign_vars(array(
				'META' => "<meta http-equiv=\"refresh\" content=\"3;url=login.$phpEx?redirect=$redirect\">")
			);

			$message = $lang['Error_login'] . '<br /><br />' . sprintf($lang['Click_return_login'], "<a href=\"login.$phpEx?redirect=$redirect\">", '</a>') . '<br /><br />' .  sprintf($lang['Click_return_index'], '<a href="' . append_sid("index.$phpEx") . '">', '</a>');

			message_die(GENERAL_MESSAGE, $message);
		}
	}
	else if( ( isset($HTTP_GET_VARS['logout']) || isset($HTTP_POST_VARS['logout']) ) && $userdata['session_logged_in'] )
	//Logout
	{
		if( $userdata['session_logged_in'] )
		{
			session_end($userdata['session_id'], $userdata['user_id']);
		}
                if ($cas_status == CAS_OK)
                {
                        {
                                session_unset();                   // supprime la session CAS
                                $_GET['ticket']='';                // supprime le ticket
                                $CAS = new CASClient(CAS_VERSION_2_0,TRUE,$board_config['cas_hostname'],(int) $board_config['cas_port'],$board_config['cas_uri']);// objet CAS en mode proxy
                                $cas_url = $CAS->getServerLogoutURL();
                                $cas_url.="?service=http://".$board_config['server_name'].":".$board_config['server_port'].$board_config['script_path'].append_sid ("index.$phpEx", true);
                                header('Location: '.$cas_url);         // redirige vers le logout CAS 
                                $redirect=$cas_url;
                                exit;
                        }
                        // FIXME: The phpCAS logout doesn't support redirection
                        // phpCAS::logout ();
                }

		if (!empty($HTTP_POST_VARS['redirect']) || !empty($HTTP_GET_VARS['redirect']))
		{
			$url = (!empty($HTTP_POST_VARS['redirect'])) ? htmlspecialchars($HTTP_POST_VARS['redirect']) : htmlspecialchars($HTTP_GET_VARS['redirect']);
			$url = str_replace('&amp;', '&', $url);
			redirect(append_sid($url, true));
		}
		else
		{
		        if (ntlm_check())
			  message_die(GENERAL_MESSAGE, "You have been logged out <BR><BR> Click <A HREF=login.$phpEx>Here</A> to login again. <BR><BR>Click <A HREF=index.$phpEx>Here</A> to return the the forum index.");
			redirect(append_sid("index.$phpEx", true));
		}
	}
	else
	{
		$url = ( !empty($HTTP_POST_VARS['redirect']) ) ? str_replace('&amp;', '&', htmlspecialchars($HTTP_POST_VARS['redirect'])) : "index.$phpEx";
		redirect(append_sid($url, true));
	}
}
else
{  
	if ($board_config['cas_use'])
        {
            redirect(append_sid("index.$phpEx", true));
        }
        else
        {
	//
	// Do a full login page dohickey if
	// user not already logged in
	//
	if( !$userdata['session_logged_in'] )
	{
		$page_title = $lang['Login'];
		include($phpbb_root_path . 'includes/page_header.'.$phpEx);

		$template->set_filenames(array(
			'body' => 'login_body.tpl')
		);

		if( isset($HTTP_POST_VARS['redirect']) || isset($HTTP_GET_VARS['redirect']) )
		{
			$forward_to = $HTTP_SERVER_VARS['QUERY_STRING'];

			if( preg_match("/^redirect=([a-z0-9\.#\/\?&=\+\-_]+)/si", $forward_to, $forward_matches) )
			{
				$forward_to = ( !empty($forward_matches[3]) ) ? $forward_matches[3] : $forward_matches[1];
				$forward_match = explode('&', $forward_to);

				if(count($forward_match) > 1)
				{
					$forward_page = '';

					for($i = 1; $i < count($forward_match); $i++)
					{
						if( !ereg("sid=", $forward_match[$i]) )
						{
							if( $forward_page != '' )
							{
								$forward_page .= '&';
							}
							$forward_page .= $forward_match[$i];
						}
					}
					$forward_page = $forward_match[0] . '?' . $forward_page;
				}
				else
				{
					$forward_page = $forward_match[0];
				}
			}
		}
		else
		{
			$forward_page = '';
		}

		$username = ( $userdata['user_id'] != ANONYMOUS ) ? $userdata['username'] : '';

		$s_hidden_fields = '<input type="hidden" name="redirect" value="' . $forward_page . '" />';

		make_jumpbox('viewforum.'.$phpEx, $forum_id);
		$template->assign_vars(array(
			'USERNAME' => $username,

			'L_ENTER_PASSWORD' => $lang['Enter_password'],
			'L_SEND_PASSWORD' => $lang['Forgotten_password'],

			'U_SEND_PASSWORD' => append_sid("profile.$phpEx?mode=sendpassword"),

			'S_HIDDEN_FIELDS' => $s_hidden_fields)
		);

		$template->pparse('body');

		include($phpbb_root_path . 'includes/page_tail.'.$phpEx);
	}
	else
	{
		redirect(append_sid("index.$phpEx", true));
	}

}

}

?>
