/*
   
 ESUP-portail is a french academic project developed under the GPL (General Public License)
 augmented according to the following :
 
 A binary or source file developped by ESUP-portail can be used or compiled with products under Apache license.
 
 The official english text of the GPL can be found here : http://www.gnu.org/licenses/gpl.html .
 
 A non official french translation can be found here : http://www.linux-France.org/article/these/gpl.html .
 
 The different kinds of licenses governing the products developed by the Apache
 foundation can be found here : http://www.apache.org/licenses .
 
 It follows that you can as well as use download contents as well modify and redistribute
 them provided you respect the GPL terms.
 
 Downloading and using such contents do not provide any guaranty.
 
 Be sure that you have well understood the terms of the license before using the contents it covers.
 
 The ESUP-portail distribution includes the following distributions :
 
 * UPortal :
 software developed by JA-SIG (Java Architecture - Special Interest Group)
 You can find the license page here : http://mis105.udel.edu/ja-sig/uportal/license.html
 
 * CAS :
 SSO solution developed by Yale University
 You can find the project page here : http://www.yale.edu/tp/auth
 
 * Cocoon :
 XML framework distributed by the Apache foundation under Apache license;
 Please find the full text here : http://cocoon.apache.org/2.1/license.html
 
 * Mod_dav:
 A DAV module for Apache web server
 You can find the project page here : http://www.webdav.org/mod_dav
 
 * IMP :
 webmail from Horde application framework
 You can find the project page here : http://www.horde.org
*/
/*
 Ce pakage permet d'afficher un compte rendu rapide du nombre de mail nons lus
parmis tous les dossiers de votre boite imap
// Classes: CImap 
*/
package org.esupportail.portal.channels.CImap;

import java.util.*;
import javax.mail.*;
import org.esupportail.portal.utils.*;  
import org.esupportail.portal.utils.CASExceptions.*;
import org.jasig.portal.*;
import org.jasig.portal.security.*;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jasig.portal.utils.*; 
import org.xml.sax.*;

import org.jasig.portal.security.provider.*;

public class CImap
    implements IChannel, ICacheable {
  
    
  private static final Log log = LogFactory.getLog(CImap.class);

  /*****************************/
  /*Variables de configuration*/

  /*fichier de configuration*/
  private final static String configFilePath =
      "/properties/channels/org_esup/CImap/CImap.xml"; 

  /*feuille ssl*/
  private final static String xslLocation = "CImap.ssl";

  /*le cache*/
  private final static int cacheDefaultTimeOut = 120; // en secondes
  private static int cacheTimeOut = 0; // en secondes

  /*Le mode d'affichage*/
  private final static String modeApercu = "A";
  private final static String modeDetail = "D";
  private static String displayDefaultMode = modeApercu;

  /*****************************/
  /*Variables de programmation */

  private ChannelStaticData staticData = null;
  private ChannelRuntimeData runtimeData = null;
  private ChannelRuntimeProperties runtimeProperties = null;

  /*Le mode d'affichage*/
  private String typeAff = null;

  /*Les erreurs*/
  private final static int NO_ERROR = 0;
  private final static int ERROR_CONNEXION = -1;
  private final static int ERROR_STORE = -2;
  private final static int ERROR_SERVER_NOT_FOUND = -3;
  private final static int ERROR_OPEN_FOLDER = -4;
  private final static int ERROR_NO_INBOX = -5;
  private final static int ERROR_FOLDER_NOT_FOUND = -6;
  private final static int ERROR_INBOX_FOLDER = -7;
  private final static int ERROR_CLOSE_CONNEXION = -8;
  private final static int ERROR_PT = -9;
  private final static int ERROR_SERVANT = -10;

  /*login et mot de passe*/
  private String userId = null;
  private String userPass = null;

  /*Objet contenant le fichier de config*/
  private static CImapConfig config = null;

  /*authentification via cas*/
  private boolean useCasAuth = true;

  /*Chaine de caractre  afficher*/
  private String xml = null;
  /*chaine de caratres gnre par le contenu de tous lesdossiers  afficher*/
  private String xmlDossiers = "";

  /*nombre des dossiers*/
  private int nbDossiers = 0;

  private CImapServeur serverFound;
  
	private IServant servant;
	private boolean servantAvailable = false;

  private Store store = null;

  private boolean forceRefresh = false;

  private XMLReader configFile = null;

  private int errorCode = NO_ERROR;
  
  static {
    config = new CImapConfig(configFilePath);
    config.init();
  }

  /*Constructeur*/
  public CImap() {
  }

  /**********************************************************************************/

  /** Returns channel runtime properties
   * @return handle to runtime properties
   */
  public ChannelRuntimeProperties getRuntimeProperties() {
    return new ChannelRuntimeProperties();
  }

  /** Processes layout-level events coming from the portal
   * @param ev a portal layout event
   */
  public void receiveEvent(PortalEvent ev) {
  }

  /** Receive static channel data from the portal
   * @param sd static channel data
   */
  public void setStaticData(ChannelStaticData sd) {
    this.staticData = sd;

    /*Rcupration de dure de valididt du cache*/
    String cacheTmp = sd.getParameter("cacheTimeOut");
    if (cacheTmp != null)
      cacheTimeOut = Integer.getInteger(cacheTmp).intValue();
    else {
      cacheTimeOut = cacheDefaultTimeOut;
    }

    /*Rcupration de dure de valididt du cache*/
    String displayTmp = sd.getParameter("defaultDisplay");
    if (displayTmp != null) {
      if ( (displayTmp.compareTo(modeApercu) == 0) ||
          (displayTmp.compareTo(modeDetail) == 0))
        displayDefaultMode = displayTmp;
    }

    typeAff = displayDefaultMode;

    /*Rcupration du type d'authentification souhait
      ( pass en parametre lors de l'instanciation) :*/
    /*si N  ou n  alors authentification Login/mdp UPortal
      sinon authentification CAS*/

    String recupAuth = sd.getParameter("useCasAuth");
    if (recupAuth != null) {
      if ( (recupAuth.charAt(0) == 'N') || (recupAuth.charAt(0) == 'n'))
        useCasAuth = false;
    }

        /*Rcupration de la cl du serveur pass en parametre lors de l'instanciation*/
    String ServerKey = sd.getParameter("serverKey");
    if (log.isDebugEnabled()){
        log.debug("CImap::renderXML() : serverKey : " +ServerKey);
    }
    /*Rcupration du serveur allou*/
    serverFound = config.getMyServer(staticData.getPerson(),
                                       ServerKey);

    userId = (String) staticData.getPerson().getAttribute(IPerson.USERNAME);
    if (serverFound != null) {
      userPass = GetCredential();
    }
  }

  /** Receives channel runtime data from the portal and processes actions
       * passed to it.  The names of these parameters are entirely up to the channel.
   * @param rd handle to channel runtime data
   */
  public void setRuntimeData(ChannelRuntimeData rd) throws PortalException {
    this.runtimeData = rd;
     
    errorCode = NO_ERROR;
    
    
    /*Prise en compte du mode servant*/
    if ( (!servantAvailable)
		     && (rd.getParameter("sendMessage")!=null) 
		     && (config.isAllowSendMail()) 
		     
		   ){
		    servantAvailable = true;
		}
		
		
	if (servantAvailable){	
	    /*Instanciation du servant*/
	    try {
            Class servantClass = Class.forName(config.getClassSendMail());
            Object servantObj = servantClass.newInstance();
            servant = (IServant)servantObj;
            
            servant.setStaticData(staticData);
            servant.setRuntimeData(runtimeData);
            
            if (servant.isFinished()) {
                servantAvailable=false;
            }
        } catch (ClassNotFoundException e) {
  	      	forceRefresh = true;
            servantAvailable=false;
            errorCode = ERROR_SERVANT;
            log.error("CImap::setRuntimeData:ClassNotFoundException : "+e.getMessage());
        } catch (InstantiationException e) {
  	      	forceRefresh = true;
            servantAvailable=false;
            errorCode = ERROR_SERVANT;
            log.error("CImap::setRuntimeData:InstantiationException : "+e.getMessage());
        } catch (IllegalAccessException e) {
  	      	forceRefresh = true;
            servantAvailable=false;
            errorCode = ERROR_SERVANT;
            log.error("CImap::setRuntimeData:IllegalAccessException : "+e.getMessage());
        } catch (Exception e) {
  	      	forceRefresh = true;
            servantAvailable=false;
            errorCode = ERROR_SERVANT;
            log.error("CImap::setRuntimeData:Exception : "+e.getMessage());
        }
	    
	}
    else{
	    forceRefresh = false;
	
	    /*Teste si il y a eu un changement d'affichage dans ce canal*/
	    if (runtimeData.getParameter("changeAffichage") != null) {
	      /*force le rafraichissement*/
	      forceRefresh = true;
	      if (typeAff == modeApercu)
	        typeAff = modeDetail;
	      else
	        typeAff = modeApercu;
	    }
	
	    if (runtimeData.getParameter("actuAffichage") != null) {
	      /*force le rafraichissement*/
	      forceRefresh = true;
	    }
    }
	
    if (runtimeData.getParameter("relanceLeCanal") != null) {
      /*Le canal tait en erreur*/
      forceRefresh = true;
    }	
	
	
	
	

  }

  /** Output channel content to the portal
   * @param out a sax document handler
   */
  public void renderXML(ContentHandler out) throws PortalException {
    
      
      if ( (servantAvailable)  && (errorCode==NO_ERROR) ){
          servant.renderXML(out);
      }
      else{ 
      
		    this.xml = null;
		
		    /*chaine de caratre gnre par le contenu de tous les dossiers  afficher*/
		    this.xmlDossiers = null;
		
		    this.xml = "<?xml version=\"1.0\"?><ROOT>";
		
		    
		
		    if (serverFound != null) {
		      int errorSav = errorCode;
		      errorCode = this.checkMail();
		      if (errorCode==NO_ERROR){
		          errorCode = errorSav;
		      }
		    }
		    else {
		      errorCode = ERROR_SERVER_NOT_FOUND;
		    }
		
		    switch (errorCode) {
		
		      /*CAS D'ERREUR*/
		      case ERROR_OPEN_FOLDER:
		        this.xml +=
		            "<error>Ouverture d'un dossier impossible.</error>";
		        break;
		      case ERROR_CONNEXION:
		        this.xml += "<error>Erreur de connection au '" +
		            serverFound.getDescription() + "'.</error>";
		        break;
		      case ERROR_STORE:
		        this.xml +=
		            "<error>Une erreur s'est produite lors de l'ouverture de la connexion.</error>";
		        break;
		      case ERROR_SERVER_NOT_FOUND:
		        this.xml += "<error>Aucun serveur n'a t trouv.</error>";
		        break;
		      case ERROR_NO_INBOX:
		        this.xml += "<error>Aucune bote n'a t trouve.</error>"; 
		        break;
		      case ERROR_FOLDER_NOT_FOUND:
		        this.xml +=
		            "<error>Un dossier n'a pas t trouve.</error>"; 
		        break;
		      case ERROR_INBOX_FOLDER:
		        this.xml +=
		            "<error>Impossible de lire le dossier racine.</error>";
		        break;
		      case ERROR_CLOSE_CONNEXION:
		        this.xml +=
		            "<error>Une erreur s'est produite lors de la fermeture de la connexion.</error>";
		        break;
		      case ERROR_SERVANT:
			        this.xml +=
			            "<error>Impossible d'acceder  l'interface d'envoi de mail.</error>";
			        break;
		
		      /*CAS DE SATISFACTION*/
		      case NO_ERROR:
		        if ( (this.nbDossiers > 0) && (this.xmlDossiers != "")) {
		          this.xmlDossiers += "<titre>";
		          this.xmlDossiers += serverFound.getDescription();
		          this.xmlDossiers += "</titre>";
		
		          this.xmlDossiers += "<dossiers>" + this.xmlDossiers;
		          this.xmlDossiers += "</dossiers>";
		        }
		        else {
		          this.xmlDossiers = "";
		        }
		        this.xml += this.xmlDossiers;
		        break;
		
		    }
		
		    this.xml += "</ROOT>";
		
	
		    XSLT xslt = new XSLT(this);
		    xslt.setXML(this.xml);
		    xslt.setXSL(xslLocation, "main", runtimeData.getBrowserInfo());
		    
		    /*Envoie des paramtres au fichierXSL*/
		    xslt.setStylesheetParameter("baseActionURL", runtimeData.getBaseActionURL());
		    if (config.isAllowSendMail())
		        xslt.setStylesheetParameter("allowSendMail", "true");
		    if (typeAff.equals(modeDetail)) {
		      xslt.setStylesheetParameter("captionBtn", "Fermer le dtail");
		    }
		    else {
		      xslt.setStylesheetParameter("captionBtn", "Voir le dtail");
		    }
		
		    xslt.setTarget(out);
		    xslt.transform();
      }
  }

  public int checkMail() {

    Folder myFolder = null;
    /*Ouvre la connection tente 3 connectionsW*/
    int res = lanceConnection(3);

    if (res == ERROR_CONNEXION) {
      fermeConnection();
      return (ERROR_CONNEXION);
    }

    /*recherche du rpertoire INBOX*/
    try {
      myFolder = store.getFolder(serverFound.getBoiteParDefaut());
    }
    catch (MessagingException e) {
        log.error("CImap::checkMail() : l'utilisateur n'a pas de boite INBOX : " +
                e.toString());
      fermeConnection();
      return (ERROR_NO_INBOX);
    }
    catch (java.lang.IllegalStateException e) {
        log.error("CImap::checkMail() : l'utilisateur n'a pas de boite INBOX : " +
                e.toString());
      fermeConnection();
      return (ERROR_NO_INBOX);
    }
    
    /*Ouverture du sossier RACINE*/
    res = scanMail(myFolder);
    if (res != NO_ERROR){
	fermeConnection();
      return (res);
    }

    Folder listf[];
    if (typeAff.equals(modeDetail)) {

      try {
        listf = myFolder.list("*");
      }
      catch (FolderNotFoundException e) {
        log.error("CImap::checkMail() : ouverture du dossier " +
                  myFolder.getFullName() + " impossible : " +
                  e.toString());
        fermeConnection();
        return (ERROR_FOLDER_NOT_FOUND);
      }
      catch (MessagingException e) {
          log.error("CImap::checkMail() : impossible de compter le nombre de mail total de " +
                  myFolder.getFullName() + " : " +
                  e.toString());
        fermeConnection();
        return (ERROR_OPEN_FOLDER);
      }

      nbDossiers = listf.length;

      for (int i = 0; i < listf.length; i++) {
		res = scanMail(listf[i]);
        if (res != NO_ERROR){
          fermeConnection();
          return (res);
        }
      }
    }

    /*ferme la connection*/
    fermeConnection();
    return (NO_ERROR);

  }

  public int scanMail(Folder myFolder) {
    String url = null;
    String nameFolder;
    int niv = 0;
    
    /*Rcupration des informations du dossier */
    this.nbDossiers = 0;
    this.xmlDossiers += "<dossier>";
    this.xmlDossiers += "<vrainom>" + myFolder.getFullName() + "</vrainom>";

    if (myFolder.getFullName().compareTo(serverFound.getBoiteParDefaut()) == 0) {
      nameFolder = serverFound.getAfficheBoiteParDefaut();
    }
    else {
      nameFolder = myFolder.getName();
    }
    this.xmlDossiers += "<nom>" + nameFolder + "</nom>";

    /*Cration du lien pour le webmail*/
    url = serverFound.getLien().replaceAll("%m", myFolder.getFullName());
    url = url.replaceAll(" ", "%20");
    url = url.replaceFirst("%u", userId);
    this.xmlDossiers += "<url>" + url + "</url>";

    /*Compter le nombre de message non lus*/
    try {
      this.xmlDossiers += "<nlus>" + myFolder.getUnreadMessageCount() +
          "</nlus>";
    }
    catch (FolderNotFoundException e) {
        log.error("CImap::scanMail() : dossier " +
                myFolder.getFullName() + " non trouv : " +
                e.toString());

      fermeConnection();
      return (ERROR_FOLDER_NOT_FOUND);
    }
    catch (MessagingException e) {
        log.error("CImap::scanMail() : impossible de compter le nombre de mail non lus de " +
                myFolder.getFullName() + " : " +
                e.toString());
      fermeConnection();
      return (ERROR_OPEN_FOLDER);
    }

    /*Compter le nombre de message total*/
    try {
      this.xmlDossiers += "<total>" + myFolder.getMessageCount() + "</total>";
    }
    catch (FolderNotFoundException e) {
        log.error("CImap::checkMail() : ouverture du dossier " +
                myFolder.getFullName() + " impossible: " +
                e.toString());
      fermeConnection();
      return (ERROR_FOLDER_NOT_FOUND);
    }
    catch (MessagingException e) {
        log.error("CImap::scanMail() : impossible de compter le nombre de mail total de " +
                myFolder.getFullName() + " : " +
                e.toString());
      fermeConnection();
      return (ERROR_OPEN_FOLDER);
    }

    /*Recherche du niveau du dossier (pour le dcallage  l'affichage)*/
    try {
      int index = 0;
      while (index < myFolder.getFullName().length()) {
        if (myFolder.getFullName().charAt(index) ==
            myFolder.getSeparator())
          niv++;
        index++;
      }
      this.xmlDossiers += "<niv>" + niv + "</niv>";
    }
    catch (MessagingException e) {
        log.error("CImap::scanMail() : impossible de voir le niveau de " +
                myFolder.getFullName() + " : " +
                e.toString());
      fermeConnection();
      return (ERROR_OPEN_FOLDER);
    }

    this.xmlDossiers += "</dossier>";
    this.nbDossiers++;


    return (NO_ERROR);
  }

  private int lanceConnection(int retry) {

    /*----------------- initialisation de la connection  ---------------*/
    Session mySession;

    int errorCode = NO_ERROR ;

    if (retry <= 0) {
      /*Nombre d'essais puis*/
        log.error("CImap::lanceConnection() : nombre de tentative de connexion epuise.");
      return (ERROR_CONNEXION);
    }

    Properties props = System.getProperties();

    // cration d'une session
    mySession = Session.getDefaultInstance(props, null);
    mySession.setDebug(false);

    try {
      store = mySession.getStore(serverFound.getProtocole());
    }
    catch (NoSuchProviderException e) {
        log.error("CImap::lanceConnection() : erreur de cration du store : "+ e.toString());
      return (ERROR_STORE);
    }
    
    userPass = GetCredential();
    // Connection
    try {
      store.connect(serverFound.getHost(), serverFound.getPort(), userId,
                     userPass);
    }
    catch (AuthenticationFailedException e) {
        log.error("CImap::lanceConnection() : erreur dans l'authentification ... on relance : "+ e.toString());
      fermeConnection();

      if (retry <= 0) {
        errorCode = ERROR_CONNEXION;
      }
      else {
        errorCode = lanceConnection(retry - 1);
      }

    }
    catch (IllegalStateException e) {
        log.error("CImap::lanceConnection() : store dj connect : "+ e.toString());
    }
    catch (MessagingException e) {
      log.error("CImap::lanceConnection() : erreur inconnue sur le store : "+ e.toString());
      errorCode = ERROR_CONNEXION;
    }

    if ( (errorCode == NO_ERROR) && (log.isDebugEnabled()) ) {
         log.debug("CImap::lanceConnection() : connexion OK ");
    }

    return (errorCode);
  }

  private String GetCredential() {
    userPass = null;
    /*Rcupration d'un PT*/
    if (useCasAuth) {

      try {

	      if ( log.isDebugEnabled() ) {
	           log.debug("CImap::GetCredential() : recherche pt sur " + serverFound.getProtocole()+"://" + serverFound.getHost());
	      }
	      userPass = CAS.get_pt(staticData,
                               serverFound.getProtocole() +
                               "://" +
                               serverFound.getHost(),3,1);
      }
      catch (CASPermException e) {
        log.error("CImap::GetCredential() : CASPermException : " + e.toString());
        return (null);

      }
      catch (CASTempException e) {
          log.error("CImap::GetCredential() : CASTempException : " + e.toString());
        return (null);
      }
      catch (CASGenericException e) {
          log.error("CImap::GetCredential() : CASGenericException : " + e.toString());
        return (null);
      }

    }
    // recuperation du mot de passe dans uportal
    else {
      ISecurityContext ic = staticData.getPerson().getSecurityContext();
      IOpaqueCredentials oc = ic.getOpaqueCredentials();
      if (oc instanceof NotSoOpaqueCredentials) {
        NotSoOpaqueCredentials nsoc = (NotSoOpaqueCredentials) oc;
        userPass = nsoc.getCredentials();
      }

      // If still no password, loop through subcontexts to find cached credentials
      if (userPass == null) {
        Enumeration en = ic.getSubContexts();
        while (en.hasMoreElements()) {
          ISecurityContext sctx = (ISecurityContext) en.nextElement();
          IOpaqueCredentials soc = sctx.getOpaqueCredentials();
          if (soc instanceof NotSoOpaqueCredentials) {
            NotSoOpaqueCredentials nsoc = (NotSoOpaqueCredentials) soc;
            userPass = nsoc.getCredentials();
          }
        }
      }
    }
    if ( log.isDebugEnabled() ) {
        log.debug("CImap::GetCredential() : retourne : " + userPass);
    }
    return (userPass);
  }

  private int fermeConnection() {
    /* -----------------------fermeture de la session ---------*/
    if (store.isConnected()) {
      try {
        //fermeture du store
          if ( log.isDebugEnabled() ) {
              log.debug("CImap::fermeConnection:fermeture du store : " +
                      serverFound.getHost());
          }
        store.close();

      }
      catch (MessagingException e) {
          log.error("CImap::fermeConnection:fermeture du store : " +
                  serverFound.getHost());

        return (ERROR_CLOSE_CONNEXION);

      }
    }
    return (NO_ERROR);
  }

  /******************************************************************************/
  /** Genration d'une cle pour le cache
   * @param
   * @return ChannelCacheKey cle du cache
   */
  public ChannelCacheKey generateKey() {
    ChannelCacheKey k = new ChannelCacheKey();
    StringBuffer sbKey = new StringBuffer(1024);
    sbKey.append(this.getClass().getName() + " : ");
    sbKey.append("userId:").append(staticData.getPerson().getID()).append(", ");
    sbKey.append("stylesheetURI:");
    try {
      String sslURI = ResourceLoader.getResourceAsURLString(this.getClass(),
          xslLocation);
      sbKey.append(XSLT.getStylesheetURI(sslURI, runtimeData.getBrowserInfo()));
    }
    catch (Exception e) {
      sbKey.append("not defined");
    }

    //sbKey.append(this.staticData.getChannelSubscribeId());
    k.setKeyScope(ChannelCacheKey.INSTANCE_KEY_SCOPE);

    k.setKey(sbKey.toString());
    k.setKeyValidity(new Long(System.currentTimeMillis()));
    if ( log.isDebugEnabled() ) {
        log.debug("CImap::generateKey() (id : " +
                this.staticData.getChannelSubscribeId() +
                ") : generateKey :  -> Cle :" + k.getKey());
    }
    
    return k;
  }

  /**
   * put your documentation comment here
   * @param validity
   * @return boolean
   */
  public boolean isCacheValid(Object validity) {
    boolean cacheValid = false;
    
	if (servantAvailable) return (false);
	
	if ( (!servantAvailable) && (servant!=null) && (servant.isFinished()) ) return (false);
	
	if (!forceRefresh) {

      if (validity instanceof Long) {
        Long oldtime = (Long) validity;
        // Si validity  moins de cacheTimeOut secondes le cache est valide
        if (System.currentTimeMillis() - oldtime.longValue() <
            cacheTimeOut * 1000) {
          cacheValid = true;
        }
      }
      
      if ( log.isDebugEnabled() ) {
	      if (cacheValid) {
	          log.debug("CImap::isCacheValid (" +
	                  this.staticData.getChannelSubscribeId() +
	                  ") : isCacheValid -> YES");
	      }
	      else {
	          log.debug("CImap::isCacheValid (" +
                      this.staticData.getChannelSubscribeId() +
                      ") : isCacheValid -> NO");
	      }
      }
    }
    else {

      cacheValid = false;
      forceRefresh = false;
    }

    return cacheValid;
  }

}