/*
   
 ESUP-portail is a french academic project developed under the GPL (General Public License)
 augmented according to the following :
 
 A binary or source file developped by ESUP-portail can be used or compiled with products under Apache license.
 
 The official english text of the GPL can be found here : http://www.gnu.org/licenses/gpl.html .
 
 A non official french translation can be found here : http://www.linux-France.org/article/these/gpl.html .
 
 The different kinds of licenses governing the products developed by the Apache
 foundation can be found here : http://www.apache.org/licenses .
 
 It follows that you can as well as use download contents as well modify and redistribute
 them provided you respect the GPL terms.
 
 Downloading and using such contents do not provide any guaranty.
 
 Be sure that you have well understood the terms of the license before using the contents it covers.
 
 The ESUP-portail distribution includes the following distributions :
 
 * UPortal :
 software developed by JA-SIG (Java Architecture - Special Interest Group)
 You can find the license page here : http://mis105.udel.edu/ja-sig/uportal/license.html
 
 * CAS :
 SSO solution developed by Yale University
 You can find the project page here : http://www.yale.edu/tp/auth
 
 * Cocoon :
 XML framework distributed by the Apache foundation under Apache license;
 Please find the full text here : http://cocoon.apache.org/2.1/license.html
 
 * Mod_dav:
 A DAV module for Apache web server
 You can find the project page here : http://www.webdav.org/mod_dav
 
 * IMP :
 webmail from Horde application framework
 You can find the project page here : http://www.horde.org
*/
/*
 Ce pakage permet d'afficher un compte rendu rapide du nombre de mail nons lus
parmis tous les dossiers de votre boite imap
 Cette classe permet de lire le fichier de configuration et de monter les
objets "serveur" et de faire le lien entre les attributs cls et les serveurs
 Classes: CImapConfig
*/

package org.esupportail.portal.channels.CImap;

import java.util.*;
import java.util.regex.*;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jasig.portal.groups.*;
import org.jasig.portal.security.*;
import org.jasig.portal.services.GroupService;
import org.jasig.portal.utils.*;
import org.w3c.dom.*;
import java.net.URL;
import org.xml.sax.*;
import javax.xml.parsers.DocumentBuilderFactory;

public class CImapConfig {
    private static final Log log = LogFactory.getLog(CImap.class);
    private Document config = null;
  private HashMap listServeur = new HashMap();
  /*liste des atttributs : tab[][0] = nom de l'attribut   */
  /*                       tab[][1] = valeur de l'attribut*/
  /*                       tab[][2] = serveur             */
  private String listAttrib[][] = new String[50][3];
  /*liste des groupes uPortal qui envoyent sur un serveur*/
  private HashMap listGroupConf = new HashMap();

  private String keyOfDefaultServeur;

  private int nbAttrib = 0;
  
  private boolean allowSendMail = false;
  private String classSendMail = null;

  public CImapConfig(String chemin) {

    DocumentBuilderFactory builderFactory;

    try {
      URL url = ResourceLoader.getResourceAsURL(this.getClass(), chemin);
      InputSource inSource = new InputSource(url.toExternalForm());
      builderFactory = DocumentBuilderFactory.newInstance();
      config = builderFactory.newDocumentBuilder().parse(inSource);

    }
    catch (org.jasig.portal.ResourceMissingException rme) {
      throw new RuntimeException(
          "CImapConfig::CImapConfig() :"
          + "Impossible de lire le fichier de configuration : "
          + chemin);
    }
    catch (java.io.IOException rme) {
      throw new RuntimeException(
          "CImapConfig::CImapConfig() : " + rme.getMessage());
    }

    catch (javax.xml.parsers.ParserConfigurationException rme) {
      throw new RuntimeException(
          "CImapConfig::CImapConfig() : " + rme.getMessage());
    }

    catch (org.xml.sax.SAXException rme) {
      throw new RuntimeException(
          "CImapConfig::CImapConfig() : " + rme.getMessage());
    }
  }

  protected void init() {

    config.normalize();

    Element root = config.getDocumentElement();
    String[] categList = new String[2];

    classSendMail = root.getAttribute("classSendMail");
    if (classSendMail!=null){
        allowSendMail = true;
    }
    /*TAG DE 1er Niv*/
    categList[0] = "Servers";
    categList[1] = "Attachements";

    for (int i = 0; i < categList.length; i++) {
      NodeList monNoeud = root.getElementsByTagName(categList[i]);
      if (monNoeud.getLength() > 0) {
        for (int j = 0; j < monNoeud.getLength(); j++) {

          Element conf = (Element) monNoeud.item(j);
          Node child = conf.getFirstChild();

          while (child != null) {
            if (child.getNodeType() == Node.ELEMENT_NODE) {
              Element c = (Element) child;
              //c.normalize();
              getTagConf(c);
            }
            child = child.getNextSibling();
          }
        }
      }
      else {
        throw new RuntimeException(
            "CImapConfig::init() : tag <Servers> introuvable");
      }

    }
  }

  public void getTagConf(Element monNoeud) {

    /*TAG FEUILLE*/
    if (monNoeud.getNodeName().equals("Server")) {

      /*rcupration des attributs*/
      String key = monNoeud.getAttribute("key");
      String def = monNoeud.getAttribute("default");
      String host = monNoeud.getAttribute("hostname");
      String port = monNoeud.getAttribute("port");
      String protoc = monNoeud.getAttribute("protocole");
      String desc = monNoeud.getAttribute("description");
      String folder = monNoeud.getAttribute("inboxName");
      String folderName = monNoeud.getAttribute("inboxLocalName");
      String url = monNoeud.getAttribute("urlWebmail");

      if (def.equals("1")) {
        keyOfDefaultServeur = key;
      }

      CImapServeur serveurTemp = new CImapServeur();
      serveurTemp.setHost(host);
      serveurTemp.setPort(Integer.parseInt(port));
      serveurTemp.setDescription(desc);
      serveurTemp.setBoiteParDefaut(folder);
      serveurTemp.setAfficheBoiteParDefaut(folderName);
      serveurTemp.setProtocole(protoc);
      serveurTemp.setLien(url);

     listServeur.put(key.toLowerCase(), serveurTemp);

    }
    else if (monNoeud.getNodeName().equals("Group")) {
      Node fc = null;
      /*attributs*/
      String key = monNoeud.getAttribute("key");
      String servKey = monNoeud.getAttribute("serverKey");
      String desc = monNoeud.getAttribute("description");
      listGroupConf.put(key.toLowerCase(), servKey);
      
    }
    else if (monNoeud.getNodeName().equals("Attribut")) {

      Node fc = null;
      String key = monNoeud.getAttribute("key");
      String servKey = monNoeud.getAttribute("serverKey");
      String desc = monNoeud.getAttribute("description");
      String val = monNoeud.getAttribute("value");

      listAttrib[nbAttrib][0] = key;
      listAttrib[nbAttrib][1] = val;
      listAttrib[nbAttrib][2] = servKey;

      nbAttrib++;

    }

  }

  /***************************************************************************/
  public CImapServeur getMyServer(IPerson connecte, String keyLocal) {
    CImapServeur server = null;

    String res = null;

    boolean cherche = true;

    /***********************************/
    /*Regarde le nom court du serveur*/
    if (keyLocal != null) {
		server = getMyServerByKey(keyLocal);

      if (server != null)
        cherche = false;
    }

    /***********************************/
    /*regarde les appartenances aux groupes UPortal*/
    if (cherche) {
      server = getMyServerByGroup(connecte);
      if (server != null)
        cherche = false;
    }

    /***********************************/
    /*regarde la possession d'attributs dcrits en config*/
    if (cherche) {

      server = getMyServerByAttribut(connecte);

      if (server != null)
        cherche = false;
    }

    /***********************************/
    if ( (cherche) && (keyOfDefaultServeur != null)) {

      /*serveur par defaut*/
      server = getMyServerByKey(keyOfDefaultServeur);
      if (server != null) {
        cherche = false;
      }

    }

    /***********************************/
    if (server == null) {
        log.info("CImapConfig::getMyServer() : " +
        	"ATTENTION AUCUN SERVEUR N'A ETE TROUVE !!!!!!!!!!!!");
    }

    /*retourne le serveur trouv*/
    return (server);

  }

  /*******************************************************/
  /*******************************************************/
  /*******************************************************/
  /*Fonctions de recherche d'un serveur*/

  /*******************************************************/
  /*recherche par la cl*/
  public CImapServeur getMyServerByKey(String keyLocal) {
    CImapServeur res = null;

    if (keyLocal!=null){
      res = (CImapServeur) listServeur.get(keyLocal.toLowerCase());
      if (log.isDebugEnabled()){
      	log.debug("CImapConfig::getMyServerByKey() : serveur trouve : " +
          res.getDescription());
      }

    }
    return (res);

  }

  /*******************************************************/
  /*recherche par l'appartenance  un grupe UPortal*/
  public CImapServeur getMyServerByGroup(IPerson connecte) {
    
    if (log.isDebugEnabled()){
        log.debug("CImapConfig::getMyServerByGroup() : recherche selon le groupe");
    }
    
    boolean cherche = true;
    CImapServeur res = null;

    String[] names = new String[] {
        "Containing Groups"};
    String r = null;
    try {
      StringBuffer buf = new StringBuffer();
      /*Recherche des groupes desquels fait partie la personne connecte*/
      IGroupMember gm = GroupService.getGroupMember(connecte.
          getEntityIdentifier());
      Iterator i = gm.getAllContainingGroups();//;getContainingGroups();
    
      while ( (cherche) && (i.hasNext())) {
        IEntityGroup g = (IEntityGroup) i.next();
        
        if (log.isDebugEnabled()){
            log.debug("CImapConfig::getMyServerByGroup() : teste  le groupe " + g.getName());
        }

        if (listGroupConf.get(g.getKey().toLowerCase()) != null) {
            /*Si le groupe est dfini dans le fichier de config alors
             on garde le serveur associe*/
            if (log.isDebugEnabled()){
                log.debug("CImapConfig::getMyServerByGroup() : teste  le groupe " + g.getName() +" ("+ g.getKey()+")");
            }
            res = getMyServerByKey( (String) listGroupConf.get(g.getKey().toLowerCase()));
            if (res != null) {
                cherche = false;
            }
        }
       }
    }
    catch (Exception e) {
      log.error("CImapConfig::getMyServerByGroup() : erreur lors de la recherche d'un groupe");
    }
    return (res);
  }

  /*******************************************************/
  /*recherche selon les attributs entrs en config*/
  public CImapServeur getMyServerByAttribut(IPerson connecte) {

    boolean cherche = true;
    CImapServeur res = null;

    
    /*compare les attributs de la config  ceux de la personne*/
    int i = 0;
    while ( (i < nbAttrib) && (cherche)) {

      String valAttrib = null;
      if (listAttrib[i][0]!=null)valAttrib = (String) connecte.getAttribute(listAttrib[i][0]);
     
      if (valAttrib != null) {
        
        if (Pattern.matches(listAttrib[i][1], valAttrib)) {

          res = getMyServerByKey(listAttrib[i][2]);
          if (res != null) {
            cherche = false;
          }
        }

      }
      i++;
    }
    return (res);
  }

/**
 * @return Returns the allowSendMail.
 */
public boolean isAllowSendMail() {
    return allowSendMail;
}
/**
 * @return Returns the allowSendMail.
 */
public String getClassSendMail() {
    return classSendMail;
}

}