<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" version="1.0">
   <xsl:output method="html" indent="no" />

<!--  BOUCLE DE DECALAGE DES DOSSIERS   -->
   <xsl:template name="for.loop">
      <xsl:param name="i" />

      <xsl:param name="count" />

      <xsl:if test="$i &lt;= $count">&#160;&#160;&#160;
      </xsl:if>

      <xsl:if test="$i &lt;= $count">
         <xsl:call-template name="for.loop">
            <xsl:with-param name="i">
            <xsl:value-of select="$i + 1" />

            </xsl:with-param>

            <xsl:with-param name="count">
               <xsl:value-of select="$count" />
            </xsl:with-param>
         </xsl:call-template>
      </xsl:if>
   </xsl:template>

   <xsl:param name="baseActionURL">donne par le code</xsl:param>

   <xsl:param name="captionBtn">donne par le code</xsl:param>

   <xsl:param name="allowSendMail">false</xsl:param>


<!--  TEMPLATE DES DOSSIERS   -->
   <xsl:template match="ROOT">
   <xsl:choose>
         <xsl:when test="error!=''">
            <xsl:value-of select="error" />
         </xsl:when>
         
         <xsl:otherwise>
          <form action="{$baseActionURL}#monCanal" method="POST">
             <h3><xsl:value-of select="titre" /></h3>
             <xsl:apply-templates select="dossiers" />

             <xsl:if test="$allowSendMail='true'">
             	<INPUT class="uportal-button" TYPE="SUBMIT" NAME="sendMessage" VALUE="Envoyer un message"/>
             </xsl:if>

             <INPUT class="uportal-button" TYPE="SUBMIT" NAME="changeAffichage" VALUE="{$captionBtn}"/>
             
             <INPUT class="uportal-button" TYPE="SUBMIT" NAME="actuAffichage" VALUE="Actualiser"/>
          </form>
         </xsl:otherwise>
         
      </xsl:choose>


   </xsl:template>

<!--  TEMPLATE DES DOSSIERS   -->
   <xsl:template match="dossiers">
      <TABLE border="1">
         <TR>
            <TD class="uportal-channel-text">Dossier</TD>

            <TD class="uportal-channel-text">Nombre de mail(s) 
            <BR />

            non lu(s)</TD>

            <TD class="uportal-channel-text">Nombre total 
            <BR />

            de mail(s)</TD>
         </TR>

         <xsl:apply-templates select="dossier" />
      </TABLE>

      <BR />
   </xsl:template>

<!--  TEMPLATE D'UN DOSSIER   -->
   <xsl:template match="dossier">
      <xsl:variable name="classe">
         <xsl:choose>
            <xsl:when test="nlus &gt; 0">uportal-background-light</xsl:when>

            <xsl:otherwise>uportal-channel-text</xsl:otherwise>
         </xsl:choose>
      </xsl:variable>

      <TR>
         <TD class="{$classe}">
            <xsl:call-template name="for.loop">
               <xsl:with-param name="i">1</xsl:with-param>

               <xsl:with-param name="count">
                  <xsl:value-of select="niv" />
               </xsl:with-param>
            </xsl:call-template>
           <a class="uportal-navigation-category" href="{url}" target="_blank" onMouseover="window.status='Ouvrir le webmail sur : {nom}';return true;" onMouseout="window.status='';return true;">
             <xsl:value-of select="nom" />
            </a>
         </TD>
         <TD class="{$classe}">
            <xsl:value-of select="nlus" />
         </TD>

         <TD class="{$classe}">
            <xsl:value-of select="total" />
         </TD>
      </TR>

      <xsl:apply-templates select="dossier" />
   </xsl:template>
</xsl:stylesheet>