package org.esupportail.portal.channels.CInfos;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.esupportail.portal.channels.CInfos.beans.ServerInfo;
import org.esupportail.portal.channels.CInfos.config.Config;
import org.esupportail.portal.channels.CInfos.xml.InfosCollector;
import org.jasig.portal.ChannelRuntimeData;
import org.jasig.portal.ChannelRuntimeProperties;
import org.jasig.portal.ChannelStaticData;
import org.jasig.portal.IChannel;
import org.jasig.portal.PortalEvent;
import org.jasig.portal.PortalException;
import org.jasig.portal.utils.XSLT;
import org.xml.sax.ContentHandler;

/**
 * CInfos<br>
 * <br>
 * Description<br>
 * <br>
 * (c)Copyright <a href="http://www.esup-portail.org">ESup-Portail 2004</a><br>
 * @author <a href="mailto:mathieu.larchet@univ-nancy2.fr">Mathieu Larchet</a>
 * @version $Revision: 1.0$
 * 
 */
public class CInfos implements IChannel {

    protected static Log log = LogFactory.getLog(CInfos.class);
    
    private ChannelStaticData staticData = null;
    private ChannelRuntimeData runtimeData = null;
    
    private List servers = null;
    private boolean users = false;
    
    /**
     * Constructeur
     */
    public CInfos() {
    }
    
    /**
     *
     */
    public void setStaticData(ChannelStaticData sd) throws PortalException {
        staticData = sd;
    }

    /**
     *
     */
    public void setRuntimeData(ChannelRuntimeData rd) throws PortalException {
        runtimeData = rd;
        
        users = (runtimeData.getParameter("users") != null);
        
        servers = new ArrayList();
        
        for(Iterator i = Config.getInstance().getServers().iterator();i.hasNext();) {
            ServerInfo s = (ServerInfo)i.next();
            s.getUsers().clear();
            if(InfosCollector.fetch(s, users)) {
                servers.add(s);
            }
        }
    }

    /**
     *
     */
    public void receiveEvent(PortalEvent ev) {
        
    }

    /**
     *
     */
    public ChannelRuntimeProperties getRuntimeProperties() {
        return new ChannelRuntimeProperties();
    }

    /**
     *
     */
    public void renderXML(ContentHandler out) throws PortalException {
        if(log.isDebugEnabled()) {
			log.debug("CInfos::renderXML()");
		}
		StringBuffer xml = new StringBuffer();
  	
		xml.append("<?xml version=\"1.0\" encoding=\"ISO-8859-1\"?>\n");
		xml.append("<xml>\n"); 
		for(Iterator i = servers.iterator();i.hasNext();) {
		    ServerInfo s = (ServerInfo)i.next();
		    xml.append(s.toXMLString());
		}
		xml.append("</xml>\n");
		
		// Instanciation d'un moteur XSLT
		XSLT xslt = new XSLT(this);
    
		// Le XML est transmis au moteur
		xslt.setXML(xml.toString());
    
		// Dfinition de la feuille de style de slection
		xslt.setXSL("CInfos.xsl");
		
		// Transmissions des paramtres au XSL
		xslt.setStylesheetParameter("baseActionURL",runtimeData.getBaseActionURL());
		xslt.setStylesheetParameter("users", new Boolean(users).toString());
    
		// Dfinition du flux de sortie
		xslt.setTarget(out);
    
		// Lancemement de la transformation
		xslt.transform();
    }
}
