package org.esupportail.portal.channels.CInfos.xml;

import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;

import org.apache.commons.digester.Digester;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.esupportail.portal.channels.CInfos.beans.MemoryInfo;
import org.esupportail.portal.channels.CInfos.beans.ServerInfo;
import org.esupportail.portal.channels.CInfos.beans.SessionInfo;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

/**
 * InfosCollector<br>
 * <br>
 * Description<br>
 * <br>
 * (c)Copyright <a href="http://www.esup-portail.org">ESup-Portail 2004</a><br>
 * @author <a href="mailto:mathieu.larchet@univ-nancy2.fr">Mathieu Larchet</a>
 * @version $Revision: 1.0$
 * 
 */
public class InfosCollector {
    
    protected static Log log = LogFactory.getLog(InfosCollector.class);
    
    /**
     * Rcupre les informations d'un serveur distant
     * @param s L'objet  remplit
     * @return status vrai si tout se passe bien, faux sinon
     */
    public static boolean fetch(ServerInfo s, boolean users) {
        Digester dig = new Digester();
        dig.push(s);
        
        dig.addObjectCreate("runtimeinfo/memory", MemoryInfo.class);
        	dig.addSetProperties("runtimeinfo/memory");
        dig.addSetNext("runtimeinfo/memory", "setMemory");
        
        dig.addObjectCreate("runtimeinfo/sessions", SessionInfo.class);
    	dig.addSetProperties("runtimeinfo/sessions");
    dig.addSetNext("runtimeinfo/sessions", "setSession");
        
        dig.addCallMethod("runtimeinfo/users/user", "addUser", 1);
        dig.addCallParam("runtimeinfo/users/user", 0, "uid");
        
        URL ressourceUrl = null;
        try {
            if(users) {
                ressourceUrl = new URL(s.getUrl() + "?xml=full");
            }
            else {
                ressourceUrl = new URL(s.getUrl() + "?xml");
            }
        }
        catch(MalformedURLException e) {
            log.error(e);
            return false;
        }
        if(ressourceUrl != null) {
            try {
		        // On parse le fichier dont le chemin est pass en paramtre
				dig.parse(new InputSource(ressourceUrl.toExternalForm()));
			}
			catch(IOException e) {
				log.error("InfosCollector::fetch() : Impossible d'ouvrir l'URL \n" + e);
				return false;
			}
			catch(SAXException e) {
			    log.error("InfosCollector::fetch() : SAXException :\n" + e);
			    return false;
			} 
			catch(Exception e) {
			    log.error("InfosCollector::fetch() : Exception :\n" + e);
			    return false;
			}
        }
        else {
            log.error("InfosCollector::fetch() : L'URL est introuvable");
            return false;
        }
        return true;
    }
}